/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.block;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.Set;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.io.TestWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslInputStream;
import org.apache.hadoop.security.SaslRpcClient;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestBlockToken {
    public static final Log LOG = LogFactory.getLog(TestBlockToken.class);
    private static final String ADDRESS = "0.0.0.0";
    static final String SERVER_PRINCIPAL_KEY = "test.ipc.server.principal";
    private static Configuration conf = new Configuration();
    long blockKeyUpdateInterval = 600000L;
    long blockTokenLifetime = 120000L;
    Block block1 = new Block(0L);
    Block block2 = new Block(10L);
    Block block3 = new Block(-108L);

    private BlockTokenIdentifier generateTokenId(BlockTokenSecretManager sm, Block block, EnumSet<BlockTokenSecretManager.AccessMode> accessModes) throws IOException {
        Token token = sm.generateToken(block, accessModes);
        BlockTokenIdentifier id = sm.createIdentifier();
        id.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(token.getIdentifier())));
        return id;
    }

    @Test
    public void testWritable() throws Exception {
        TestWritable.testWritable((Writable)new BlockTokenIdentifier());
        BlockTokenSecretManager sm = new BlockTokenSecretManager(true, this.blockKeyUpdateInterval, this.blockTokenLifetime);
        TestWritable.testWritable((Writable)this.generateTokenId(sm, this.block1, EnumSet.allOf(BlockTokenSecretManager.AccessMode.class)));
        TestWritable.testWritable((Writable)this.generateTokenId(sm, this.block2, EnumSet.of(BlockTokenSecretManager.AccessMode.WRITE)));
        TestWritable.testWritable((Writable)this.generateTokenId(sm, this.block3, EnumSet.noneOf(BlockTokenSecretManager.AccessMode.class)));
    }

    private void tokenGenerationAndVerification(BlockTokenSecretManager master, BlockTokenSecretManager slave) throws Exception {
        for (BlockTokenSecretManager.AccessMode mode : BlockTokenSecretManager.AccessMode.values()) {
            Token token1 = master.generateToken(this.block1, EnumSet.of(mode));
            master.checkAccess(token1, null, this.block1, mode);
            slave.checkAccess(token1, null, this.block1, mode);
            Token token2 = slave.generateToken(this.block2, EnumSet.of(mode));
            master.checkAccess(token2, null, this.block2, mode);
            slave.checkAccess(token2, null, this.block2, mode);
        }
        Token mtoken = master.generateToken(this.block3, EnumSet.allOf(BlockTokenSecretManager.AccessMode.class));
        for (BlockTokenSecretManager.AccessMode mode : BlockTokenSecretManager.AccessMode.values()) {
            master.checkAccess(mtoken, null, this.block3, mode);
            slave.checkAccess(mtoken, null, this.block3, mode);
        }
    }

    @Test
    public void testBlockTokenSecretManager() throws Exception {
        BlockTokenSecretManager masterHandler = new BlockTokenSecretManager(true, this.blockKeyUpdateInterval, this.blockTokenLifetime);
        BlockTokenSecretManager slaveHandler = new BlockTokenSecretManager(false, this.blockKeyUpdateInterval, this.blockTokenLifetime);
        ExportedBlockKeys keys = masterHandler.exportKeys();
        slaveHandler.setKeys(keys);
        this.tokenGenerationAndVerification(masterHandler, slaveHandler);
        masterHandler.updateKeys();
        this.tokenGenerationAndVerification(masterHandler, slaveHandler);
        keys = masterHandler.exportKeys();
        slaveHandler.setKeys(keys);
        this.tokenGenerationAndVerification(masterHandler, slaveHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockTokenRpc() throws Exception {
        BlockTokenSecretManager sm = new BlockTokenSecretManager(true, this.blockKeyUpdateInterval, this.blockTokenLifetime);
        Token token = sm.generateToken(this.block3, EnumSet.allOf(BlockTokenSecretManager.AccessMode.class));
        ClientDatanodeProtocol mockDN = (ClientDatanodeProtocol)Mockito.mock(ClientDatanodeProtocol.class);
        Mockito.when((Object)mockDN.getProtocolVersion(Matchers.anyString(), Matchers.anyLong())).thenReturn((Object)5L);
        BlockTokenIdentifier id = sm.createIdentifier();
        id.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(token.getIdentifier())));
        ((ClientDatanodeProtocol)Mockito.doAnswer((Answer)new getLengthAnswer(sm, id)).when((Object)mockDN)).recoverBlock((Block)Matchers.any(Block.class), Matchers.anyBoolean(), (DatanodeInfo[])Matchers.any(DatanodeInfo[].class));
        RPC.Server server = RPC.getServer((Object)mockDN, (String)ADDRESS, (int)0, (int)5, (boolean)true, (Configuration)conf, (SecretManager)sm);
        server.start();
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        UserGroupInformation ticket = UserGroupInformation.createRemoteUser((String)this.block3.toString());
        ticket.addToken(token);
        ClientDatanodeProtocol proxy = null;
        try {
            proxy = (ClientDatanodeProtocol)RPC.getProxy(ClientDatanodeProtocol.class, (long)5L, (InetSocketAddress)addr, (UserGroupInformation)ticket, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf));
            LocatedBlock lb = proxy.recoverBlock(this.block3, true, null);
            Assert.assertEquals((long)this.block3.getBlockId(), (long)lb.getBlock().getBlockId());
        }
        catch (Throwable throwable) {
            server.stop();
            if (proxy != null) {
                RPC.stopProxy(proxy);
            }
            throw throwable;
        }
        server.stop();
        if (proxy != null) {
            RPC.stopProxy((VersionedProtocol)proxy);
        }
    }

    static {
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        ((Log4JLogger)Client.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)Server.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslRpcClient.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslRpcServer.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslInputStream.LOG).getLogger().setLevel(Level.ALL);
    }

    private static class getLengthAnswer
    implements Answer<LocatedBlock> {
        BlockTokenSecretManager sm;
        BlockTokenIdentifier ident;

        public getLengthAnswer(BlockTokenSecretManager sm, BlockTokenIdentifier ident) {
            this.sm = sm;
            this.ident = ident;
        }

        public LocatedBlock answer(InvocationOnMock invocation) throws IOException {
            Object[] args = invocation.getArguments();
            Assert.assertEquals((long)3L, (long)args.length);
            Block block = (Block)args[0];
            Set tokenIds = UserGroupInformation.getCurrentUser().getTokenIdentifiers();
            Assert.assertEquals((String)"Only one BlockTokenIdentifier expected", (long)1L, (long)tokenIds.size());
            LocatedBlock result = null;
            for (TokenIdentifier tokenId : tokenIds) {
                BlockTokenIdentifier id = (BlockTokenIdentifier)tokenId;
                LOG.info((Object)("Got: " + id.toString()));
                Assert.assertTrue((String)"Received BlockTokenIdentifier is wrong", (boolean)this.ident.equals((Object)id));
                this.sm.checkAccess(id, null, block, BlockTokenSecretManager.AccessMode.WRITE);
                result = new LocatedBlock(new Block(id.getBlockId()), null);
            }
            return result;
        }
    }
}

