/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.tools.rumen.DeepCompare;
import org.apache.hadoop.tools.rumen.DeepInequalityException;
import org.apache.hadoop.tools.rumen.HadoopLogsAnalyzer;
import org.apache.hadoop.tools.rumen.JsonObjectMapperParser;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.LoggedNetworkTopology;
import org.apache.hadoop.tools.rumen.TreePath;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;

public class TestRumenJobTraces {
    @Test
    public void testSmallTrace() throws Exception {
        this.performSingleTest("sample-job-tracker-logs.gz", "job-tracker-logs-topology-output", "job-tracker-logs-trace-output.gz");
    }

    @Test
    public void testTruncatedTask() throws Exception {
        this.performSingleTest("truncated-job-tracker-log", "truncated-topology-output", "truncated-trace-output");
    }

    private void performSingleTest(String jtLogName, String goldTopology, String goldTrace) throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path rootInputDir = new Path(System.getProperty("test.tools.input.dir", "")).makeQualified((FileSystem)lfs);
        Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified((FileSystem)lfs);
        Path rootInputFile = new Path(rootInputDir, "rumen/small-trace-test");
        Path tempDir = new Path(rootTempDir, "TestRumenJobTraces");
        lfs.delete(tempDir, true);
        Path topologyFile = new Path(tempDir, jtLogName + "-topology.json");
        Path traceFile = new Path(tempDir, jtLogName + "-trace.json");
        Path inputFile = new Path(rootInputFile, jtLogName);
        System.out.println("topology result file = " + topologyFile);
        System.out.println("trace result file = " + traceFile);
        String[] args = new String[]{"-v1", "-write-topology", topologyFile.toString(), "-write-job-trace", traceFile.toString(), inputFile.toString()};
        Path topologyGoldFile = new Path(rootInputFile, goldTopology);
        Path traceGoldFile = new Path(rootInputFile, goldTrace);
        HadoopLogsAnalyzer analyzer = new HadoopLogsAnalyzer();
        int result = ToolRunner.run((Tool)analyzer, (String[])args);
        Assert.assertEquals((String)"Non-zero exit", (long)0L, (long)result);
        TestRumenJobTraces.jsonFileMatchesGold((FileSystem)lfs, topologyFile, topologyGoldFile, LoggedNetworkTopology.class, "topology");
        TestRumenJobTraces.jsonFileMatchesGold((FileSystem)lfs, traceFile, traceGoldFile, LoggedJob.class, "trace");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static <T extends DeepCompare> void jsonFileMatchesGold(FileSystem lfs, Path result, Path gold, Class<? extends T> clazz, String fileDescription) throws IOException {
        JsonObjectMapperParser resultParser;
        JsonObjectMapperParser goldParser;
        block7: {
            goldParser = new JsonObjectMapperParser(gold, clazz, new Configuration());
            FSDataInputStream resultStream = lfs.open(result);
            resultParser = new JsonObjectMapperParser((InputStream)resultStream, clazz);
            block4: while (true) {
                while (true) {
                    DeepCompare goldJob = (DeepCompare)goldParser.getNext();
                    DeepCompare resultJob = (DeepCompare)resultParser.getNext();
                    if (goldJob == null || resultJob == null) {
                        Assert.assertTrue((goldJob == resultJob ? 1 : 0) != 0);
                        break block4;
                    }
                    try {
                        resultJob.deepCompare(goldJob, new TreePath(null, "<root>"));
                        continue block4;
                    }
                    catch (DeepInequalityException e) {
                        String error = e.path.toString();
                        Assert.assertFalse((String)(fileDescription + " mismatches: " + error), (boolean)true);
                        continue;
                    }
                    break;
                }
            }
            break block7;
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{goldParser, resultParser});
                throw throwable;
            }
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{goldParser, resultParser});
    }
}

