/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.net.SocketInputStream;
import org.apache.hadoop.net.SocketOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class TestSocketIOWithTimeout {
    static Log LOG = LogFactory.getLog(TestSocketIOWithTimeout.class);
    private static int TIMEOUT = 1000;
    private static String TEST_STRING = "1234567890";

    private void doIO(InputStream in, OutputStream out, int expectedTimeout) throws IOException {
        byte[] buf = new byte[4192];
        while (true) {
            long start = System.currentTimeMillis();
            try {
                if (in != null) {
                    in.read(buf);
                    continue;
                }
                out.write(buf);
            }
            catch (SocketTimeoutException e) {
                long diff = System.currentTimeMillis() - start;
                LOG.info((Object)("Got SocketTimeoutException as expected after " + diff + " millis : " + e.getMessage()));
                Assert.assertTrue((Math.abs((long)expectedTimeout - diff) <= 200L ? 1 : 0) != 0);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSocketIOWithTimeout() throws Exception {
        Pipe pipe = Pipe.open();
        Pipe.SourceChannel source = pipe.source();
        Pipe.SinkChannel sink = pipe.sink();
        try {
            SocketInputStream in = new SocketInputStream((ReadableByteChannel)source, (long)TIMEOUT);
            SocketOutputStream out = new SocketOutputStream((WritableByteChannel)sink, (long)TIMEOUT);
            byte[] writeBytes = TEST_STRING.getBytes();
            byte[] readBytes = new byte[writeBytes.length];
            out.write(writeBytes);
            this.doIO(null, (OutputStream)out, TIMEOUT);
            in.read(readBytes);
            Assert.assertTrue((boolean)Arrays.equals(writeBytes, readBytes));
            this.doIO((InputStream)in, null, TIMEOUT);
            in.setTimeout((long)(TIMEOUT * 2));
            this.doIO((InputStream)in, null, TIMEOUT * 2);
            in.setTimeout(0L);
            ReadThread thread = new ReadThread((InputStream)in);
            thread.start();
            Thread.sleep(1000L);
            thread.interrupt();
            thread.join();
            if (thread.thrown != null) {
                throw new RuntimeException(thread.thrown);
            }
            Assert.assertTrue((boolean)source.isOpen());
            Assert.assertTrue((boolean)sink.isOpen());
            try {
                out.write(1);
                Assert.fail((String)"Did not throw");
            }
            catch (IOException ioe) {
                Assert.assertTrue((boolean)ioe.getMessage().contains("stream is closed"));
            }
            out.close();
            Assert.assertFalse((boolean)sink.isOpen());
            Assert.assertEquals((long)-1L, (long)in.read());
            in.close();
            Assert.assertFalse((boolean)source.isOpen());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (sink != null) {
                sink.close();
            }
        }
    }

    static class ReadThread
    extends Thread {
        private InputStream in;
        private volatile Throwable thrown = null;

        public ReadThread(InputStream in) {
            this.in = in;
        }

        @Override
        public void run() {
            try {
                try {
                    this.in.read();
                }
                catch (IOException e) {
                    LOG.info((Object)("Got expection while reading as expected : " + e.getMessage()));
                    return;
                }
                Assert.assertTrue((boolean)false);
            }
            catch (Throwable t) {
                this.thrown = t;
            }
        }
    }
}

