/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.TestDoAsEffectiveUser;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.Token;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestDelegationTokenForProxyUser {
    private MiniDFSCluster cluster;
    Configuration config;
    private static final String GROUP1_NAME = "group1";
    private static final String GROUP2_NAME = "group2";
    private static final String[] GROUP_NAMES = new String[]{"group1", "group2"};
    private static final String REAL_USER = "RealUser";
    private static final String PROXY_USER = "ProxyUser";
    private static final Log LOG = LogFactory.getLog(TestDoAsEffectiveUser.class);

    private void configureSuperUserIPAddresses(Configuration conf, String superUserShortName) throws IOException {
        ArrayList<String> ipList = new ArrayList<String>();
        Enumeration<NetworkInterface> netInterfaceList = NetworkInterface.getNetworkInterfaces();
        while (netInterfaceList.hasMoreElements()) {
            NetworkInterface inf = netInterfaceList.nextElement();
            Enumeration<InetAddress> addrList = inf.getInetAddresses();
            while (addrList.hasMoreElements()) {
                InetAddress addr = addrList.nextElement();
                ipList.add(addr.getHostAddress());
            }
        }
        StringBuilder builder = new StringBuilder();
        for (String ip : ipList) {
            builder.append(ip);
            builder.append(',');
        }
        builder.append("127.0.1.1,");
        builder.append(InetAddress.getLocalHost().getCanonicalHostName());
        LOG.info((Object)("Local Ip addresses: " + builder.toString()));
        conf.setStrings(ProxyUsers.getProxySuperuserIpConfKey((String)superUserShortName), new String[]{builder.toString()});
    }

    @Before
    public void setUp() throws Exception {
        this.config = new Configuration();
        this.config.setLong("dfs.namenode.delegation.token.max-lifetime", 10000L);
        this.config.setLong("dfs.namenode.delegation.token.renew-interval", 5000L);
        this.config.setStrings(ProxyUsers.getProxySuperuserGroupConfKey((String)REAL_USER), new String[]{GROUP1_NAME});
        this.configureSuperUserIPAddresses(this.config, REAL_USER);
        FileSystem.setDefaultUri((Configuration)this.config, (String)"hdfs://localhost:0");
        this.cluster = new MiniDFSCluster(0, this.config, 1, true, true, true, null, null, null, null);
        this.cluster.waitActive();
        this.cluster.getNameNode().getNamesystem().getDelegationTokenSecretManager().startThreads();
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.config);
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testDelegationTokenWithRealUser() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)REAL_USER);
        UserGroupInformation proxyUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER, (UserGroupInformation)ugi, (String[])GROUP_NAMES);
        try {
            Token token = (Token)proxyUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Token<DelegationTokenIdentifier>>(){

                @Override
                public Token<DelegationTokenIdentifier> run() throws IOException {
                    DistributedFileSystem dfs = (DistributedFileSystem)TestDelegationTokenForProxyUser.this.cluster.getFileSystem();
                    return dfs.getDelegationToken(new Text("RenewerUser"));
                }
            });
            DelegationTokenIdentifier identifier = new DelegationTokenIdentifier();
            byte[] tokenId = token.getIdentifier();
            identifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(tokenId)));
            Assert.assertEquals((String)identifier.getUser().getUserName(), (String)PROXY_USER);
            Assert.assertEquals((String)identifier.getUser().getRealUser().getUserName(), (String)REAL_USER);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

