/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDatanodeBlockScanner;

public class TestMissingBlocksAlert
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestMissingBlocksAlert.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMissingBlocksAlert() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        try {
            Configuration conf = new Configuration();
            conf.setInt("dfs.replication.interval", 0);
            int fileLen = 10240;
            cluster = new MiniDFSCluster(conf, 1, true, null);
            cluster.waitActive();
            DistributedFileSystem dfs = (DistributedFileSystem)cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)dfs, new Path("/testMissingBlocksAlert/file1"), fileLen, (short)3, 0L);
            Path corruptFile = new Path("/testMissingBlocks/corruptFile");
            DFSTestUtil.createFile((FileSystem)dfs, corruptFile, fileLen, (short)3, 0L);
            String block = DFSTestUtil.getFirstBlock((FileSystem)dfs, corruptFile).getBlockName();
            TestDatanodeBlockScanner.corruptReplica(block, 0);
            FSDataInputStream in = dfs.open(corruptFile);
            try {
                in.readFully(new byte[fileLen]);
            }
            catch (ChecksumException ignored) {
                // empty catch block
            }
            in.close();
            LOG.info((Object)"Waiting for missing blocks count to increase...");
            while (dfs.getMissingBlocksCount() <= 0L) {
                Thread.sleep(100L);
            }
            TestMissingBlocksAlert.assertTrue((dfs.getMissingBlocksCount() == 1L ? 1 : 0) != 0);
            URL url = new URL("http://" + conf.get("dfs.http.address") + "/dfshealth.jsp");
            String dfsFrontPage = DFSTestUtil.urlGet(url);
            String warnStr = "WARNING : There are about ";
            TestMissingBlocksAlert.assertTrue((String)"HDFS Front page does not contain expected warning", (boolean)dfsFrontPage.contains(warnStr + "1 missing blocks"));
            dfs.delete(corruptFile, true);
            LOG.info((Object)"Waiting for missing blocks count to be zero...");
            while (dfs.getMissingBlocksCount() > 0L) {
                Thread.sleep(100L);
            }
            dfsFrontPage = DFSTestUtil.urlGet(url);
            TestMissingBlocksAlert.assertFalse((String)"HDFS Front page contains unexpected warning", (boolean)dfsFrontPage.contains(warnStr));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

