/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Semaphore;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;

public class TestFileSystemCaching
extends TestCase {
    public void testCacheEnabledWithInitializeForeverFS() throws Exception {
        final Configuration conf = new Configuration();
        Thread t = new Thread(){

            @Override
            public void run() {
                conf.set("fs.localfs1.impl", "org.apache.hadoop.fs.TestFileSystemCaching$InitializeForeverFileSystem");
                try {
                    FileSystem.get((URI)new URI("localfs1://a"), (Configuration)conf);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        InitializeForeverFileSystem.sem.acquire();
        conf.set("fs.cachedfile.impl", conf.get("fs.file.impl"));
        FileSystem.get((URI)new URI("cachedfile://a"), (Configuration)conf);
        t.interrupt();
        t.join();
    }

    public void testFsUniqueness() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.cachedfile.impl", conf.get("fs.file.impl"));
        FileSystem fs1 = FileSystem.get((Configuration)conf);
        FileSystem fs2 = FileSystem.get((Configuration)conf);
        TestFileSystemCaching.assertTrue((fs1 == fs2 ? 1 : 0) != 0);
        fs1 = FileSystem.newInstance((URI)new URI("cachedfile://a"), (Configuration)conf, (String)"bar");
        fs2 = FileSystem.newInstance((URI)new URI("cachedfile://a"), (Configuration)conf, (String)"bar");
        TestFileSystemCaching.assertTrue((fs1 != fs2 && !fs1.equals(fs2) ? 1 : 0) != 0);
        fs1.close();
        fs2.close();
    }

    public static class InitializeForeverFileSystem
    extends LocalFileSystem {
        static final Semaphore sem = new Semaphore(0);

        public void initialize(URI uri, Configuration conf) throws IOException {
            sem.release();
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

