/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;

public class TestStringUtils
extends TestCase {
    private static final String NULL_STR = null;
    private static final String EMPTY_STR = "";
    private static final String STR_WO_SPECIAL_CHARS = "AB";
    private static final String STR_WITH_COMMA = "A,B";
    private static final String ESCAPED_STR_WITH_COMMA = "A\\,B";
    private static final String STR_WITH_ESCAPE = "AB\\";
    private static final String ESCAPED_STR_WITH_ESCAPE = "AB\\\\";
    private static final String STR_WITH_BOTH2 = ",A\\,,B\\\\,";
    private static final String ESCAPED_STR_WITH_BOTH2 = "\\,A\\\\\\,\\,B\\\\\\\\\\,";

    public void testEscapeString() throws Exception {
        TestStringUtils.assertEquals((String)NULL_STR, (String)StringUtils.escapeString((String)NULL_STR));
        TestStringUtils.assertEquals((String)EMPTY_STR, (String)StringUtils.escapeString((String)EMPTY_STR));
        TestStringUtils.assertEquals((String)STR_WO_SPECIAL_CHARS, (String)StringUtils.escapeString((String)STR_WO_SPECIAL_CHARS));
        TestStringUtils.assertEquals((String)ESCAPED_STR_WITH_COMMA, (String)StringUtils.escapeString((String)STR_WITH_COMMA));
        TestStringUtils.assertEquals((String)ESCAPED_STR_WITH_ESCAPE, (String)StringUtils.escapeString((String)STR_WITH_ESCAPE));
        TestStringUtils.assertEquals((String)ESCAPED_STR_WITH_BOTH2, (String)StringUtils.escapeString((String)STR_WITH_BOTH2));
    }

    public void testSplit() throws Exception {
        TestStringUtils.assertEquals((Object)NULL_STR, (Object)StringUtils.split((String)NULL_STR));
        String[] splits = StringUtils.split((String)EMPTY_STR);
        TestStringUtils.assertEquals((int)0, (int)splits.length);
        splits = StringUtils.split((String)",,");
        TestStringUtils.assertEquals((int)0, (int)splits.length);
        splits = StringUtils.split((String)STR_WO_SPECIAL_CHARS);
        TestStringUtils.assertEquals((int)1, (int)splits.length);
        TestStringUtils.assertEquals((String)STR_WO_SPECIAL_CHARS, (String)splits[0]);
        splits = StringUtils.split((String)STR_WITH_COMMA);
        TestStringUtils.assertEquals((int)2, (int)splits.length);
        TestStringUtils.assertEquals((String)"A", (String)splits[0]);
        TestStringUtils.assertEquals((String)"B", (String)splits[1]);
        splits = StringUtils.split((String)ESCAPED_STR_WITH_COMMA);
        TestStringUtils.assertEquals((int)1, (int)splits.length);
        TestStringUtils.assertEquals((String)ESCAPED_STR_WITH_COMMA, (String)splits[0]);
        splits = StringUtils.split((String)STR_WITH_ESCAPE);
        TestStringUtils.assertEquals((int)1, (int)splits.length);
        TestStringUtils.assertEquals((String)STR_WITH_ESCAPE, (String)splits[0]);
        splits = StringUtils.split((String)STR_WITH_BOTH2);
        TestStringUtils.assertEquals((int)3, (int)splits.length);
        TestStringUtils.assertEquals((String)EMPTY_STR, (String)splits[0]);
        TestStringUtils.assertEquals((String)"A\\,", (String)splits[1]);
        TestStringUtils.assertEquals((String)"B\\\\", (String)splits[2]);
        splits = StringUtils.split((String)ESCAPED_STR_WITH_BOTH2);
        TestStringUtils.assertEquals((int)1, (int)splits.length);
        TestStringUtils.assertEquals((String)ESCAPED_STR_WITH_BOTH2, (String)splits[0]);
    }

    public void testUnescapeString() throws Exception {
        TestStringUtils.assertEquals((String)NULL_STR, (String)StringUtils.unEscapeString((String)NULL_STR));
        TestStringUtils.assertEquals((String)EMPTY_STR, (String)StringUtils.unEscapeString((String)EMPTY_STR));
        TestStringUtils.assertEquals((String)STR_WO_SPECIAL_CHARS, (String)StringUtils.unEscapeString((String)STR_WO_SPECIAL_CHARS));
        try {
            StringUtils.unEscapeString((String)STR_WITH_COMMA);
            TestStringUtils.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        TestStringUtils.assertEquals((String)STR_WITH_COMMA, (String)StringUtils.unEscapeString((String)ESCAPED_STR_WITH_COMMA));
        try {
            StringUtils.unEscapeString((String)STR_WITH_ESCAPE);
            TestStringUtils.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        TestStringUtils.assertEquals((String)STR_WITH_ESCAPE, (String)StringUtils.unEscapeString((String)ESCAPED_STR_WITH_ESCAPE));
        try {
            StringUtils.unEscapeString((String)STR_WITH_BOTH2);
            TestStringUtils.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TestStringUtils.assertEquals((String)STR_WITH_BOTH2, (String)StringUtils.unEscapeString((String)ESCAPED_STR_WITH_BOTH2));
    }

    public void testTraditionalBinaryPrefix() throws Exception {
        String[] symbol = new String[]{"k", "m", "g", "t", "p", "e"};
        long m = 1024L;
        for (String s : symbol) {
            TestStringUtils.assertEquals((long)0L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)(0 + s)));
            TestStringUtils.assertEquals((long)m, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)(1 + s)));
            m *= 1024L;
        }
        TestStringUtils.assertEquals((long)0L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"0"));
        TestStringUtils.assertEquals((long)-1259520L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"-1230k"));
        TestStringUtils.assertEquals((long)956703965184L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"891g"));
    }

    public void testGetTrimmedStrings() throws Exception {
        String compactDirList = "/spindle1/hdfs,/spindle2/hdfs,/spindle3/hdfs";
        String spacedDirList = "/spindle1/hdfs, /spindle2/hdfs, /spindle3/hdfs";
        String pathologicalDirList1 = " /spindle1/hdfs  ,  /spindle2/hdfs ,/spindle3/hdfs ";
        String pathologicalDirList2 = " /spindle1/hdfs  ,  /spindle2/hdfs ,/spindle3/hdfs , ";
        String emptyList1 = EMPTY_STR;
        String emptyList2 = "   ";
        Object[] expectedArray = new String[]{"/spindle1/hdfs", "/spindle2/hdfs", "/spindle3/hdfs"};
        Object[] emptyArray = new String[]{};
        Assert.assertArrayEquals((Object[])expectedArray, (Object[])StringUtils.getTrimmedStrings((String)compactDirList));
        Assert.assertArrayEquals((Object[])expectedArray, (Object[])StringUtils.getTrimmedStrings((String)spacedDirList));
        Assert.assertArrayEquals((Object[])expectedArray, (Object[])StringUtils.getTrimmedStrings((String)pathologicalDirList1));
        Assert.assertArrayEquals((Object[])expectedArray, (Object[])StringUtils.getTrimmedStrings((String)pathologicalDirList2));
        Assert.assertArrayEquals((Object[])emptyArray, (Object[])StringUtils.getTrimmedStrings((String)emptyList1));
        Assert.assertArrayEquals((Object[])emptyArray, (Object[])StringUtils.getTrimmedStrings((String)emptyList2));
    }

    public void testJoin() {
        ArrayList<String> s = new ArrayList<String>();
        s.add(EMPTY_STR);
        s.add("a");
        s.add("b");
        s.add("c");
        this.checkJoin(EMPTY_STR, s.subList(0, 0));
        this.checkJoin(":a", s.subList(0, 2));
        this.checkJoin(":a:b", s.subList(0, 3));
        this.checkJoin(":a:b:c", s.subList(0, 4));
    }

    private void checkJoin(String result, List<String> list) {
        String[] a = new String[list.size()];
        TestStringUtils.assertEquals((String)result, (String)StringUtils.join((CharSequence)":", list));
        TestStringUtils.assertEquals((String)result, (String)StringUtils.join((CharSequence)":", (String[])list.toArray(a)));
    }

    public void testCamelize() {
        TestStringUtils.assertEquals((String)"Map", (String)StringUtils.camelize((String)"MAP"));
        TestStringUtils.assertEquals((String)"JobSetup", (String)StringUtils.camelize((String)"JOB_SETUP"));
        TestStringUtils.assertEquals((String)"SomeStuff", (String)StringUtils.camelize((String)"some_stuff"));
        TestStringUtils.assertEquals((String)"Aa", (String)StringUtils.camelize((String)"aA"));
        TestStringUtils.assertEquals((String)"Bb", (String)StringUtils.camelize((String)"bB"));
        TestStringUtils.assertEquals((String)"Cc", (String)StringUtils.camelize((String)"cC"));
        TestStringUtils.assertEquals((String)"Dd", (String)StringUtils.camelize((String)"dD"));
        TestStringUtils.assertEquals((String)"Ee", (String)StringUtils.camelize((String)"eE"));
        TestStringUtils.assertEquals((String)"Ff", (String)StringUtils.camelize((String)"fF"));
        TestStringUtils.assertEquals((String)"Gg", (String)StringUtils.camelize((String)"gG"));
        TestStringUtils.assertEquals((String)"Hh", (String)StringUtils.camelize((String)"hH"));
        TestStringUtils.assertEquals((String)"Ii", (String)StringUtils.camelize((String)"iI"));
        TestStringUtils.assertEquals((String)"Jj", (String)StringUtils.camelize((String)"jJ"));
        TestStringUtils.assertEquals((String)"Kk", (String)StringUtils.camelize((String)"kK"));
        TestStringUtils.assertEquals((String)"Ll", (String)StringUtils.camelize((String)"lL"));
        TestStringUtils.assertEquals((String)"Mm", (String)StringUtils.camelize((String)"mM"));
        TestStringUtils.assertEquals((String)"Nn", (String)StringUtils.camelize((String)"nN"));
        TestStringUtils.assertEquals((String)"Oo", (String)StringUtils.camelize((String)"oO"));
        TestStringUtils.assertEquals((String)"Pp", (String)StringUtils.camelize((String)"pP"));
        TestStringUtils.assertEquals((String)"Qq", (String)StringUtils.camelize((String)"qQ"));
        TestStringUtils.assertEquals((String)"Rr", (String)StringUtils.camelize((String)"rR"));
        TestStringUtils.assertEquals((String)"Ss", (String)StringUtils.camelize((String)"sS"));
        TestStringUtils.assertEquals((String)"Tt", (String)StringUtils.camelize((String)"tT"));
        TestStringUtils.assertEquals((String)"Uu", (String)StringUtils.camelize((String)"uU"));
        TestStringUtils.assertEquals((String)"Vv", (String)StringUtils.camelize((String)"vV"));
        TestStringUtils.assertEquals((String)"Ww", (String)StringUtils.camelize((String)"wW"));
        TestStringUtils.assertEquals((String)"Xx", (String)StringUtils.camelize((String)"xX"));
        TestStringUtils.assertEquals((String)"Yy", (String)StringUtils.camelize((String)"yY"));
        TestStringUtils.assertEquals((String)"Zz", (String)StringUtils.camelize((String)"zZ"));
    }
}

