/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.util.StringUtils;

public class TestProxyUsers
extends TestCase {
    private static final String REAL_USER_NAME = "proxier";
    private static final String PROXY_USER_NAME = "proxied_user";
    private static final String[] GROUP_NAMES = new String[]{"foo_group"};
    private static final String[] OTHER_GROUP_NAMES = new String[]{"bar_group"};
    private static final String PROXY_IP = "1.2.3.4";

    public void testProxyUsers() throws Exception {
        Configuration conf = new Configuration();
        conf.set(ProxyUsers.getProxySuperuserGroupConfKey((String)REAL_USER_NAME), StringUtils.join((CharSequence)",", Arrays.asList(GROUP_NAMES)));
        conf.set(ProxyUsers.getProxySuperuserIpConfKey((String)REAL_USER_NAME), PROXY_IP);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
        this.assertAuthorized(proxyUserUgi, PROXY_IP);
        this.assertNotAuthorized(proxyUserUgi, "1.2.3.5");
        realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])OTHER_GROUP_NAMES);
        this.assertNotAuthorized(proxyUserUgi, PROXY_IP);
        this.assertNotAuthorized(proxyUserUgi, "1.2.3.5");
    }

    public void testWildcardGroup() {
        Configuration conf = new Configuration();
        conf.set(ProxyUsers.getProxySuperuserGroupConfKey((String)REAL_USER_NAME), "*");
        conf.set(ProxyUsers.getProxySuperuserIpConfKey((String)REAL_USER_NAME), PROXY_IP);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
        this.assertAuthorized(proxyUserUgi, PROXY_IP);
        this.assertNotAuthorized(proxyUserUgi, "1.2.3.5");
        realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])OTHER_GROUP_NAMES);
        this.assertAuthorized(proxyUserUgi, PROXY_IP);
        this.assertNotAuthorized(proxyUserUgi, "1.2.3.5");
    }

    public void testWildcardIP() {
        Configuration conf = new Configuration();
        conf.set(ProxyUsers.getProxySuperuserGroupConfKey((String)REAL_USER_NAME), StringUtils.join((CharSequence)",", Arrays.asList(GROUP_NAMES)));
        conf.set(ProxyUsers.getProxySuperuserIpConfKey((String)REAL_USER_NAME), "*");
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])GROUP_NAMES);
        this.assertAuthorized(proxyUserUgi, PROXY_IP);
        this.assertAuthorized(proxyUserUgi, "1.2.3.5");
        realUserUgi = UserGroupInformation.createRemoteUser((String)REAL_USER_NAME);
        proxyUserUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER_NAME, (UserGroupInformation)realUserUgi, (String[])OTHER_GROUP_NAMES);
        this.assertNotAuthorized(proxyUserUgi, PROXY_IP);
        this.assertNotAuthorized(proxyUserUgi, "1.2.3.5");
    }

    private void assertNotAuthorized(UserGroupInformation proxyUgi, String host) {
        try {
            ProxyUsers.authorize((UserGroupInformation)proxyUgi, (String)host, null);
            TestProxyUsers.fail((String)("Allowed authorization of " + proxyUgi + " from " + host));
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    private void assertAuthorized(UserGroupInformation proxyUgi, String host) {
        try {
            ProxyUsers.authorize((UserGroupInformation)proxyUgi, (String)host, null);
        }
        catch (AuthorizationException e) {
            TestProxyUsers.fail((String)("Did not allowed authorization of " + proxyUgi + " from " + host));
        }
    }
}

