/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.hadoop.security.SecurityUtil;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;

public class TestSecurityUtil {
    @Test
    public void isOriginalTGTReturnsCorrectValues() {
        Assert.assertTrue((boolean)SecurityUtil.isOriginalTGT((String)"krbtgt/foo@foo"));
        Assert.assertTrue((boolean)SecurityUtil.isOriginalTGT((String)"krbtgt/foo.bar.bat@foo.bar.bat"));
        Assert.assertFalse((boolean)SecurityUtil.isOriginalTGT(null));
        Assert.assertFalse((boolean)SecurityUtil.isOriginalTGT((String)"blah"));
        Assert.assertFalse((boolean)SecurityUtil.isOriginalTGT((String)""));
        Assert.assertFalse((boolean)SecurityUtil.isOriginalTGT((String)"krbtgt/hello"));
        Assert.assertFalse((boolean)SecurityUtil.isOriginalTGT((String)"/@"));
        Assert.assertFalse((boolean)SecurityUtil.isOriginalTGT((String)"this@is/notright"));
        Assert.assertFalse((boolean)SecurityUtil.isOriginalTGT((String)"krbtgt/foo@FOO"));
    }

    private void verify(String original, String hostname, String expected) throws IOException {
        Assert.assertEquals((Object)expected, (Object)SecurityUtil.getServerPrincipal((String)original, (String)hostname));
        InetAddress addr = this.mockAddr(hostname);
        Assert.assertEquals((Object)expected, (Object)SecurityUtil.getServerPrincipal((String)original, (InetAddress)addr));
    }

    private InetAddress mockAddr(String reverseTo) {
        InetAddress mock = (InetAddress)Mockito.mock(InetAddress.class);
        ((InetAddress)Mockito.doReturn((Object)reverseTo).when((Object)mock)).getCanonicalHostName();
        return mock;
    }

    @Test
    public void testGetServerPrincipal() throws IOException {
        String service = "hdfs/";
        String realm = "@REALM";
        String hostname = "foohost";
        String userPrincipal = "foo@FOOREALM";
        String shouldReplace = service + "_HOST" + realm;
        String replaced = service + hostname + realm;
        this.verify(shouldReplace, hostname, replaced);
        String shouldNotReplace = service + "_HOST" + "NAME" + realm;
        this.verify(shouldNotReplace, hostname, shouldNotReplace);
        this.verify(userPrincipal, hostname, userPrincipal);
        InetAddress notUsed = (InetAddress)Mockito.mock(InetAddress.class);
        Assert.assertEquals((Object)shouldNotReplace, (Object)SecurityUtil.getServerPrincipal((String)shouldNotReplace, (InetAddress)notUsed));
        ((InetAddress)Mockito.verify((Object)notUsed, (VerificationMode)Mockito.never())).getCanonicalHostName();
    }

    @Test
    public void testLocalHostNameForNullOrWild() throws Exception {
        String local = SecurityUtil.getLocalHostName();
        Assert.assertEquals((Object)("hdfs/" + local + "@REALM"), (Object)SecurityUtil.getServerPrincipal((String)"hdfs/_HOST@REALM", (String)null));
        Assert.assertEquals((Object)("hdfs/" + local + "@REALM"), (Object)SecurityUtil.getServerPrincipal((String)"hdfs/_HOST@REALM", (String)"0.0.0.0"));
    }
}

