/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.mapred.Clock;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.SortValidator;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.UserLogEvent;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.UserLogManager;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;

public class UtilsForTests {
    static final Log LOG = LogFactory.getLog(UtilsForTests.class);
    static final long KB = 1024L;
    static final long MB = 0x100000L;
    static final long GB = 0x40000000L;
    static final long TB = 0x10000000000L;
    static final long PB = 0x4000000000000L;
    static final Object waitLock = new Object();
    static DecimalFormat dfm = new DecimalFormat("####.000");
    static DecimalFormat ifm = new DecimalFormat("###,###,###,###,###");
    static final String regexpSpecials = "[]()?*+|.!^-\\~@";
    static char[] space = new char[300];

    public static String dfmt(double d) {
        return dfm.format(d);
    }

    public static String ifmt(double d) {
        return ifm.format(d);
    }

    public static String formatBytes(long numBytes) {
        StringBuffer buf = new StringBuffer();
        boolean bDetails = true;
        double num = numBytes;
        if (numBytes < 1024L) {
            buf.append(numBytes + " B");
            bDetails = false;
        } else if (numBytes < 0x100000L) {
            buf.append(UtilsForTests.dfmt(num / 1024.0) + " KB");
        } else if (numBytes < 0x40000000L) {
            buf.append(UtilsForTests.dfmt(num / 1048576.0) + " MB");
        } else if (numBytes < 0x10000000000L) {
            buf.append(UtilsForTests.dfmt(num / 1.073741824E9) + " GB");
        } else if (numBytes < 0x4000000000000L) {
            buf.append(UtilsForTests.dfmt(num / 1.099511627776E12) + " TB");
        } else {
            buf.append(UtilsForTests.dfmt(num / 1.125899906842624E15) + " PB");
        }
        if (bDetails) {
            buf.append(" (" + UtilsForTests.ifmt(numBytes) + " bytes)");
        }
        return buf.toString();
    }

    public static String formatBytes2(long numBytes) {
        StringBuffer buf = new StringBuffer();
        long u = 0L;
        if (numBytes >= 0x10000000000L) {
            u = numBytes / 0x10000000000L;
            numBytes -= u * 0x10000000000L;
            buf.append(u + " TB ");
        }
        if (numBytes >= 0x40000000L) {
            u = numBytes / 0x40000000L;
            numBytes -= u * 0x40000000L;
            buf.append(u + " GB ");
        }
        if (numBytes >= 0x100000L) {
            u = numBytes / 0x100000L;
            numBytes -= u * 0x100000L;
            buf.append(u + " MB ");
        }
        if (numBytes >= 1024L) {
            u = numBytes / 1024L;
            numBytes -= u * 1024L;
            buf.append(u + " KB ");
        }
        buf.append(u + " B");
        return buf.toString();
    }

    public static String regexpEscape(String plain) {
        StringBuffer buf = new StringBuffer();
        char[] ch = plain.toCharArray();
        int csup = ch.length;
        for (int c = 0; c < csup; ++c) {
            if (regexpSpecials.indexOf(ch[c]) != -1) {
                buf.append("\\");
            }
            buf.append(ch[c]);
        }
        return buf.toString();
    }

    public static String safeGetCanonicalPath(File f) {
        try {
            String s = f.getCanonicalPath();
            return s == null ? f.toString() : s;
        }
        catch (IOException io) {
            return f.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String slurp(File f) throws IOException {
        int len = (int)f.length();
        byte[] buf = new byte[len];
        FileInputStream in = new FileInputStream(f);
        String contents = null;
        try {
            in.read(buf, 0, len);
            contents = new String(buf, "UTF-8");
        }
        finally {
            in.close();
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String slurpHadoop(Path p, FileSystem fs) throws IOException {
        int len = (int)fs.getLength(p);
        byte[] buf = new byte[len];
        FSDataInputStream in = fs.open(p);
        String contents = null;
        try {
            in.read(buf, 0, len);
            contents = new String(buf, "UTF-8");
        }
        finally {
            in.close();
        }
        return contents;
    }

    public static String rjustify(String s, int width) {
        if (s == null) {
            s = "null";
        }
        if (width > s.length()) {
            s = UtilsForTests.getSpace(width - s.length()) + s;
        }
        return s;
    }

    public static String ljustify(String s, int width) {
        if (s == null) {
            s = "null";
        }
        if (width > s.length()) {
            s = s + UtilsForTests.getSpace(width - s.length());
        }
        return s;
    }

    public static String getSpace(int len) {
        if (len > space.length) {
            space = new char[Math.max(len, 2 * space.length)];
            Arrays.fill(space, ' ');
        }
        return new String(space, 0, len);
    }

    static JobStatus getJobStatus(JobClient jc, JobID id) throws IOException {
        JobStatus[] statuses;
        for (JobStatus jobStatus : statuses = jc.getAllJobs()) {
            if (!jobStatus.getJobID().equals((Object)id)) continue;
            return jobStatus;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitFor(long duration) {
        try {
            Object object = waitLock;
            synchronized (object) {
                waitLock.wait(duration);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void waitForJobTracker(JobClient jobClient) {
        while (true) {
            try {
                ClusterStatus status = jobClient.getClusterStatus();
                while (status.getJobTrackerState() != JobTracker.State.RUNNING) {
                    UtilsForTests.waitFor(100L);
                    status = jobClient.getClusterStatus();
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    static void waitTillDone(JobClient jobClient) throws IOException {
        while (true) {
            boolean shouldWait = false;
            for (JobStatus jobStatuses : jobClient.getAllJobs()) {
                if (jobStatuses.getRunState() == 2 || jobStatuses.getRunState() == 3 || jobStatuses.getRunState() == 5) continue;
                shouldWait = true;
                break;
            }
            if (!shouldWait) break;
            UtilsForTests.waitFor(1000L);
        }
    }

    static void configureWaitingJobConf(JobConf jobConf, Path inDir, Path outputPath, int numMaps, int numRed, String jobName, String mapSignalFilename, String redSignalFilename) throws IOException {
        jobConf.setJobName(jobName);
        jobConf.setInputFormat(SortValidator.RecordStatsChecker.NonSplitableSequenceFileInputFormat.class);
        jobConf.setOutputFormat(SequenceFileOutputFormat.class);
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)outputPath);
        jobConf.setMapperClass(HalfWaitingMapper.class);
        jobConf.setReducerClass(IdentityReducer.class);
        jobConf.setOutputKeyClass(BytesWritable.class);
        jobConf.setOutputValueClass(BytesWritable.class);
        jobConf.setInputFormat(RandomInputFormat.class);
        jobConf.setNumMapTasks(numMaps);
        jobConf.setNumReduceTasks(numRed);
        jobConf.setJar("build/test/testjar/testjob.jar");
        jobConf.set(UtilsForTests.getTaskSignalParameter(true), mapSignalFilename);
        jobConf.set(UtilsForTests.getTaskSignalParameter(false), redSignalFilename);
    }

    static String getTaskSignalParameter(boolean isMap) {
        return isMap ? "test.mapred.map.waiting.target" : "test.mapred.reduce.waiting.target";
    }

    static void signalTasks(MiniDFSCluster dfs, FileSystem fileSys, String mapSignalFile, String reduceSignalFile, int replication) throws IOException {
        UtilsForTests.writeFile(dfs.getNameNode(), fileSys.getConf(), new Path(mapSignalFile), (short)replication);
        UtilsForTests.writeFile(dfs.getNameNode(), fileSys.getConf(), new Path(reduceSignalFile), (short)replication);
    }

    static void signalTasks(MiniDFSCluster dfs, FileSystem fileSys, boolean isMap, String mapSignalFile, String reduceSignalFile) throws IOException {
        UtilsForTests.writeFile(dfs.getNameNode(), fileSys.getConf(), isMap ? new Path(mapSignalFile) : new Path(reduceSignalFile), (short)1);
    }

    static String getSignalFile(Path dir) {
        return new Path(dir, "signal").toString();
    }

    static String getMapSignalFile(Path dir) {
        return new Path(dir, "map-signal").toString();
    }

    static String getReduceSignalFile(Path dir) {
        return new Path(dir, "reduce-signal").toString();
    }

    static void writeFile(NameNode namenode, Configuration conf, Path name, short replication) throws IOException {
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fileSys, (Configuration)conf, (Path)name, BytesWritable.class, BytesWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
        writer.append((Writable)new BytesWritable(), (Writable)new BytesWritable());
        writer.close();
        fileSys.setReplication(name, replication);
        DFSTestUtil.waitReplication(fileSys, name, replication);
    }

    static RunningJob runJob(JobConf conf, Path inDir, Path outDir) throws IOException {
        return UtilsForTests.runJob(conf, inDir, outDir, conf.getNumMapTasks(), conf.getNumReduceTasks());
    }

    public static RunningJob runJob(JobConf conf, Path inDir, Path outDir, int numMaps, int numReds) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(outDir)) {
            fs.delete(outDir, true);
        }
        if (!fs.exists(inDir)) {
            fs.mkdirs(inDir);
        }
        String input = "The quick brown fox\nhas many silly\nred fox sox\n";
        for (int i = 0; i < numMaps; ++i) {
            FSDataOutputStream file = fs.create(new Path(inDir, "part-" + i));
            file.writeBytes(input);
            file.close();
        }
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setNumMapTasks(numMaps);
        conf.setNumReduceTasks(numReds);
        JobClient jobClient = new JobClient(conf);
        RunningJob job = jobClient.submitJob(conf);
        return job;
    }

    static RunningJob runJobSucceed(JobConf conf, Path inDir, Path outDir) throws IOException {
        conf.setJobName("test-job-succeed");
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        RunningJob job = UtilsForTests.runJob(conf, inDir, outDir);
        while (!job.isComplete()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return job;
    }

    static RunningJob runJobFail(JobConf conf, Path inDir, Path outDir) throws IOException {
        conf.setJobName("test-job-fail");
        conf.setMapperClass(FailMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        RunningJob job = UtilsForTests.runJob(conf, inDir, outDir);
        while (!job.isComplete()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return job;
    }

    static RunningJob runJobKill(JobConf conf, Path inDir, Path outDir) throws IOException {
        conf.setJobName("test-job-kill");
        conf.setMapperClass(KillMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        RunningJob job = UtilsForTests.runJob(conf, inDir, outDir);
        while (job.getJobState() != 1) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        job.killJob();
        while (job.cleanupProgress() == 0.0f) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {
                break;
            }
        }
        return job;
    }

    static void setUpConfigFile(Properties confProps, File configFile) throws IOException {
        Configuration config = new Configuration(false);
        FileOutputStream fos = new FileOutputStream(configFile);
        Enumeration<?> e = confProps.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            config.set(key, confProps.getProperty(key));
        }
        config.writeXml((OutputStream)fos);
        fos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPidFromPidFile(String pidFileName) {
        BufferedReader pidFile = null;
        FileReader fReader = null;
        String pid = null;
        try {
            fReader = new FileReader(pidFileName);
            pidFile = new BufferedReader(fReader);
        }
        catch (FileNotFoundException f) {
            LOG.debug((Object)("PidFile doesn't exist : " + pidFileName));
            return pid;
        }
        try {
            pid = pidFile.readLine();
        }
        catch (IOException i) {
            LOG.error((Object)("Failed to read from " + pidFileName));
        }
        finally {
            try {
                if (fReader != null) {
                    fReader.close();
                }
                try {
                    if (pidFile != null) {
                        pidFile.close();
                    }
                }
                catch (IOException i) {
                    LOG.warn((Object)("Error closing the stream " + pidFile));
                }
            }
            catch (IOException i) {
                LOG.warn((Object)("Error closing the stream " + fReader));
            }
        }
        return pid;
    }

    static JobTracker getJobTracker() {
        JobConf conf = new JobConf();
        conf.set("mapred.job.tracker", "localhost:0");
        conf.set("mapred.job.tracker.http.address", "0.0.0.0:0");
        try {
            JobTracker jt = new JobTracker(conf);
            return jt;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start jt", e);
        }
    }

    public static DataOutputStream createTmpFileDFS(FileSystem dfs, Path URIPATH, FsPermission permission, String input) throws Exception {
        FSDataOutputStream file = FileSystem.create((FileSystem)dfs, (Path)URIPATH, (FsPermission)permission);
        file.writeBytes(input);
        file.close();
        return file;
    }

    public static String getFQDNofTT(String taskTrackerLong) throws Exception {
        String[] firstSplit = taskTrackerLong.split("_");
        String tmpOutput = firstSplit[1];
        String[] secondSplit = tmpOutput.split(":");
        String tmpTaskTracker = secondSplit[0];
        return tmpTaskTracker;
    }

    static {
        Arrays.fill(space, ' ');
    }

    static class InLineUserLogManager
    extends UserLogManager {
        public InLineUserLogManager(Configuration conf) throws IOException {
            super(conf);
            this.getUserLogCleaner().setCleanupQueue((CleanupQueue)new InlineCleanupQueue());
        }

        public void addLogEvent(UserLogEvent event) {
            try {
                super.addLogEvent(event);
                super.monitor();
            }
            catch (Exception e) {
                Assert.fail((String)("failed to process action " + event.getEventType()));
            }
        }
    }

    static class KillMapper
    extends MapReduceBase
    implements Mapper<WritableComparable, Writable, WritableComparable, Writable> {
        KillMapper() {
        }

        public void map(WritableComparable key, Writable value, OutputCollector<WritableComparable, Writable> out, Reporter reporter) throws IOException {
            try {
                Thread.sleep(1000000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static class FailMapper
    extends MapReduceBase
    implements Mapper<WritableComparable, Writable, WritableComparable, Writable> {
        FailMapper() {
        }

        public void map(WritableComparable key, Writable value, OutputCollector<WritableComparable, Writable> out, Reporter reporter) throws IOException {
            throw new RuntimeException("failing map");
        }
    }

    static class FakeClock
    extends Clock {
        long time = 0L;

        FakeClock() {
        }

        public void advance(long millis) {
            this.time += millis;
        }

        long getTime() {
            return this.time;
        }
    }

    public static class RandomInputFormat
    implements InputFormat<Text, Text> {
        public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
            InputSplit[] result = new InputSplit[numSplits];
            Path outDir = FileOutputFormat.getOutputPath((JobConf)job);
            for (int i = 0; i < result.length; ++i) {
                result[i] = new FileSplit(new Path(outDir, "dummy-split-" + i), 0L, 1L, (String[])null);
            }
            return result;
        }

        public RecordReader<Text, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            return new RandomRecordReader(((FileSplit)split).getPath());
        }

        static class RandomRecordReader
        implements RecordReader<Text, Text> {
            Path name;

            public RandomRecordReader(Path p) {
                this.name = p;
            }

            public boolean next(Text key, Text value) {
                if (this.name != null) {
                    key.set(this.name.getName());
                    this.name = null;
                    return true;
                }
                return false;
            }

            public Text createKey() {
                return new Text();
            }

            public Text createValue() {
                return new Text();
            }

            public long getPos() {
                return 0L;
            }

            public void close() {
            }

            public float getProgress() {
                return 0.0f;
            }
        }
    }

    public static class InlineCleanupQueue
    extends CleanupQueue {
        List<Path> stalePaths = new ArrayList<Path>();

        public void addToQueue(CleanupQueue.PathDeletionContext ... contexts) {
            for (CleanupQueue.PathDeletionContext context : contexts) {
                Exception exc = null;
                try {
                    if (!InlineCleanupQueue.deletePath(context)) {
                        LOG.warn((Object)("Stale path " + context.fullPath));
                        this.stalePaths.add(context.fullPath);
                    }
                }
                catch (IOException e) {
                    exc = e;
                }
                catch (InterruptedException ie) {
                    exc = ie;
                }
                if (exc == null) continue;
                LOG.warn((Object)("Caught exception while deleting path " + context.fullPath));
                LOG.info((Object)StringUtils.stringifyException((Throwable)exc));
                this.stalePaths.add(context.fullPath);
            }
        }

        static boolean deletePath(CleanupQueue.PathDeletionContext context) throws IOException, InterruptedException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to delete " + context.fullPath));
            }
            context.deletePath();
            return true;
        }
    }

    static class WaitingReducer
    extends MapReduceBase
    implements Reducer<WritableComparable, Writable, WritableComparable, Writable> {
        FileSystem fs = null;
        Path signal;

        WaitingReducer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reduce(WritableComparable key, Iterator<Writable> val, OutputCollector<WritableComparable, Writable> output, Reporter reporter) throws IOException {
            if (this.fs != null) {
                while (!this.fs.exists(this.signal)) {
                    try {
                        reporter.progress();
                        WaitingReducer waitingReducer = this;
                        synchronized (waitingReducer) {
                            ((Object)((Object)this)).wait(1000L);
                        }
                    }
                    catch (InterruptedException ie) {
                        System.out.println("Interrupted while the map was waiting for the signal.");
                        break;
                    }
                }
            } else {
                throw new IOException("Could not get the DFS!!");
            }
        }

        public void configure(JobConf conf) {
            try {
                this.fs = FileSystem.get((Configuration)conf);
                this.signal = new Path(conf.get(UtilsForTests.getTaskSignalParameter(false)));
            }
            catch (IOException ioe) {
                System.out.println("Got an exception while obtaining the filesystem");
            }
        }
    }

    static class HalfWaitingMapper
    extends WaitingMapper {
        HalfWaitingMapper() {
        }

        @Override
        public boolean shouldWait(int id) {
            return id >= this.totalMaps / 2;
        }
    }

    static class WaitingMapper
    extends MapReduceBase
    implements Mapper<WritableComparable, Writable, WritableComparable, Writable> {
        FileSystem fs = null;
        Path signal;
        int id = 0;
        int totalMaps = 0;

        WaitingMapper() {
        }

        public boolean shouldWait(int id) {
            return true;
        }

        public Path getSignalFile(int id) {
            return this.signal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void map(WritableComparable key, Writable val, OutputCollector<WritableComparable, Writable> output, Reporter reporter) throws IOException {
            if (this.shouldWait(this.id)) {
                if (this.fs != null) {
                    while (!this.fs.exists(this.getSignalFile(this.id))) {
                        try {
                            reporter.progress();
                            WaitingMapper waitingMapper = this;
                            synchronized (waitingMapper) {
                                ((Object)((Object)this)).wait(1000L);
                            }
                        }
                        catch (InterruptedException ie) {
                            System.out.println("Interrupted while the map was waiting for  the signal.");
                            break;
                        }
                    }
                } else {
                    throw new IOException("Could not get the DFS!!");
                }
            }
        }

        public void configure(JobConf conf) {
            try {
                String taskId = conf.get("mapred.task.id");
                this.id = Integer.parseInt(taskId.split("_")[4]);
                this.totalMaps = conf.getInt("mapred.map.tasks", -1);
                this.fs = FileSystem.get((Configuration)conf);
                this.signal = new Path(conf.get(UtilsForTests.getTaskSignalParameter(true)));
            }
            catch (IOException ioe) {
                System.out.println("Got an exception while obtaining the filesystem");
            }
        }
    }
}

