/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.SortValidator;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class BigMapOutput
extends Configured
implements Tool {
    public static final Log LOG = LogFactory.getLog((String)BigMapOutput.class.getName());
    private static Random random = new Random();

    private static void randomizeBytes(byte[] data, int offset, int length) {
        for (int i = offset + length - 1; i >= offset; --i) {
            data[i] = (byte)random.nextInt(256);
        }
    }

    private static void createBigMapInputFile(Configuration conf, FileSystem fs, Path dir, long fileSizeInMB) throws IOException {
        int valueLength;
        int keyLength;
        long numBytesToWrite;
        FileStatus[] list;
        if (fs.exists(dir) && (list = fs.listStatus(dir)) != null && list.length > 0) {
            throw new IOException("Input path: " + dir + " already exists... ");
        }
        Path file = new Path(dir, "part-0");
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)file, BytesWritable.class, BytesWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
        int minKeySize = conf.getInt("test.bmo.min_key", 10);
        int keySizeRange = conf.getInt("test.bmo.max_key", 1000) - minKeySize;
        int minValueSize = conf.getInt("test.bmo.min_value", 0);
        int valueSizeRange = conf.getInt("test.bmo.max_value", 20000) - minValueSize;
        BytesWritable randomKey = new BytesWritable();
        BytesWritable randomValue = new BytesWritable();
        LOG.info((Object)("Writing " + numBytesToWrite + " bytes to " + file + " with " + "minKeySize: " + minKeySize + " keySizeRange: " + keySizeRange + " minValueSize: " + minValueSize + " valueSizeRange: " + valueSizeRange));
        long start = System.currentTimeMillis();
        for (numBytesToWrite = fileSizeInMB * 1024L * 1024L; numBytesToWrite > 0L; numBytesToWrite -= (long)(keyLength + valueLength)) {
            keyLength = minKeySize + (keySizeRange != 0 ? random.nextInt(keySizeRange) : 0);
            randomKey.setSize(keyLength);
            BigMapOutput.randomizeBytes(randomKey.getBytes(), 0, randomKey.getLength());
            valueLength = minValueSize + (valueSizeRange != 0 ? random.nextInt(valueSizeRange) : 0);
            randomValue.setSize(valueLength);
            BigMapOutput.randomizeBytes(randomValue.getBytes(), 0, randomValue.getLength());
            writer.append((Writable)randomKey, (Writable)randomValue);
        }
        writer.close();
        long end = System.currentTimeMillis();
        LOG.info((Object)("Created " + file + " of size: " + fileSizeInMB + "MB in " + (end - start) / 1000L + "secs"));
    }

    private static void usage() {
        System.err.println("BigMapOutput -input <input-dir> -output <output-dir> [-create <filesize in MB>]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.err);
        System.exit(1);
    }

    public int run(String[] args) throws Exception {
        if (args.length < 4) {
            BigMapOutput.usage();
        }
        Path bigMapInput = null;
        Path outputPath = null;
        boolean createInput = false;
        long fileSizeInMB = 3072L;
        for (int i = 0; i < args.length; ++i) {
            if ("-input".equals(args[i])) {
                bigMapInput = new Path(args[++i]);
                continue;
            }
            if ("-output".equals(args[i])) {
                outputPath = new Path(args[++i]);
                continue;
            }
            if ("-create".equals(args[i])) {
                createInput = true;
                fileSizeInMB = Long.parseLong(args[++i]);
                continue;
            }
            BigMapOutput.usage();
        }
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        JobConf jobConf = new JobConf(this.getConf(), BigMapOutput.class);
        jobConf.setJobName("BigMapOutput");
        jobConf.setInputFormat(SortValidator.RecordStatsChecker.NonSplitableSequenceFileInputFormat.class);
        jobConf.setOutputFormat(SequenceFileOutputFormat.class);
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{bigMapInput});
        if (fs.exists(outputPath)) {
            fs.delete(outputPath, true);
        }
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)outputPath);
        jobConf.setMapperClass(IdentityMapper.class);
        jobConf.setReducerClass(IdentityReducer.class);
        jobConf.setOutputKeyClass(BytesWritable.class);
        jobConf.setOutputValueClass(BytesWritable.class);
        if (createInput) {
            BigMapOutput.createBigMapInputFile((Configuration)jobConf, fs, bigMapInput, fileSizeInMB);
        }
        Date startTime = new Date();
        System.out.println("Job started: " + startTime);
        JobClient.runJob((JobConf)jobConf);
        Date end_time = new Date();
        System.out.println("Job ended: " + end_time);
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new BigMapOutput(), (String[])argv);
        System.exit(res);
    }
}

