/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.metrics;

import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.metrics.FSNamesystemMetrics;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.mortbay.log.Log;

public class TestNameNodeMetrics
extends TestCase {
    private static final Configuration CONF = new Configuration();
    private static final int DFS_REPLICATION_INTERVAL = 1;
    private static final Path TEST_ROOT_DIR_PATH = new Path(System.getProperty("test.build.data", "build/test/data"));
    private static final int DATANODE_COUNT = 3;
    private MiniDFSCluster cluster;
    private FSNamesystemMetrics metrics;
    private DistributedFileSystem fs;
    private Random rand = new Random();
    private FSNamesystem namesystem;
    private NameNodeMetrics nnMetrics;
    private NameNode nn;

    private static Path getTestPath(String fileName) {
        return new Path(TEST_ROOT_DIR_PATH, fileName);
    }

    protected void setUp() throws Exception {
        this.cluster = new MiniDFSCluster(CONF, 3, true, null);
        this.cluster.waitActive();
        this.namesystem = this.cluster.getNameNode().getNamesystem();
        this.fs = (DistributedFileSystem)this.cluster.getFileSystem();
        this.metrics = this.namesystem.getFSNamesystemMetrics();
        this.nn = this.cluster.getNameNode();
        TestNameNodeMetrics testNameNodeMetrics = this;
        this.nnMetrics = testNameNodeMetrics.nn.getNameNodeMetrics();
    }

    protected void tearDown() throws Exception {
        this.cluster.shutdown();
    }

    private void createFile(Path file, long fileLen, short replicas) throws IOException {
        DFSTestUtil.createFile((FileSystem)this.fs, file, fileLen, replicas, this.rand.nextLong());
    }

    private void updateMetrics() throws Exception {
        Thread.sleep(1000L);
        this.metrics.doUpdates(null);
    }

    private void updateNNMetrics() throws Exception {
        Thread.sleep(1000L);
        this.nnMetrics.doUpdates(null);
    }

    private void readFile(FileSystem fileSys, Path name) throws IOException {
        FSDataInputStream stm = fileSys.open(name);
        byte[] buffer = new byte[4];
        int bytesRead = stm.read(buffer, 0, 4);
        stm.close();
    }

    public void testFileAdd() throws Exception {
        Path file = TestNameNodeMetrics.getTestPath("testFileAdd");
        this.createFile(file, 3200L, (short)3);
        int blockCount = 32;
        int blockCapacity = this.namesystem.getBlockCapacity();
        this.updateMetrics();
        TestNameNodeMetrics.assertEquals((int)blockCapacity, (int)this.metrics.blockCapacity.get());
        int threshold = (int)((float)blockCapacity * 0.75f);
        while (threshold < 32) {
            blockCapacity <<= 1;
        }
        this.updateMetrics();
        int filesTotal = file.depth() + 1;
        TestNameNodeMetrics.assertEquals((int)filesTotal, (int)this.metrics.filesTotal.get());
        TestNameNodeMetrics.assertEquals((long)32L, (long)this.metrics.blocksTotal.get());
        TestNameNodeMetrics.assertEquals((int)blockCapacity, (int)this.metrics.blockCapacity.get());
        this.fs.delete(file, true);
        Thread.sleep(4000L);
        this.updateMetrics();
        TestNameNodeMetrics.assertEquals((int)(--filesTotal), (int)this.metrics.filesTotal.get());
        TestNameNodeMetrics.assertEquals((int)0, (int)this.metrics.pendingDeletionBlocks.get());
    }

    public void testCorruptBlock() throws Exception {
        Path file = TestNameNodeMetrics.getTestPath("testCorruptBlock");
        this.createFile(file, 100L, (short)2);
        LocatedBlock block = this.namesystem.getBlockLocations(file.toString(), 0L, 1L).get(0);
        this.namesystem.markBlockAsCorrupt(block.getBlock(), block.getLocations()[0]);
        this.updateMetrics();
        TestNameNodeMetrics.assertEquals((int)1, (int)this.metrics.corruptBlocks.get());
        TestNameNodeMetrics.assertEquals((int)1, (int)this.metrics.pendingReplicationBlocks.get());
        TestNameNodeMetrics.assertEquals((int)1, (int)this.metrics.scheduledReplicationBlocks.get());
        this.fs.delete(file, true);
        this.updateMetrics();
        TestNameNodeMetrics.assertEquals((int)0, (int)this.metrics.corruptBlocks.get());
        TestNameNodeMetrics.assertEquals((int)0, (int)this.metrics.pendingReplicationBlocks.get());
        TestNameNodeMetrics.assertEquals((int)0, (int)this.metrics.scheduledReplicationBlocks.get());
    }

    public void testExcessBlocks() throws Exception {
        Path file = TestNameNodeMetrics.getTestPath("testExcessBlocks");
        this.createFile(file, 100L, (short)2);
        int totalBlocks = 1;
        this.namesystem.setReplication(file.toString(), (short)1);
        this.updateMetrics();
        TestNameNodeMetrics.assertEquals((int)totalBlocks, (int)this.metrics.excessBlocks.get());
        this.fs.delete(file, true);
    }

    public void testMissingBlock() throws Exception {
        Path file = TestNameNodeMetrics.getTestPath("testMissingBlocks");
        this.createFile(file, 100L, (short)1);
        LocatedBlock block = this.namesystem.getBlockLocations(file.toString(), 0L, 1L).get(0);
        this.namesystem.markBlockAsCorrupt(block.getBlock(), block.getLocations()[0]);
        this.updateMetrics();
        TestNameNodeMetrics.assertEquals((int)1, (int)this.metrics.underReplicatedBlocks.get());
        TestNameNodeMetrics.assertEquals((int)1, (int)this.metrics.missingBlocks.get());
        this.fs.delete(file, true);
        this.updateMetrics();
        TestNameNodeMetrics.assertEquals((int)0, (int)this.metrics.underReplicatedBlocks.get());
    }

    public void testGetBlockLocationMetric() throws Exception {
        String METHOD_NAME = "TestGetBlockLocationMetric";
        Log.info((String)"Running test TestGetBlockLocationMetric");
        Path file1_Path = new Path(TEST_ROOT_DIR_PATH, "file1.dat");
        TestNameNodeMetrics.assertEquals((String)"numGetBlockLocations for previous interval is incorrect", (int)0, (int)this.nnMetrics.numGetBlockLocations.getPreviousIntervalValue());
        TestNameNodeMetrics.assertEquals((String)"numGetBlockLocations for current interval is incorrect", (int)0, (int)this.nnMetrics.numGetBlockLocations.getCurrentIntervalValue());
        this.createFile(file1_Path, 100L, (short)2);
        this.updateNNMetrics();
        TestNameNodeMetrics.assertEquals((String)"numGetBlockLocations for previous interval is incorrect", (int)0, (int)this.nnMetrics.numGetBlockLocations.getPreviousIntervalValue());
        TestNameNodeMetrics.assertEquals((String)"numGetBlockLocations for current interval is incorrect", (int)0, (int)this.nnMetrics.numGetBlockLocations.getCurrentIntervalValue());
        this.readFile((FileSystem)this.fs, file1_Path);
        this.updateNNMetrics();
        TestNameNodeMetrics.assertEquals((String)"numGetBlockLocations for previous interval is incorrect", (int)1, (int)this.nnMetrics.numGetBlockLocations.getPreviousIntervalValue());
        TestNameNodeMetrics.assertEquals((String)"numGetBlockLocations for current interval is incorrect", (int)0, (int)this.nnMetrics.numGetBlockLocations.getCurrentIntervalValue());
        this.readFile((FileSystem)this.fs, file1_Path);
        this.readFile((FileSystem)this.fs, file1_Path);
        this.updateNNMetrics();
        TestNameNodeMetrics.assertEquals((String)"numGetBlockLocations for previous interval is incorrect", (int)2, (int)this.nnMetrics.numGetBlockLocations.getPreviousIntervalValue());
        TestNameNodeMetrics.assertEquals((String)"numGetBlockLocations for current interval is incorrect", (int)0, (int)this.nnMetrics.numGetBlockLocations.getCurrentIntervalValue());
        this.updateMetrics();
        TestNameNodeMetrics.assertEquals((String)"Metrics TotalLoad is incorrect", (int)3, (int)this.metrics.totalLoad.get());
    }

    static {
        CONF.setLong("dfs.block.size", 100L);
        CONF.setInt("io.bytes.per.checksum", 1);
        CONF.setLong("dfs.heartbeat.interval", 1L);
        CONF.setInt("dfs.replication.interval", 1);
    }
}

