/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;

public class TestStorageRestore
extends TestCase {
    public static final String NAME_NODE_HOST = "localhost:";
    public static final String NAME_NODE_HTTP_HOST = "0.0.0.0:";
    private static final Log LOG = LogFactory.getLog((String)TestStorageRestore.class.getName());
    private Configuration config;
    private File hdfsDir = null;
    static final long seed = 0xAAAAEEFL;
    static final int blockSize = 4096;
    static final int fileSize = 8192;
    private File path1;
    private File path2;
    private File path3;
    private MiniDFSCluster cluster;

    private void writeFile(FileSystem fileSys, Path name, int repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 4096L);
        byte[] buffer = new byte[8192];
        Random rand = new Random(0xAAAAEEFL);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    protected void setUp() throws Exception {
        this.config = new Configuration();
        String baseDir = System.getProperty("test.build.data", "/tmp");
        this.hdfsDir = new File(baseDir, "dfs");
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not delete hdfs directory '" + this.hdfsDir + "'");
        }
        this.hdfsDir.mkdir();
        this.path1 = new File(this.hdfsDir, "name1");
        this.path2 = new File(this.hdfsDir, "name2");
        this.path3 = new File(this.hdfsDir, "name3");
        this.path1.mkdir();
        this.path2.mkdir();
        this.path3.mkdir();
        if (!(this.path2.exists() && this.path3.exists() && this.path1.exists())) {
            throw new IOException("Couldn't create dfs.name dirs");
        }
        String dfs_name_dir = new String(this.path1.getPath() + "," + this.path2.getPath());
        System.out.println("configuring hdfsdir is " + this.hdfsDir.getAbsolutePath() + "; dfs_name_dir = " + dfs_name_dir + ";dfs_name_edits_dir(only)=" + this.path3.getPath());
        this.config.set("dfs.name.dir", dfs_name_dir);
        this.config.set("dfs.name.edits.dir", dfs_name_dir + "," + this.path3.getPath());
        this.config.set("fs.checkpoint.dir", new File(this.hdfsDir, "secondary").getPath());
        FileSystem.setDefaultUri((Configuration)this.config, (String)"hdfs://localhost:0");
        this.config.set("dfs.secondary.http.address", "0.0.0.0:0");
        this.config.setBoolean("dfs.name.dir.restore", true);
    }

    public void tearDown() throws Exception {
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not delete hdfs directory in tearDown '" + this.hdfsDir + "'");
        }
    }

    public void invalidateStorage(FSImage fi) throws IOException {
        fi.getEditLog().processIOError(2);
        fi.getEditLog().processIOError(1);
    }

    public void printStorages(FSImage fs) {
        LOG.info((Object)"current storages and corresoponding sizes:");
        Iterator it = fs.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = (Storage.StorageDirectory)it.next();
            if (sd.getStorageDirType().isOfType((Storage.StorageDirType)FSImage.NameNodeDirType.IMAGE)) {
                File imf = FSImage.getImageFile((Storage.StorageDirectory)sd, (FSImage.NameNodeFile)FSImage.NameNodeFile.IMAGE);
                LOG.info((Object)("  image file " + imf.getAbsolutePath() + "; len = " + imf.length()));
            }
            if (!sd.getStorageDirType().isOfType((Storage.StorageDirType)FSImage.NameNodeDirType.EDITS)) continue;
            File edf = FSImage.getImageFile((Storage.StorageDirectory)sd, (FSImage.NameNodeFile)FSImage.NameNodeFile.EDITS);
            LOG.info((Object)("  edits file " + edf.getAbsolutePath() + "; len = " + edf.length()));
        }
    }

    public void checkFiles(boolean valid) {
        File fsImg1 = new File(this.path1, "current/" + FSImage.NameNodeFile.IMAGE.getName());
        File fsImg2 = new File(this.path2, "current/" + FSImage.NameNodeFile.IMAGE.getName());
        File fsImg3 = new File(this.path3, "current/" + FSImage.NameNodeFile.IMAGE.getName());
        File fsEdits1 = new File(this.path1, "current/" + FSImage.NameNodeFile.EDITS.getName());
        File fsEdits2 = new File(this.path2, "current/" + FSImage.NameNodeFile.EDITS.getName());
        File fsEdits3 = new File(this.path3, "current/" + FSImage.NameNodeFile.EDITS.getName());
        this.printStorages(this.cluster.getNameNode().getFSImage());
        LOG.info((Object)("++++ image files = " + fsImg1.getAbsolutePath() + "," + fsImg2.getAbsolutePath() + "," + fsImg3.getAbsolutePath()));
        LOG.info((Object)("++++ edits files = " + fsEdits1.getAbsolutePath() + "," + fsEdits2.getAbsolutePath() + "," + fsEdits3.getAbsolutePath()));
        LOG.info((Object)("checkFiles compares lengths: img1=" + fsImg1.length() + ",img2=" + fsImg2.length() + ",img3=" + fsImg3.length()));
        LOG.info((Object)("checkFiles compares lengths: edits1=" + fsEdits1.length() + ",edits2=" + fsEdits2.length() + ",edits3=" + fsEdits3.length()));
        if (valid) {
            TestStorageRestore.assertTrue((fsImg1.length() == fsImg2.length() ? 1 : 0) != 0);
            TestStorageRestore.assertTrue((0L == fsImg3.length() ? 1 : 0) != 0);
            TestStorageRestore.assertTrue((fsEdits1.length() == fsEdits2.length() ? 1 : 0) != 0);
            TestStorageRestore.assertTrue((fsEdits1.length() == fsEdits3.length() ? 1 : 0) != 0);
        } else {
            TestStorageRestore.assertTrue((fsEdits1.length() != fsEdits2.length() ? 1 : 0) != 0);
            TestStorageRestore.assertTrue((fsEdits1.length() != fsEdits3.length() ? 1 : 0) != 0);
        }
    }

    public void testStorageRestore() throws Exception {
        int numDatanodes = 2;
        this.cluster = new MiniDFSCluster(0, this.config, numDatanodes, true, false, true, null, null, null, null);
        this.cluster.waitActive();
        SecondaryNameNode secondary = new SecondaryNameNode(this.config);
        System.out.println("****testStorageRestore: Cluster and SNN started");
        this.printStorages(this.cluster.getNameNode().getFSImage());
        FileSystem fs = this.cluster.getFileSystem();
        Path path = new Path("/", "test");
        this.writeFile(fs, path, 2);
        System.out.println("****testStorageRestore: file test written, invalidating storage...");
        this.invalidateStorage(this.cluster.getNameNode().getFSImage());
        this.printStorages(this.cluster.getNameNode().getFSImage());
        System.out.println("****testStorageRestore: storage invalidated + doCheckpoint");
        path = new Path("/", "test1");
        this.writeFile(fs, path, 2);
        System.out.println("****testStorageRestore: file test1 written");
        this.checkFiles(false);
        System.out.println("****testStorageRestore: checkfiles(false) run");
        secondary.doCheckpoint();
        this.checkFiles(true);
        System.out.println("****testStorageRestore: second Checkpoint done and checkFiles(true) run");
        secondary.shutdown();
        this.cluster.shutdown();
    }
}

