/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.datanode.BlockTransferThrottler;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;

public class TestBlockReplacement
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestBlockReplacement");
    MiniDFSCluster cluster;

    public void testThrottler() throws IOException {
        long TOTAL_BYTES;
        Configuration conf = new Configuration();
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://localhost:0");
        long bandwidthPerSec = 0x100000L;
        long bytesToSend = TOTAL_BYTES = 6L * bandwidthPerSec;
        long start = Util.now();
        BlockTransferThrottler throttler = new BlockTransferThrottler(bandwidthPerSec);
        long totalBytes = 0L;
        long bytesSent = 524288L;
        throttler.throttle(bytesSent);
        bytesToSend -= bytesSent;
        bytesSent = 786432L;
        throttler.throttle(bytesSent);
        bytesToSend -= bytesSent;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        throttler.throttle(bytesToSend);
        long end = Util.now();
        TestBlockReplacement.assertTrue((totalBytes * 1000L / (end - start) <= bandwidthPerSec ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBlockReplacement() throws IOException {
        Configuration CONF = new Configuration();
        String[] INITIAL_RACKS = new String[]{"/RACK0", "/RACK1", "/RACK2"};
        String[] NEW_RACKS = new String[]{"/RACK2"};
        int REPLICATION_FACTOR = 3;
        int DEFAULT_BLOCK_SIZE = 1024;
        Random r = new Random();
        CONF.setLong("dfs.block.size", 1024L);
        CONF.setInt("io.bytes.per.checksum", 512);
        CONF.setLong("dfs.blockreport.intervalMsec", 500L);
        this.cluster = new MiniDFSCluster(CONF, 3, true, INITIAL_RACKS);
        try {
            this.cluster.waitActive();
            FileSystem fs = this.cluster.getFileSystem();
            Path fileName = new Path("/tmp.txt");
            DFSTestUtil.createFile(fs, fileName, 1024L, (short)3, r.nextLong());
            DFSTestUtil.waitReplication(fs, fileName, (short)3);
            InetSocketAddress addr = new InetSocketAddress("localhost", this.cluster.getNameNodePort());
            DFSClient client = new DFSClient(addr, CONF);
            List locatedBlocks = client.namenode.getBlockLocations("/tmp.txt", 0L, 1024L).getLocatedBlocks();
            TestBlockReplacement.assertEquals((int)1, (int)locatedBlocks.size());
            LocatedBlock block = (LocatedBlock)locatedBlocks.get(0);
            DatanodeInfo[] oldNodes = block.getLocations();
            TestBlockReplacement.assertEquals((int)oldNodes.length, (int)3);
            Block b = block.getBlock();
            this.cluster.startDataNodes(CONF, 1, true, null, NEW_RACKS);
            this.cluster.waitActive();
            DatanodeInfo[] datanodes = client.datanodeReport(FSConstants.DatanodeReportType.ALL);
            DatanodeInfo newNode = null;
            for (DatanodeInfo node : datanodes) {
                Boolean isNewNode = true;
                for (DatanodeInfo oldNode : oldNodes) {
                    if (!node.equals((Object)oldNode)) continue;
                    isNewNode = false;
                    break;
                }
                if (!isNewNode.booleanValue()) continue;
                newNode = node;
                break;
            }
            TestBlockReplacement.assertTrue((newNode != null ? 1 : 0) != 0);
            DatanodeInfo source = null;
            ArrayList<DatanodeInfo> proxies = new ArrayList<DatanodeInfo>(2);
            for (DatanodeInfo node : datanodes) {
                if (node == newNode) continue;
                if (node.getNetworkLocation().equals(newNode.getNetworkLocation())) {
                    source = node;
                    continue;
                }
                proxies.add(node);
            }
            TestBlockReplacement.assertTrue((source != null && proxies.size() == 2 ? 1 : 0) != 0);
            LOG.info((Object)("Testcase 1: Proxy " + newNode.getName() + " does not contain the block " + b.getBlockName()));
            TestBlockReplacement.assertFalse((boolean)this.replaceBlock(b, source, newNode, (DatanodeInfo)proxies.get(0)));
            LOG.info((Object)("Testcase 2: Destination " + ((DatanodeInfo)proxies.get(1)).getName() + " contains the block " + b.getBlockName()));
            TestBlockReplacement.assertFalse((boolean)this.replaceBlock(b, source, (DatanodeInfo)proxies.get(0), (DatanodeInfo)proxies.get(1)));
            LOG.info((Object)("Testcase 3: Proxy=" + source.getName() + " source=" + ((DatanodeInfo)proxies.get(0)).getName() + " destination=" + newNode.getName()));
            TestBlockReplacement.assertTrue((boolean)this.replaceBlock(b, source, (DatanodeInfo)proxies.get(0), newNode));
            this.checkBlocks(new DatanodeInfo[]{newNode, (DatanodeInfo)proxies.get(0), (DatanodeInfo)proxies.get(1)}, fileName.toString(), 1024L, (short)3, client);
            LOG.info((Object)("Testcase 4: invalid del hint " + ((DatanodeInfo)proxies.get(0)).getName()));
            TestBlockReplacement.assertTrue((boolean)this.replaceBlock(b, (DatanodeInfo)proxies.get(1), (DatanodeInfo)proxies.get(0), source));
            this.checkBlocks(proxies.toArray(new DatanodeInfo[proxies.size()]), fileName.toString(), 1024L, (short)3, client);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    private void checkBlocks(DatanodeInfo[] includeNodes, String fileName, long fileLen, short replFactor, DFSClient client) throws IOException {
        Boolean notDone;
        block2: do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            List blocks = client.namenode.getBlockLocations(fileName, 0L, fileLen).getLocatedBlocks();
            TestBlockReplacement.assertEquals((int)1, (int)blocks.size());
            DatanodeInfo[] nodes = ((LocatedBlock)blocks.get(0)).getLocations();
            notDone = nodes.length != replFactor;
            if (notDone.booleanValue()) {
                LOG.info((Object)("Expected replication factor is " + replFactor + " but the real replication factor is " + nodes.length));
                continue;
            }
            List<DatanodeInfo> nodeLocations = Arrays.asList(nodes);
            for (DatanodeInfo node : includeNodes) {
                if (nodeLocations.contains(node)) continue;
                notDone = true;
                LOG.info((Object)("Block is not located at " + node.getName()));
                continue block2;
            }
        } while (notDone.booleanValue());
    }

    private boolean replaceBlock(Block block, DatanodeInfo source, DatanodeInfo sourceProxy, DatanodeInfo destination) throws IOException {
        Socket sock = new Socket();
        sock.connect(NetUtils.createSocketAddr((String)destination.getName()), 60000);
        sock.setKeepAlive(true);
        DataOutputStream out = new DataOutputStream(sock.getOutputStream());
        out.writeShort(16);
        out.writeByte(83);
        out.writeLong(block.getBlockId());
        out.writeLong(block.getGenerationStamp());
        Text.writeString((DataOutput)out, (String)source.getStorageID());
        sourceProxy.write((DataOutput)out);
        BlockTokenSecretManager.DUMMY_TOKEN.write((DataOutput)out);
        out.flush();
        DataInputStream reply = new DataInputStream(sock.getInputStream());
        short status = reply.readShort();
        return status == 0;
    }

    public static void main(String[] args) throws Exception {
        new TestBlockReplacement().testBlockReplacement();
    }
}

