/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestQuotaViolations {
    private static final Log LOG = LogFactory.getLog(TestQuotaViolations.class);
    private FileSystem fs;
    private MiniDFSCluster cluster;
    private Configuration conf;
    private DFSAdmin admin;
    private static int BLOCK_SIZE = 6144;

    public TestQuotaViolations() {
        ((Log4JLogger)LOG).getLogger().setLevel(Level.ALL);
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.set("dfs.block.size", Integer.toString(BLOCK_SIZE));
        this.cluster = new MiniDFSCluster(this.conf, 3, true, null);
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.admin = new DFSAdmin(this.conf);
    }

    @After
    public void tearDown() throws Exception {
        this.cluster.shutdown();
    }

    private void runCommand(DFSAdmin admin, boolean expectError, String ... args) throws Exception {
        this.runCommand(admin, args, expectError);
    }

    private void runCommand(DFSAdmin admin, String[] args, boolean expectEror) throws Exception {
        int ret = admin.run(args);
        if (expectEror) {
            Assert.assertEquals((long)ret, (long)-1L);
        } else {
            Assert.assertTrue((ret >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBlockAllocationAdjustUsageConservatively() throws Exception {
        Path dir = new Path("/test");
        Path file1 = new Path("/test/test1");
        Path file2 = new Path("/test/test2");
        boolean exceededQuota = false;
        int QUOTA_SIZE = 3 * BLOCK_SIZE;
        int FILE_SIZE = BLOCK_SIZE / 2;
        Assert.assertTrue((boolean)this.fs.mkdirs(dir));
        this.runCommand(this.admin, false, "-setSpaceQuota", Integer.toString(QUOTA_SIZE), dir.toString());
        DFSTestUtil.createFile(this.fs, file1, FILE_SIZE, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file1, (short)3);
        ContentSummary c = this.fs.getContentSummary(dir);
        Assert.assertEquals((String)"Quota is half consumed", (long)(QUOTA_SIZE / 2), (long)c.getSpaceConsumed());
        try {
            DFSTestUtil.createFile(this.fs, file2, FILE_SIZE, (short)3, 1L);
        }
        catch (QuotaExceededException e) {
            exceededQuota = true;
        }
        Assert.assertTrue((String)"Quota not exceeded", (boolean)exceededQuota);
    }

    @Test
    public void testMultipleFilesSmallerThanOneBlock() throws Exception {
        Path dir = new Path("/test");
        boolean exceededQuota = false;
        int FILE_SIZE = 1024;
        int QUOTA_SIZE = 32 * (int)this.fs.getDefaultBlockSize();
        Assert.assertEquals((long)6144L, (long)this.fs.getDefaultBlockSize());
        Assert.assertEquals((long)196608L, (long)QUOTA_SIZE);
        Assert.assertTrue((boolean)this.fs.mkdirs(dir));
        this.runCommand(this.admin, false, "-setSpaceQuota", Integer.toString(QUOTA_SIZE), dir.toString());
        for (int i = 0; i < 59; ++i) {
            Path file = new Path("/test/test" + i);
            DFSTestUtil.createFile(this.fs, file, 1024L, (short)3, 1L);
            DFSTestUtil.waitReplication(this.fs, file, (short)3);
        }
        ContentSummary c = this.fs.getContentSummary(dir);
        Assert.assertEquals((String)"Invalid space consumed", (long)181248L, (long)c.getSpaceConsumed());
        Assert.assertEquals((String)"Invalid space consumed", (long)(QUOTA_SIZE - 181248), (long)(3L * (this.fs.getDefaultBlockSize() - 1024L)));
        try {
            Path file = new Path("/test/test59");
            DFSTestUtil.createFile(this.fs, file, 1024L, (short)3, 1L);
            DFSTestUtil.waitReplication(this.fs, file, (short)3);
        }
        catch (QuotaExceededException e) {
            exceededQuota = true;
        }
        Assert.assertTrue((String)"Quota not exceeded", (boolean)exceededQuota);
    }
}

