/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestFileAppend2 {
    static Log LOG = LogFactory.getLog(TestFileAppend2.class);
    static final int blockSize = 1024;
    static final int numBlocks = 5;
    static final int fileSize = 5121;
    boolean simulatedStorage;
    private byte[] fileContents;
    int numDatanodes;
    int numberOfFiles;
    int numThreads;
    int numAppendsPerThread;
    int artificialBlockReceivedDelay;
    long sleepBetweenSizeChecks;
    Workload[] workload;
    ArrayList<Path> testFiles;
    AtomicReference<Throwable> err;
    public static final String OPT_NUM_DNS = "numDataNodes";
    public static final String OPT_NUM_FILES = "numFiles";
    public static final String OPT_NUM_THREADS = "numThreads";
    public static final String OPT_NUM_APPENDS = "appendsPerThread";

    public TestFileAppend2() {
        ((Log4JLogger)NameNode.stateChangeLog).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)FSNamesystem.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DFSClient.LOG).getLogger().setLevel(Level.ALL);
        this.simulatedStorage = false;
        this.fileContents = null;
        this.numDatanodes = 5;
        this.numberOfFiles = 50;
        this.numThreads = 10;
        this.numAppendsPerThread = 20;
        this.artificialBlockReceivedDelay = 50;
        this.sleepBetweenSizeChecks = 5000L;
        this.workload = null;
        this.testFiles = new ArrayList();
        this.err = new AtomicReference();
    }

    private void initBuffer(int size) {
        long seed = AppendTestUtil.nextLong();
        this.fileContents = AppendTestUtil.randomBytes(seed, size);
    }

    private FSDataOutputStream createFile(FileSystem fileSys, Path name, int repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 1024L);
        return stm;
    }

    private void checkFile(FileSystem fs, Path name, int len) throws IOException {
        FSDataInputStream stm = fs.open(name);
        byte[] actual = new byte[len];
        stm.readFully(0L, actual);
        this.checkData(actual, 0, this.fileContents, "Read 2");
        stm.close();
    }

    private void checkFullFile(FileSystem fs, Path name) throws IOException {
        this.checkFile(fs, name, 5121);
    }

    private void checkData(byte[] actual, int from, byte[] expected, String message) {
        for (int idx = 0; idx < actual.length; ++idx) {
            Assert.assertEquals((String)(message + " byte " + (from + idx) + " differs. expected " + expected[from + idx] + " actual " + actual[idx]), (long)expected[from + idx], (long)actual[idx]);
            actual[idx] = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=200000L)
    public void testSimpleAppend() throws IOException {
        Configuration conf = new Configuration();
        if (this.simulatedStorage) {
            conf.setBoolean("dfs.datanode.simulateddatastorage", true);
        }
        conf.setInt("dfs.datanode.handler.count", 50);
        conf.setBoolean("dfs.support.append", true);
        this.initBuffer(5121);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        FileSystem fs = cluster.getFileSystem();
        try {
            int len;
            Path file1 = new Path("/simpleAppend.dat");
            FSDataOutputStream stm = this.createFile(fs, file1, 1);
            System.out.println("Created file simpleAppend.dat");
            int mid = 186;
            System.out.println("Writing " + mid + " bytes to file " + file1);
            stm.write(this.fileContents, 0, mid);
            stm.close();
            System.out.println("Wrote and Closed first part of file.");
            int mid2 = 607;
            System.out.println("Writing " + mid + " bytes to file " + file1);
            stm = fs.append(file1);
            stm.write(this.fileContents, mid, mid2 - mid);
            stm.close();
            System.out.println("Wrote and Closed second part of file.");
            stm = fs.append(file1);
            Assert.assertTrue((stm.getPos() > 0L ? 1 : 0) != 0);
            System.out.println("Writing " + (5121 - mid2) + " bytes to file " + file1);
            stm.write(this.fileContents, mid2, 5121 - mid2);
            System.out.println("Written second part of file");
            stm.close();
            System.out.println("Wrote and Closed second part of file.");
            this.checkFullFile(fs, file1);
            FSDataOutputStream out = null;
            try {
                out = fs.append(new Path("/non-existing.dat"));
                Assert.fail((String)"Expected to have FileNotFoundException");
            }
            catch (FileNotFoundException fnfe) {
                try {
                    System.out.println("Good: got " + fnfe);
                    fnfe.printStackTrace(System.out);
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(out);
                    throw throwable;
                }
                IOUtils.closeStream((Closeable)out);
            }
            IOUtils.closeStream((Closeable)out);
            Path root = new Path("/");
            fs.setPermission(root, new FsPermission(511));
            fs.close();
            UserGroupInformation superuser = UserGroupInformation.getCurrentUser();
            String username = "testappenduser";
            String group = "testappendgroup";
            Assert.assertFalse((boolean)superuser.getShortUserName().equals(username));
            Assert.assertFalse((boolean)Arrays.asList(superuser.getGroupNames()).contains(group));
            UserGroupInformation appenduser = UserGroupInformation.createUserForTesting((String)username, (String[])new String[]{group});
            fs = DFSTestUtil.getFileSystemAs(appenduser, conf);
            Path dir = new Path(root, this.getClass().getSimpleName());
            Path foo = new Path(dir, "foo.dat");
            FSDataOutputStream out2 = null;
            int offset = 0;
            try {
                out2 = fs.create(foo);
                len = 10 + AppendTestUtil.nextInt(100);
                out2.write(this.fileContents, offset, len);
                offset += len;
            }
            finally {
                IOUtils.closeStream((Closeable)out2);
            }
            fs.setPermission(dir, new FsPermission(64));
            fs.setPermission(foo, new FsPermission(128));
            out2 = null;
            try {
                out2 = fs.append(foo);
                len = 10 + AppendTestUtil.nextInt(100);
                out2.write(this.fileContents, offset, len);
                offset += len;
            }
            finally {
                IOUtils.closeStream((Closeable)out2);
            }
            fs.setPermission(foo, new FsPermission(383));
            fs.setPermission(dir, new FsPermission(511));
            out2 = null;
            try {
                out2 = fs.append(foo);
                Assert.fail((String)"Expected to have AccessControlException");
            }
            catch (AccessControlException ace) {
                System.out.println("Good: got " + (Object)((Object)ace));
                ace.printStackTrace(System.out);
            }
            finally {
                IOUtils.closeStream((Closeable)out2);
            }
        }
        catch (IOException e) {
            System.out.println("Exception :" + e);
            throw e;
        }
        catch (Throwable e) {
            System.out.println("Throwable :" + e);
            e.printStackTrace();
            throw new IOException("Throwable : " + e);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComplexAppend() throws Throwable {
        this.initBuffer(5121);
        Configuration conf = new Configuration();
        conf.setInt("heartbeat.recheck.interval", 2000);
        conf.setInt("dfs.heartbeat.interval", 2);
        conf.setInt("dfs.replication.pending.timeout.sec", 2);
        conf.setInt("dfs.socket.timeout", 30000);
        conf.setInt("dfs.datanode.socket.write.timeout", 30000);
        conf.setInt("dfs.datanode.handler.count", 50);
        conf.setInt("dfs.datanode.artificialBlockReceivedDelay", this.artificialBlockReceivedDelay);
        conf.setBoolean("dfs.support.append", true);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, this.numDatanodes, true, null);
        cluster.waitActive();
        FileSystem fs = cluster.getFileSystem();
        try {
            int i;
            for (i = 0; i < this.numberOfFiles; ++i) {
                short replication = (short)(AppendTestUtil.nextInt(this.numDatanodes) + 1);
                Path testFile = new Path("/" + i + ".dat");
                FSDataOutputStream stm = this.createFile(fs, testFile, replication);
                stm.close();
                this.testFiles.add(testFile);
            }
            this.workload = new Workload[this.numThreads];
            for (i = 0; i < this.numThreads; ++i) {
                this.workload[i] = new Workload(cluster, i);
                this.workload[i].setDaemon(true);
                this.workload[i].start();
            }
            for (i = 0; i < this.numThreads; ++i) {
                try {
                    System.out.println("Waiting for thread " + i + " to complete...");
                    this.workload[i].join();
                    System.out.println("Waiting for thread " + i + " complete.");
                    continue;
                }
                catch (InterruptedException e) {
                    --i;
                }
            }
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
        if (this.err.get() != null) {
            throw this.err.get();
        }
    }

    public static void main(String[] args) throws Throwable {
        CommandLine line;
        Options options = new Options();
        OptionBuilder.withLongOpt((String)OPT_NUM_DNS);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Number of DNs to start");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)OPT_NUM_THREADS);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"number of threads to append from");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)OPT_NUM_FILES);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"number of files to append to");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)OPT_NUM_APPENDS);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"number of appends per thread");
        options.addOption(OptionBuilder.create());
        GnuParser parser = new GnuParser();
        try {
            line = parser.parse(options, args);
            if (line.getArgs().length != 0) {
                throw new ParseException("Unexpected options");
            }
        }
        catch (ParseException pe) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("TestFileAppend2", options);
            throw pe;
        }
        TestFileAppend2 tfa2 = new TestFileAppend2();
        tfa2.numDatanodes = Integer.parseInt(line.getOptionValue(OPT_NUM_DNS, "1"));
        tfa2.numThreads = Integer.parseInt(line.getOptionValue(OPT_NUM_THREADS, "30"));
        tfa2.numberOfFiles = Integer.parseInt(line.getOptionValue(OPT_NUM_FILES, "1"));
        tfa2.numAppendsPerThread = Integer.parseInt(line.getOptionValue(OPT_NUM_APPENDS, "1000"));
        tfa2.sleepBetweenSizeChecks = 10L;
        try {
            tfa2.testComplexAppend();
        }
        catch (Throwable t) {
            LOG.error((Object)"FAILED", t);
            System.exit(1);
        }
        System.exit(0);
    }

    class Workload
    extends Thread {
        private int id;
        private MiniDFSCluster cluster;

        Workload(MiniDFSCluster cluster, int threadIndex) {
            this.id = threadIndex;
            this.cluster = cluster;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("Workload " + this.id + " starting... ");
            for (int i = 0; i < TestFileAppend2.this.numAppendsPerThread && TestFileAppend2.this.err.get() == null; ++i) {
                Path testfile = null;
                ArrayList<Path> arrayList = TestFileAppend2.this.testFiles;
                synchronized (arrayList) {
                    if (TestFileAppend2.this.testFiles.size() == 0) {
                        System.out.println("Completed write to almost all files.");
                        return;
                    }
                    int index = AppendTestUtil.nextInt(TestFileAppend2.this.testFiles.size());
                    testfile = TestFileAppend2.this.testFiles.remove(index);
                }
                long len = 0L;
                int sizeToAppend = 0;
                try {
                    FileSystem fs = this.cluster.getFileSystem();
                    len = fs.getFileStatus(testfile).getLen();
                    if (len >= 5121L) {
                        System.out.println("File " + testfile + " is full.");
                        continue;
                    }
                    int left = (int)(5121L - len) / 3;
                    if (left <= 0) {
                        left = 1;
                    }
                    sizeToAppend = AppendTestUtil.nextInt(left);
                    System.out.println("Workload thread " + this.id + " appending " + sizeToAppend + " bytes " + " to file " + testfile + " of size " + len);
                    FSDataOutputStream stm = fs.append(testfile);
                    stm.write(TestFileAppend2.this.fileContents, (int)len, sizeToAppend);
                    stm.close();
                    long startWaitTime = System.currentTimeMillis();
                    while (fs.getFileStatus(testfile).getLen() != len + (long)sizeToAppend) {
                        try {
                            System.out.println("Workload thread " + this.id + " file " + testfile + " size " + fs.getFileStatus(testfile).getLen() + " expected size " + (len + (long)sizeToAppend) + " waiting for namenode metadata update.");
                            Thread.sleep(TestFileAppend2.this.sleepBetweenSizeChecks);
                            Assert.assertTrue((String)("Timed out waiting for len " + (len + (long)sizeToAppend) + " in file " + testfile + " (cur len is " + fs.getFileStatus(testfile).getLen() + ")"), (System.currentTimeMillis() - startWaitTime < 60000L ? 1 : 0) != 0);
                        }
                        catch (InterruptedException e) {}
                    }
                    Assert.assertTrue((String)("File " + testfile + " size is " + fs.getFileStatus(testfile).getLen() + " but expected " + (len + (long)sizeToAppend)), (fs.getFileStatus(testfile).getLen() == len + (long)sizeToAppend ? 1 : 0) != 0);
                    TestFileAppend2.this.checkFile(fs, testfile, (int)(len + (long)sizeToAppend));
                }
                catch (Throwable e) {
                    TestFileAppend2.this.err.compareAndSet(null, e);
                    LOG.error((Object)("Workload exception " + this.id + " testfile " + testfile + " expected size " + (len + (long)sizeToAppend)), e);
                    return;
                }
                ArrayList<Path> arrayList2 = TestFileAppend2.this.testFiles;
                synchronized (arrayList2) {
                    TestFileAppend2.this.testFiles.add(testfile);
                    continue;
                }
            }
        }
    }
}

