/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class FSMainOperationsBaseTest {
    private static String TEST_DIR_AAA2 = "test/hadoop2/aaa";
    private static String TEST_DIR_AAA = "test/hadoop/aaa";
    private static String TEST_DIR_AXA = "test/hadoop/axa";
    private static String TEST_DIR_AXX = "test/hadoop/axx";
    private static int numBlocks = 2;
    static final String LOCAL_FS_ROOT_URI = "file:///tmp/test";
    protected static FileSystem fSys;
    private static final PathFilter DEFAULT_FILTER;
    private static final PathFilter TEST_X_FILTER;
    private static byte[] data;

    @Before
    public void setUp() throws Exception {
        fSys.mkdirs(FileSystemTestHelper.getTestRootPath(fSys, "test"));
    }

    @After
    public void tearDown() throws Exception {
        fSys.delete(new Path(FileSystemTestHelper.getAbsoluteTestRootPath(fSys), new Path("test")), true);
        fSys.delete(new Path(LOCAL_FS_ROOT_URI), true);
    }

    protected Path getDefaultWorkingDirectory() throws IOException {
        return FileSystemTestHelper.getTestRootPath(fSys, "/user/" + System.getProperty("user.name")).makeQualified(fSys.getUri(), fSys.getWorkingDirectory());
    }

    protected boolean renameSupported() {
        return true;
    }

    protected IOException unwrapException(IOException e) {
        return e;
    }

    @Test
    public void testWorkingDirectory() throws Exception {
        Path workDir = new Path(FileSystemTestHelper.getAbsoluteTestRootPath(fSys), new Path("test"));
        fSys.setWorkingDirectory(workDir);
        Assert.assertEquals((Object)workDir, (Object)fSys.getWorkingDirectory());
        fSys.setWorkingDirectory(new Path("."));
        Assert.assertEquals((Object)workDir, (Object)fSys.getWorkingDirectory());
        fSys.setWorkingDirectory(new Path(".."));
        Assert.assertEquals((Object)workDir.getParent(), (Object)fSys.getWorkingDirectory());
        workDir = new Path(FileSystemTestHelper.getAbsoluteTestRootPath(fSys), new Path("test"));
        fSys.setWorkingDirectory(workDir);
        Assert.assertEquals((Object)workDir, (Object)fSys.getWorkingDirectory());
        Path relativeDir = new Path("existingDir1");
        Path absoluteDir = new Path(workDir, "existingDir1");
        fSys.mkdirs(absoluteDir);
        fSys.setWorkingDirectory(relativeDir);
        Assert.assertEquals((Object)absoluteDir, (Object)fSys.getWorkingDirectory());
        absoluteDir = FileSystemTestHelper.getTestRootPath(fSys, "test/existingDir2");
        fSys.mkdirs(absoluteDir);
        fSys.setWorkingDirectory(absoluteDir);
        Assert.assertEquals((Object)absoluteDir, (Object)fSys.getWorkingDirectory());
        Path absolutePath = new Path(absoluteDir, "foo");
        FileSystemTestHelper.createFile(fSys, absolutePath);
        fSys.open(new Path("foo")).close();
        fSys.mkdirs(new Path("newDir"));
        Assert.assertTrue((boolean)FileSystemTestHelper.isDir(fSys, new Path(absoluteDir, "newDir")));
        absoluteDir = new Path("file:///tmp/test/existingDir");
        fSys.mkdirs(absoluteDir);
        fSys.setWorkingDirectory(absoluteDir);
        Assert.assertEquals((Object)absoluteDir, (Object)fSys.getWorkingDirectory());
    }

    @Test
    public void testMkdirs() throws Exception {
        Path testDir = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop");
        Assert.assertFalse((boolean)FileSystemTestHelper.exists(fSys, testDir));
        Assert.assertFalse((boolean)FileSystemTestHelper.isFile(fSys, testDir));
        fSys.mkdirs(testDir);
        Assert.assertTrue((boolean)FileSystemTestHelper.exists(fSys, testDir));
        Assert.assertFalse((boolean)FileSystemTestHelper.isFile(fSys, testDir));
        fSys.mkdirs(testDir);
        Assert.assertTrue((boolean)FileSystemTestHelper.exists(fSys, testDir));
        Assert.assertFalse((boolean)FileSystemTestHelper.isFile(fSys, testDir));
        Path parentDir = testDir.getParent();
        Assert.assertTrue((boolean)FileSystemTestHelper.exists(fSys, parentDir));
        Assert.assertFalse((boolean)FileSystemTestHelper.isFile(fSys, parentDir));
        Path grandparentDir = parentDir.getParent();
        Assert.assertTrue((boolean)FileSystemTestHelper.exists(fSys, grandparentDir));
        Assert.assertFalse((boolean)FileSystemTestHelper.isFile(fSys, grandparentDir));
    }

    @Test
    public void testMkdirsFailsForSubdirectoryOfExistingFile() throws Exception {
        Path testDir = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop");
        Assert.assertFalse((boolean)FileSystemTestHelper.exists(fSys, testDir));
        fSys.mkdirs(testDir);
        Assert.assertTrue((boolean)FileSystemTestHelper.exists(fSys, testDir));
        this.createFile(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file"));
        Path testSubDir = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file/subdir");
        Assert.assertFalse((boolean)fSys.mkdirs(testSubDir));
        Assert.assertFalse((boolean)FileSystemTestHelper.exists(fSys, testSubDir));
        Path testDeepSubDir = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file/deep/sub/dir");
        Assert.assertFalse((boolean)FileSystemTestHelper.exists(fSys, testSubDir));
        Assert.assertFalse((boolean)fSys.mkdirs(testDeepSubDir));
        Assert.assertFalse((boolean)FileSystemTestHelper.exists(fSys, testDeepSubDir));
    }

    @Test
    public void testGetFileStatusThrowsExceptionForNonExistentFile() throws Exception {
        try {
            fSys.getFileStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file"));
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void testListStatusThrowsExceptionForNonExistentFile() throws Exception {
        try {
            fSys.listStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file"));
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testListStatus() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/a"), FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/b"), FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/c/1")};
        Assert.assertFalse((boolean)FileSystemTestHelper.exists(fSys, testDirs[0]));
        for (Path path : testDirs) {
            fSys.mkdirs(path);
        }
        FileStatus[] paths = fSys.listStatus(FileSystemTestHelper.getTestRootPath(fSys, "test"));
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop"), (Object)paths[0].getPath());
        paths = fSys.listStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop"));
        Assert.assertEquals((long)3L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/a"), paths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/b"), paths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/c"), paths));
        paths = fSys.listStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/a"));
        Assert.assertEquals((long)0L, (long)paths.length);
    }

    @Test
    public void testListStatusFilterWithNoMatches() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA2), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = fSys.listStatus(FileSystemTestHelper.getTestRootPath(fSys, "test"), TEST_X_FILTER);
        Assert.assertEquals((long)0L, (long)filteredPaths.length);
    }

    public void testListStatusFilterWithSomeMatches() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA2)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = fSys.listStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop"), TEST_X_FILTER);
        Assert.assertEquals((long)2L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusWithNoMatchesInPath() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA2)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] paths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/?"));
        Assert.assertEquals((long)0L, (long)paths.length);
    }

    @Test
    public void testGlobStatusSomeMatchesInDirectories() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA2)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] paths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop*"));
        Assert.assertEquals((long)2L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop"), paths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop2"), paths));
    }

    @Test
    public void testGlobStatusWithMultipleWildCardMatches() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA2)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] paths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop*/*"));
        Assert.assertEquals((long)4L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), paths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), paths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), paths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA2), paths));
    }

    @Test
    public void testGlobStatusWithMultipleMatchesOfSingleChar() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA2)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] paths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/ax?"));
        Assert.assertEquals((long)2L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), paths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), paths));
    }

    @Test
    public void testGlobStatusFilterWithEmptyPathResults() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/?"), DEFAULT_FILTER);
        Assert.assertEquals((long)0L, (long)filteredPaths.length);
    }

    @Test
    public void testGlobStatusFilterWithSomePathMatchesAndTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/*"), DEFAULT_FILTER);
        Assert.assertEquals((long)3L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusFilterWithMultipleWildCardMatchesAndTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/a??"), DEFAULT_FILTER);
        Assert.assertEquals((long)3L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusFilterWithMultiplePathMatchesAndNonTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/*"), TEST_X_FILTER);
        Assert.assertEquals((long)2L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusFilterWithNoMatchingPathsAndNonTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/?"), TEST_X_FILTER);
        Assert.assertEquals((long)0L, (long)filteredPaths.length);
    }

    @Test
    public void testGlobStatusFilterWithMultiplePathWildcardsAndNonTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AAA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX)};
        if (!FileSystemTestHelper.exists(fSys, testDirs[0])) {
            for (Path path : testDirs) {
                fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = fSys.globStatus(FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/a??"), TEST_X_FILTER);
        Assert.assertEquals((long)2L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsPath(FileSystemTestHelper.getTestRootPath(fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testWriteReadAndDeleteEmptyFile() throws Exception {
        this.writeReadAndDelete(0);
    }

    @Test
    public void testWriteReadAndDeleteHalfABlock() throws Exception {
        this.writeReadAndDelete(FileSystemTestHelper.getDefaultBlockSize() / 2);
    }

    @Test
    public void testWriteReadAndDeleteOneBlock() throws Exception {
        this.writeReadAndDelete(FileSystemTestHelper.getDefaultBlockSize());
    }

    @Test
    public void testWriteReadAndDeleteOneAndAHalfBlocks() throws Exception {
        int blockSize = FileSystemTestHelper.getDefaultBlockSize();
        this.writeReadAndDelete(blockSize + blockSize / 2);
    }

    @Test
    public void testWriteReadAndDeleteTwoBlocks() throws Exception {
        this.writeReadAndDelete(FileSystemTestHelper.getDefaultBlockSize() * 2);
    }

    private void writeReadAndDelete(int len) throws IOException {
        Path path = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        fSys.mkdirs(path.getParent());
        FSDataOutputStream out = fSys.create(path, false, 4096, (short)1, (long)FileSystemTestHelper.getDefaultBlockSize());
        out.write(data, 0, len);
        out.close();
        Assert.assertTrue((String)"Exists", (boolean)FileSystemTestHelper.exists(fSys, path));
        Assert.assertEquals((String)"Length", (long)len, (long)fSys.getFileStatus(path).getLen());
        FSDataInputStream in = fSys.open(path);
        byte[] buf = new byte[len];
        in.readFully(0L, buf);
        in.close();
        Assert.assertEquals((long)len, (long)buf.length);
        for (int i = 0; i < buf.length; ++i) {
            Assert.assertEquals((String)("Position " + i), (long)data[i], (long)buf[i]);
        }
        Assert.assertTrue((String)"Deleted", (boolean)fSys.delete(path, false));
        Assert.assertFalse((String)"No longer exists", (boolean)FileSystemTestHelper.exists(fSys, path));
    }

    @Test
    public void testOverwrite() throws IOException {
        Path path = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        fSys.mkdirs(path.getParent());
        this.createFile(path);
        Assert.assertTrue((String)"Exists", (boolean)FileSystemTestHelper.exists(fSys, path));
        Assert.assertEquals((String)"Length", (long)data.length, (long)fSys.getFileStatus(path).getLen());
        try {
            this.createFile(path);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        FSDataOutputStream out = fSys.create(path, true, 4096);
        out.write(data, 0, data.length);
        out.close();
        Assert.assertTrue((String)"Exists", (boolean)FileSystemTestHelper.exists(fSys, path));
        Assert.assertEquals((String)"Length", (long)data.length, (long)fSys.getFileStatus(path).getLen());
    }

    @Test
    public void testWriteInNonExistentDirectory() throws IOException {
        Path path = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        Assert.assertFalse((String)"Parent doesn't exist", (boolean)FileSystemTestHelper.exists(fSys, path.getParent()));
        this.createFile(path);
        Assert.assertTrue((String)"Exists", (boolean)FileSystemTestHelper.exists(fSys, path));
        Assert.assertEquals((String)"Length", (long)data.length, (long)fSys.getFileStatus(path).getLen());
        Assert.assertTrue((String)"Parent exists", (boolean)FileSystemTestHelper.exists(fSys, path.getParent()));
    }

    @Test
    public void testDeleteNonExistentFile() throws IOException {
        Path path = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        Assert.assertFalse((String)"Doesn't exist", (boolean)FileSystemTestHelper.exists(fSys, path));
        Assert.assertFalse((String)"No deletion", (boolean)fSys.delete(path, true));
    }

    @Test
    public void testDeleteRecursively() throws IOException {
        Path dir = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop");
        Path file = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        Path subdir = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/subdir");
        this.createFile(file);
        fSys.mkdirs(subdir);
        Assert.assertTrue((String)"File exists", (boolean)FileSystemTestHelper.exists(fSys, file));
        Assert.assertTrue((String)"Dir exists", (boolean)FileSystemTestHelper.exists(fSys, dir));
        Assert.assertTrue((String)"Subdir exists", (boolean)FileSystemTestHelper.exists(fSys, subdir));
        try {
            fSys.delete(dir, false);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        Assert.assertTrue((String)"File still exists", (boolean)FileSystemTestHelper.exists(fSys, file));
        Assert.assertTrue((String)"Dir still exists", (boolean)FileSystemTestHelper.exists(fSys, dir));
        Assert.assertTrue((String)"Subdir still exists", (boolean)FileSystemTestHelper.exists(fSys, subdir));
        Assert.assertTrue((String)"Deleted", (boolean)fSys.delete(dir, true));
        Assert.assertFalse((String)"File doesn't exist", (boolean)FileSystemTestHelper.exists(fSys, file));
        Assert.assertFalse((String)"Dir doesn't exist", (boolean)FileSystemTestHelper.exists(fSys, dir));
        Assert.assertFalse((String)"Subdir doesn't exist", (boolean)FileSystemTestHelper.exists(fSys, subdir));
    }

    @Test
    public void testDeleteEmptyDirectory() throws IOException {
        Path dir = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop");
        fSys.mkdirs(dir);
        Assert.assertTrue((String)"Dir exists", (boolean)FileSystemTestHelper.exists(fSys, dir));
        Assert.assertTrue((String)"Deleted", (boolean)fSys.delete(dir, false));
        Assert.assertFalse((String)"Dir doesn't exist", (boolean)FileSystemTestHelper.exists(fSys, dir));
    }

    @Test
    public void testInputStreamClosedTwice() throws IOException {
        Path src = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        this.createFile(src);
        FSDataInputStream in = fSys.open(src);
        in.close();
        in.close();
    }

    @Test
    public void testOutputStreamClosedTwice() throws IOException {
        Path src = FileSystemTestHelper.getTestRootPath(fSys, "test/hadoop/file");
        FSDataOutputStream out = fSys.create(src);
        out.writeChar(72);
        out.close();
        out.close();
    }

    protected void createFile(Path path) throws IOException {
        FileSystemTestHelper.createFile(fSys, path);
    }

    private boolean containsPath(Path path, FileStatus[] filteredPaths) throws IOException {
        for (int i = 0; i < filteredPaths.length; ++i) {
            if (!FileSystemTestHelper.getTestRootPath(fSys, path.toString()).equals((Object)filteredPaths[i].getPath())) continue;
            return true;
        }
        return false;
    }

    static {
        DEFAULT_FILTER = new PathFilter(){

            public boolean accept(Path file) {
                return true;
            }
        };
        TEST_X_FILTER = new PathFilter(){

            public boolean accept(Path file) {
                return file.getName().contains("x") || file.toString().contains("X");
            }
        };
        data = FileSystemTestHelper.getFileData(numBlocks, FileSystemTestHelper.getDefaultBlockSize());
    }
}

