/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import org.apache.hadoop.metrics2.util.SampleStat;
import org.junit.Assert;
import org.junit.Test;

public class TestSampleStat {
    private static final double EPSILON = 1.0E-42;

    @Test
    public void testSimple() {
        SampleStat stat = new SampleStat();
        Assert.assertEquals((String)"num samples", (long)0L, (long)stat.numSamples());
        Assert.assertEquals((String)"mean", (double)0.0, (double)stat.mean(), (double)1.0E-42);
        Assert.assertEquals((String)"variance", (double)0.0, (double)stat.variance(), (double)1.0E-42);
        Assert.assertEquals((String)"stddev", (double)0.0, (double)stat.stddev(), (double)1.0E-42);
        Assert.assertEquals((String)"min", (double)Double.MAX_VALUE, (double)stat.min(), (double)1.0E-42);
        Assert.assertEquals((String)"max", (double)Double.MIN_VALUE, (double)stat.max(), (double)1.0E-42);
        stat.add(3.0);
        Assert.assertEquals((String)"num samples", (long)1L, (long)stat.numSamples());
        Assert.assertEquals((String)"mean", (double)3.0, (double)stat.mean(), (double)1.0E-42);
        Assert.assertEquals((String)"variance", (double)0.0, (double)stat.variance(), (double)1.0E-42);
        Assert.assertEquals((String)"stddev", (double)0.0, (double)stat.stddev(), (double)1.0E-42);
        Assert.assertEquals((String)"min", (double)3.0, (double)stat.min(), (double)1.0E-42);
        Assert.assertEquals((String)"max", (double)3.0, (double)stat.max(), (double)1.0E-42);
        stat.add(2.0).add(1.0);
        Assert.assertEquals((String)"num samples", (long)3L, (long)stat.numSamples());
        Assert.assertEquals((String)"mean", (double)2.0, (double)stat.mean(), (double)1.0E-42);
        Assert.assertEquals((String)"variance", (double)1.0, (double)stat.variance(), (double)1.0E-42);
        Assert.assertEquals((String)"stddev", (double)1.0, (double)stat.stddev(), (double)1.0E-42);
        Assert.assertEquals((String)"min", (double)1.0, (double)stat.min(), (double)1.0E-42);
        Assert.assertEquals((String)"max", (double)3.0, (double)stat.max(), (double)1.0E-42);
        stat.reset();
        Assert.assertEquals((String)"num samples", (long)0L, (long)stat.numSamples());
        Assert.assertEquals((String)"mean", (double)0.0, (double)stat.mean(), (double)1.0E-42);
        Assert.assertEquals((String)"variance", (double)0.0, (double)stat.variance(), (double)1.0E-42);
        Assert.assertEquals((String)"stddev", (double)0.0, (double)stat.stddev(), (double)1.0E-42);
        Assert.assertEquals((String)"min", (double)Double.MAX_VALUE, (double)stat.min(), (double)1.0E-42);
        Assert.assertEquals((String)"max", (double)Double.MIN_VALUE, (double)stat.max(), (double)1.0E-42);
    }
}

