/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics.cloudwatch;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.cloudwatch.CloudWatchContext;
import org.apache.hadoop.metrics.cloudwatch.ConcreteRpcClient;
import org.apache.hadoop.metrics.cloudwatch.RpcClient;
import org.apache.hadoop.metrics.spi.OutputRecord;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCloudWatchContext
extends TestCase {
    private HashMap<String, Number> filteredMetrics;
    private Gson gson;
    private ConcreteRpcClient client;
    private Type mapType;
    private CloudWatchContext cloudWatchContext;

    protected void setUp() throws Exception {
        this.gson = new Gson();
        this.client = new ConcreteRpcClient(RpcClient.newDefaultConfiguration());
        this.filteredMetrics = new HashMap();
        this.mapType = new TypeToken<Map<String, Number>>(){}.getType();
        CloudWatchContext context = new CloudWatchContext();
        context.init("CloudWatchContext", ContextFactory.getFactory());
        this.cloudWatchContext = context;
    }

    protected void tearDown() {
        this.cloudWatchContext.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmitRecordWithExpectedInput() {
        this.filteredMetrics.put("dfs.namenode.numBlocksCorrupted", 0);
        this.filteredMetrics.put("dfs.FSNameSystem.totalLoad", 10);
        this.filteredMetrics.put("dfs.FSNameSystem.underReplicatedBlocks", 0);
        String jsonString = this.gson.toJson(this.filteredMetrics, this.mapType);
        try {
            RpcClient.Response response = this.client.transferMetrics(jsonString);
        }
        catch (Exception exception) {
        }
        finally {
            Assert.assertEquals((String)jsonString, (String)this.client.client.stringRequestEntity.getContent());
        }
    }

    @Test
    public void testEmptyDefaultMetricsList() throws Exception {
        Assert.assertEquals((boolean)false, (boolean)this.cloudWatchContext.getdefaultMetricsVector().contains("Test String"));
    }

    @Test
    public void testGson() {
        this.filteredMetrics.put("dfs.namenode.numBlocksCorrupted", 0);
        this.filteredMetrics.put("dfs.FSNameSystem.totalLoad", 10);
        this.filteredMetrics.put("dfs.FSNameSystem.underReplicatedBlocks", 0);
        String jsonString = this.gson.toJson(this.filteredMetrics, this.mapType);
        HashMap retrievedMap = (HashMap)this.gson.fromJson(jsonString, this.mapType);
        Assert.assertEquals((String)this.filteredMetrics.toString(), (String)retrievedMap.toString());
    }

    @Test
    public void testEmitRecord() throws IOException {
        OutputRecord mockOutputRecord = (OutputRecord)Mockito.mock(OutputRecord.class);
        LinkedHashSet<String> value = new LinkedHashSet<String>();
        value.add("fsImageLoadTime");
        value.add("CapacityUseGB");
        value.add("CapacityRemainingGB");
        Mockito.when((Object)mockOutputRecord.getMetricNames()).thenReturn(value);
        Mockito.when((Object)mockOutputRecord.getMetric("fsImageLoadTime")).thenReturn((Object)1);
        Mockito.when((Object)mockOutputRecord.getMetric("CapacityUseGB")).thenReturn((Object)240);
        this.cloudWatchContext.emitRecord("TestCloudWatchcontext", "TestRecord", mockOutputRecord);
    }

    @Test
    public void testEmitRecordWithNullMetricName() throws IOException {
        OutputRecord mockOutputRecord = (OutputRecord)Mockito.mock(OutputRecord.class);
        LinkedHashSet<String> value = new LinkedHashSet<String>();
        value.add("fsImageLoadTime");
        value.add("CapacityUseGB");
        value.add("CapacityRemainingGB");
        Mockito.when((Object)mockOutputRecord.getMetricNames()).thenReturn(value);
        Mockito.when((Object)mockOutputRecord.getMetric("fsImageLoadTime")).thenReturn((Object)1);
        Mockito.when((Object)mockOutputRecord.getMetric("CapacityUseGB")).thenReturn(null);
        this.cloudWatchContext.emitRecord("TestCloudWatchContext", "TestRecord", mockOutputRecord);
    }
}

