/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.WordCount;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class TestJobCounters
extends TestCase {
    String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", File.separator + "tmp")).toString().replace(' ', '+');

    private void validateMapredCounters(org.apache.hadoop.mapred.Counters counter, long spillRecCnt, long mapInputRecords, long mapOutputRecords) {
        TestJobCounters.assertEquals((long)spillRecCnt, (long)counter.findCounter((Enum)Task.Counter.SPILLED_RECORDS).getCounter());
        TestJobCounters.assertEquals((long)mapInputRecords, (long)counter.findCounter((Enum)Task.Counter.MAP_INPUT_RECORDS).getCounter());
        TestJobCounters.assertEquals((long)mapOutputRecords, (long)counter.findCounter((Enum)Task.Counter.MAP_OUTPUT_RECORDS).getCounter());
    }

    private void validateCounters(Counters counter, long spillRecCnt, long mapInputRecords, long mapOutputRecords) {
        TestJobCounters.assertEquals((long)spillRecCnt, (long)counter.findCounter((Enum)Task.Counter.SPILLED_RECORDS).getValue());
        TestJobCounters.assertEquals((long)mapInputRecords, (long)counter.findCounter((Enum)Task.Counter.MAP_INPUT_RECORDS).getValue());
        TestJobCounters.assertEquals((long)mapOutputRecords, (long)counter.findCounter((Enum)Task.Counter.MAP_OUTPUT_RECORDS).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWordsFile(File inpFile) throws Exception {
        BufferedWriter out = new BufferedWriter(new FileWriter(inpFile));
        try {
            int REPLICAS = 5;
            int NUMLINES = 500;
            int NUMWORDSPERLINE = 4;
            for (int i = 0; i < REPLICAS; ++i) {
                for (int j = 1; j <= NUMLINES * NUMWORDSPERLINE; j += NUMWORDSPERLINE) {
                    out.write("word" + j + " word" + (j + 1) + " word" + (j + 2) + " word" + (j + 3) + '\n');
                }
            }
        }
        finally {
            ((Writer)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOldJobWithMapAndReducers() throws Exception {
        JobConf conf = new JobConf(TestJobCounters.class);
        conf.setJobName("wordcount-map-reducers");
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setMapperClass(WordCount.MapClass.class);
        conf.setCombinerClass(WordCount.Reduce.class);
        conf.setReducerClass(WordCount.Reduce.class);
        conf.setNumMapTasks(3);
        conf.setNumReduceTasks(1);
        conf.setInt("io.sort.mb", 1);
        conf.setInt("io.sort.factor", 2);
        conf.set("io.sort.record.percent", "0.05");
        conf.set("io.sort.spill.percent", "0.80");
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path testDir = new Path(this.TEST_ROOT_DIR, "countertest");
        conf.set("test.build.data", testDir.toString());
        try {
            if (fs.exists(testDir)) {
                fs.delete(testDir, true);
            }
            if (!fs.mkdirs(testDir)) {
                throw new IOException("Mkdirs failed to create " + testDir.toString());
            }
            String inDir = testDir + File.separator + "genins" + File.separator;
            String outDir = testDir + File.separator;
            Path wordsIns = new Path(inDir);
            if (!fs.mkdirs(wordsIns)) {
                throw new IOException("Mkdirs failed to create " + wordsIns.toString());
            }
            File inpFile = new File(inDir + "input5_2k_1");
            this.createWordsFile(inpFile);
            inpFile = new File(inDir + "input5_2k_2");
            this.createWordsFile(inpFile);
            inpFile = new File(inDir + "input5_2k_3");
            this.createWordsFile(inpFile);
            FileInputFormat.setInputPaths((JobConf)conf, (String)inDir);
            Path outputPath1 = new Path(outDir, "output5_2k_3");
            FileOutputFormat.setOutputPath((JobConf)conf, (Path)outputPath1);
            RunningJob myJob = JobClient.runJob((JobConf)conf);
            org.apache.hadoop.mapred.Counters c1 = myJob.getCounters();
            this.validateMapredCounters(c1, 64000L, 7500L, 30000L);
            inpFile = new File(inDir + "input5_2k_4");
            this.createWordsFile(inpFile);
            conf.setNumMapTasks(4);
            Path outputPath2 = new Path(outDir, "output5_2k_4");
            FileOutputFormat.setOutputPath((JobConf)conf, (Path)outputPath2);
            myJob = JobClient.runJob((JobConf)conf);
            c1 = myJob.getCounters();
            this.validateMapredCounters(c1, 88000L, 10000L, 40000L);
            conf.setNumReduceTasks(0);
            Path outputPath3 = new Path(outDir, "output5_2k_5");
            FileOutputFormat.setOutputPath((JobConf)conf, (Path)outputPath3);
            myJob = JobClient.runJob((JobConf)conf);
            c1 = myJob.getCounters();
            this.validateMapredCounters(c1, 0L, 10000L, 40000L);
        }
        finally {
            if (fs.exists(testDir)) {
                fs.delete(testDir, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNewJobWithMapAndReducers() throws Exception {
        JobConf conf = new JobConf(TestJobCounters.class);
        conf.setInt("io.sort.mb", 1);
        conf.setInt("io.sort.factor", 2);
        conf.set("io.sort.record.percent", "0.05");
        conf.set("io.sort.spill.percent", "0.80");
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path testDir = new Path(this.TEST_ROOT_DIR, "countertest2");
        conf.set("test.build.data", testDir.toString());
        try {
            if (fs.exists(testDir)) {
                fs.delete(testDir, true);
            }
            if (!fs.mkdirs(testDir)) {
                throw new IOException("Mkdirs failed to create " + testDir.toString());
            }
            String inDir = testDir + File.separator + "genins" + File.separator;
            Path wordsIns = new Path(inDir);
            if (!fs.mkdirs(wordsIns)) {
                throw new IOException("Mkdirs failed to create " + wordsIns.toString());
            }
            String outDir = testDir + File.separator;
            File inpFile = new File(inDir + "input5_2k_1");
            this.createWordsFile(inpFile);
            inpFile = new File(inDir + "input5_2k_2");
            this.createWordsFile(inpFile);
            inpFile = new File(inDir + "input5_2k_3");
            this.createWordsFile(inpFile);
            FileInputFormat.setInputPaths((JobConf)conf, (String)inDir);
            Path outputPath1 = new Path(outDir, "output5_2k_3");
            FileOutputFormat.setOutputPath((JobConf)conf, (Path)outputPath1);
            Job job = new Job((Configuration)conf);
            job.setJobName("wordcount-map-reducers");
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(IntWritable.class);
            job.setMapperClass(NewMapTokenizer.class);
            job.setCombinerClass(NewIdentityReducer.class);
            job.setReducerClass(NewIdentityReducer.class);
            job.setNumReduceTasks(1);
            job.waitForCompletion(false);
            Counters c1 = job.getCounters();
            this.validateCounters(c1, 64000L, 7500L, 30000L);
            inpFile = new File(inDir + "input5_2k_4");
            this.createWordsFile(inpFile);
            JobConf newJobConf = new JobConf(job.getConfiguration());
            Path outputPath2 = new Path(outDir, "output5_2k_4");
            FileOutputFormat.setOutputPath((JobConf)newJobConf, (Path)outputPath2);
            Job newJob = new Job((Configuration)newJobConf);
            newJob.waitForCompletion(false);
            c1 = newJob.getCounters();
            this.validateCounters(c1, 88000L, 10000L, 40000L);
            JobConf newJobConf2 = new JobConf(newJob.getConfiguration());
            Path outputPath3 = new Path(outDir, "output5_2k_5");
            FileOutputFormat.setOutputPath((JobConf)newJobConf2, (Path)outputPath3);
            Job newJob2 = new Job((Configuration)newJobConf2);
            newJob2.setNumReduceTasks(0);
            newJob2.waitForCompletion(false);
            c1 = newJob2.getCounters();
            this.validateCounters(c1, 0L, 10000L, 40000L);
        }
        finally {
            if (fs.exists(testDir)) {
                fs.delete(testDir, true);
            }
        }
    }

    public static class NewIdentityReducer
    extends Reducer<Text, IntWritable, Text, IntWritable> {
        private IntWritable result = new IntWritable();

        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            this.result.set(sum);
            context.write((Object)key, (Object)this.result);
        }
    }

    public static class NewMapTokenizer
    extends Mapper<Object, Text, Text, IntWritable> {
        private static final IntWritable one = new IntWritable(1);
        private Text word = new Text();

        public void map(Object key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            StringTokenizer itr = new StringTokenizer(value.toString());
            while (itr.hasMoreTokens()) {
                this.word.set(itr.nextToken());
                context.write((Object)this.word, (Object)one);
            }
        }
    }
}

