/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;

public class TestFileInputFormat
extends TestCase {
    Configuration conf = new Configuration();
    MiniDFSCluster dfs = null;
    final Path root = new Path("/TestFileInputFormat");
    final Path file1 = new Path(this.root, "file1");
    final Path dir1 = new Path(this.root, "dir1");
    final Path file2 = new Path(this.dir1, "file2");
    static final int BLOCKSIZE = 1024;
    static final byte[] databuf = new byte[1024];
    private static final String[] rack1 = new String[]{"/r1"};
    private static final String[] hosts1 = new String[]{"host1.rack1.com"};

    public void setUp() throws Exception {
        this.dfs = new MiniDFSCluster(this.conf, 4, true, new String[]{"/rack0", "/rack0", "/rack1", "/rack1"}, new String[]{"host0", "host1", "host2", "host3"});
    }

    public void testLocality() throws Exception {
        JobConf job = new JobConf(this.conf);
        FileSystem fs = this.dfs.getFileSystem();
        System.out.println("FileSystem " + fs.getUri());
        Path inputDir = new Path("/foo/");
        String fileName = "part-0000";
        this.createInputs(fs, inputDir, fileName);
        TextInputFormat.addInputPath((JobConf)job, (Path)inputDir);
        TextInputFormat inFormat = new TextInputFormat();
        inFormat.configure(job);
        InputSplit[] splits = inFormat.getSplits(job, 1);
        FileStatus fileStatus = fs.getFileStatus(new Path(inputDir, fileName));
        BlockLocation[] locations = fs.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen());
        System.out.println("Made splits");
        for (int i = 0; i < splits.length; ++i) {
            FileSplit fileSplit = (FileSplit)splits[i];
            System.out.println("File split: " + fileSplit);
            for (String h : fileSplit.getLocations()) {
                System.out.println("Location: " + h);
            }
            System.out.println("Block: " + locations[i]);
            TestFileInputFormat.assertEquals((long)locations[i].getOffset(), (long)fileSplit.getStart());
            TestFileInputFormat.assertEquals((long)locations[i].getLength(), (long)fileSplit.getLength());
            String[] blockLocs = locations[i].getHosts();
            String[] splitLocs = fileSplit.getLocations();
            TestFileInputFormat.assertEquals((int)2, (int)blockLocs.length);
            TestFileInputFormat.assertEquals((int)2, (int)splitLocs.length);
            TestFileInputFormat.assertTrue((blockLocs[0].equals(splitLocs[0]) && blockLocs[1].equals(splitLocs[1]) || blockLocs[1].equals(splitLocs[0]) && blockLocs[0].equals(splitLocs[1]) ? 1 : 0) != 0);
        }
        TestFileInputFormat.assertEquals((String)"Expected value of mapreduce.input.num.files", (long)1L, (long)job.getLong("mapreduce.input.num.files", 0L));
    }

    private void createInputs(FileSystem fs, Path inDir, String fileName) throws IOException {
        FSDataOutputStream out = fs.create(new Path(inDir, fileName), true, 4096, (short)2, 512L, null);
        for (int i = 0; i < 1000; ++i) {
            out.writeChars("Hello\n");
        }
        out.close();
        System.out.println("Wrote file");
    }

    public void testNumInputs() throws Exception {
        JobConf job = new JobConf(this.conf);
        FileSystem fs = this.dfs.getFileSystem();
        System.out.println("FileSystem " + fs.getUri());
        Path inputDir = new Path("/foo/");
        int numFiles = 10;
        String fileNameBase = "part-0000";
        for (int i = 0; i < 10; ++i) {
            this.createInputs(fs, inputDir, fileNameBase + String.valueOf(i));
        }
        this.createInputs(fs, inputDir, "_meta");
        this.createInputs(fs, inputDir, "_temp");
        TextInputFormat.addInputPath((JobConf)job, (Path)inputDir);
        TextInputFormat inFormat = new TextInputFormat();
        inFormat.configure(job);
        InputSplit[] splits = inFormat.getSplits(job, 1);
        TestFileInputFormat.assertEquals((String)"Expected value of mapreduce.input.num.files", (long)10L, (long)job.getLong("mapreduce.input.num.files", 0L));
    }

    public void testMultiLevelInput() throws IOException {
        InputSplit[] splits;
        JobConf job = new JobConf(this.conf);
        job.setBoolean("dfs.replication.considerLoad", false);
        this.dfs = new MiniDFSCluster((Configuration)job, 1, true, rack1, hosts1);
        this.dfs.waitActive();
        String namenode = this.dfs.getFileSystem().getUri().getHost() + ":" + this.dfs.getFileSystem().getUri().getPort();
        FileSystem fileSys = this.dfs.getFileSystem();
        if (!fileSys.mkdirs(this.dir1)) {
            throw new IOException("Mkdirs failed to create " + this.root.toString());
        }
        TestFileInputFormat.writeFile((Configuration)job, this.file1, (short)1, 1);
        TestFileInputFormat.writeFile((Configuration)job, this.file2, (short)1, 1);
        DummyFileInputFormat inFormat = new DummyFileInputFormat();
        DummyFileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{this.root});
        boolean exceptionThrown = false;
        try {
            splits = inFormat.getSplits(job, 1);
        }
        catch (Exception e) {
            exceptionThrown = true;
        }
        TestFileInputFormat.assertTrue((String)"Exception should be thrown by default for scanning a directory with directories inside.", (boolean)exceptionThrown);
        job.setBoolean("mapred.input.dir.recursive", true);
        splits = inFormat.getSplits(job, 1);
        TestFileInputFormat.assertEquals((int)splits.length, (int)2);
    }

    static void writeFile(Configuration conf, Path name, short replication, int numBlocks) throws IOException {
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        FSDataOutputStream stm = fileSys.create(name, true, conf.getInt("io.file.buffer.size", 4096), replication, 1024L);
        for (int i = 0; i < numBlocks; ++i) {
            stm.write(databuf);
        }
        stm.close();
        DFSTestUtil.waitReplication(fileSys, name, replication);
    }

    public void tearDown() throws Exception {
        if (this.dfs != null) {
            this.dfs.shutdown();
        }
    }

    private class DummyFileInputFormat
    extends FileInputFormat<Text, Text> {
        private DummyFileInputFormat() {
        }

        public RecordReader<Text, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            return null;
        }
    }
}

