/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.DelimitedImageVisitor;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageVisitor;

public class TestDelimitedImageVisitor
extends TestCase {
    private static String ROOT = System.getProperty("test.build.data", "/tmp");
    private static final String delim = "--";

    private void build(DelimitedImageVisitor div, ImageVisitor.ImageElement elem, String val, StringBuilder sb, boolean includeDelim) throws IOException {
        div.visit(elem, val);
        sb.append(val);
        if (includeDelim) {
            sb.append(delim);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDelimitedImageVisistor() {
        String filename = ROOT + "/testDIV";
        File f = new File(filename);
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            DelimitedImageVisitor div = new DelimitedImageVisitor(filename, true, delim);
            div.visit(ImageVisitor.ImageElement.FS_IMAGE, "Not in ouput");
            div.visitEnclosingElement(ImageVisitor.ImageElement.INODE);
            div.visit(ImageVisitor.ImageElement.LAYOUT_VERSION, "not in");
            div.visit(ImageVisitor.ImageElement.LAYOUT_VERSION, "the output");
            this.build(div, ImageVisitor.ImageElement.INODE_PATH, "hartnell", sb, true);
            this.build(div, ImageVisitor.ImageElement.REPLICATION, "99", sb, true);
            this.build(div, ImageVisitor.ImageElement.MODIFICATION_TIME, "troughton", sb, true);
            this.build(div, ImageVisitor.ImageElement.ACCESS_TIME, "pertwee", sb, true);
            this.build(div, ImageVisitor.ImageElement.BLOCK_SIZE, "baker", sb, true);
            this.build(div, ImageVisitor.ImageElement.NUM_BLOCKS, "davison", sb, true);
            this.build(div, ImageVisitor.ImageElement.NUM_BYTES, "55", sb, true);
            this.build(div, ImageVisitor.ImageElement.NS_QUOTA, "baker2", sb, true);
            this.build(div, ImageVisitor.ImageElement.DS_QUOTA, "mccoy", sb, true);
            this.build(div, ImageVisitor.ImageElement.PERMISSION_STRING, "eccleston", sb, true);
            this.build(div, ImageVisitor.ImageElement.USER_NAME, "tennant", sb, true);
            this.build(div, ImageVisitor.ImageElement.GROUP_NAME, "smith", sb, false);
            div.leaveEnclosingElement();
            div.finish();
            br = new BufferedReader(new FileReader(f));
            String actual = br.readLine();
            TestDelimitedImageVisitor.assertNull((Object)br.readLine());
            br.close();
            String exepcted = sb.toString();
            System.out.println("Expect to get: " + exepcted);
            System.out.println("Actually got:  " + actual);
            TestDelimitedImageVisitor.assertEquals((String)exepcted, (String)actual);
        }
        catch (IOException e) {
            TestDelimitedImageVisitor.fail((String)("Error while testing delmitedImageVisitor" + e.getMessage()));
        }
        finally {
            if (f.exists()) {
                f.delete();
            }
        }
    }
}

