/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class TestNodeCount
extends TestCase {
    static final Log LOG = LogFactory.getLog(TestNodeCount.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidateMultipleReplicas() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 5, true, null);
        int FILE_LEN = 123;
        String pathStr = "/testInvalidateMultipleReplicas";
        try {
            FileSystem fs = cluster.getFileSystem();
            Path path = new Path("/testInvalidateMultipleReplicas");
            cluster.waitActive();
            DFSTestUtil.createFile(fs, path, 123L, (short)3, 0L);
            DFSTestUtil.waitReplication(fs, path, (short)3);
            NameNode nn = cluster.getNameNode();
            LocatedBlocks located = nn.getBlockLocations("/testInvalidateMultipleReplicas", 0L, 123L);
            List blocks = located.getLocatedBlocks();
            LocatedBlock firstBlock = (LocatedBlock)blocks.get(0);
            DatanodeInfo[] locations = firstBlock.getLocations();
            TestNodeCount.assertEquals((String)"Should have 3 good blocks", (int)3, (int)locations.length);
            nn.getNamesystem().stallReplicationWork();
            DatanodeInfo[] badLocations = new DatanodeInfo[]{locations[0], locations[1]};
            LocatedBlock badLBlock = new LocatedBlock(firstBlock.getBlock(), badLocations);
            nn.reportBadBlocks(new LocatedBlock[]{badLBlock});
            nn.getNamesystem().restartReplicationWork();
            DFSTestUtil.waitReplication(fs, path, (short)3);
            FSNamesystem.NumberReplicas num = nn.getNamesystem().countNodes(firstBlock.getBlock());
            TestNodeCount.assertEquals((int)0, (int)num.corruptReplicas());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodeCount() throws Exception {
        Configuration conf = new Configuration();
        int REPLICATION_FACTOR = 2;
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 2, true, null);
        try {
            FSNamesystem.NumberReplicas num;
            Object dn;
            FSNamesystem namesystem = cluster.getNameNode().namesystem;
            FileSystem fs = cluster.getFileSystem();
            Path FILE_PATH = new Path("/testfile");
            DFSTestUtil.createFile(fs, FILE_PATH, 1L, (short)2, 1L);
            DFSTestUtil.waitReplication(fs, FILE_PATH, (short)2);
            Block block = DFSTestUtil.getFirstBlock(fs, FILE_PATH);
            DatanodeDescriptor[] datanodes = namesystem.heartbeats.toArray(new DatanodeDescriptor[2]);
            cluster.startDataNodes(conf, 2, true, null, null);
            cluster.waitActive(false);
            LOG.info((Object)"Bringing down first DN");
            DatanodeDescriptor datanode = datanodes[0];
            MiniDFSCluster.DataNodeProperties dnprop = cluster.stopDataNode(datanode.getName());
            ArrayList arrayList = namesystem.heartbeats;
            synchronized (arrayList) {
                datanode.setLastUpdate(0L);
                namesystem.heartbeatCheck();
            }
            LOG.info((Object)"Waiting for block to be replicated");
            DFSTestUtil.waitReplication(fs, FILE_PATH, (short)2);
            LOG.info((Object)"Restarting first datanode");
            cluster.restartDataNode(dnprop);
            cluster.waitActive(false);
            LOG.info((Object)"Waiting for excess replicas to be detected");
            this.waitForExcessReplicasToChangeTo(namesystem, block, 1);
            LOG.info((Object)"Finding a non-excess node");
            Iterator iter = namesystem.blocksMap.nodeIterator(block);
            DatanodeDescriptor nonExcessDN = null;
            while (iter.hasNext()) {
                dn = (DatanodeDescriptor)iter.next();
                Collection blocks = (Collection)namesystem.excessReplicateMap.get(dn.getStorageID());
                if (blocks != null && blocks.contains(block)) continue;
                nonExcessDN = dn;
                break;
            }
            TestNodeCount.assertTrue((nonExcessDN != null ? 1 : 0) != 0);
            LOG.info((Object)("Stopping non-excess node: " + nonExcessDN));
            dnprop = cluster.stopDataNode(nonExcessDN.getName());
            dn = namesystem.heartbeats;
            synchronized (dn) {
                nonExcessDN.setLastUpdate(0L);
                namesystem.heartbeatCheck();
            }
            LOG.info((Object)"Waiting for live replicas to hit repl factor");
            while ((num = namesystem.countNodes(block)).liveReplicas() != 2) {
            }
            LOG.info((Object)"Restarting first DN");
            cluster.restartDataNode(dnprop);
            cluster.waitActive(false);
            Thread.sleep(3000L);
            LOG.info((Object)"Waiting for excess replicas to be detected");
            this.waitForExcessReplicasToChangeTo(namesystem, block, 2);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForExcessReplicasToChangeTo(FSNamesystem namesystem, Block block, int waitForReplicas) throws Exception {
        FSNamesystem.NumberReplicas num;
        long startChecking = System.currentTimeMillis();
        do {
            FSNamesystem fSNamesystem = namesystem;
            synchronized (fSNamesystem) {
                num = namesystem.countNodes(block);
            }
            LOG.info((Object)("Waiting for excess replicas == " + waitForReplicas + " - current: " + num));
            Thread.sleep(200L);
            if (System.currentTimeMillis() - startChecking <= 30000L) continue;
            namesystem.metaSave("TestNodeCount.meta");
            LOG.warn((Object)"Dumping meta into log directory");
            TestNodeCount.fail((String)"Timed out waiting for excess replicas to change");
        } while (num.excessReplicas() != waitForReplicas);
    }
}

