/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.log4j.Level;

public class TestFileStatus
extends TestCase {
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    static final int fileSize = 16384;

    public TestFileStatus() {
        ((Log4JLogger)FSNamesystem.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)FileSystem.LOG).getLogger().setLevel(Level.ALL);
    }

    private void writeFile(FileSystem fileSys, Path name, int repl, int fileSize, int blockSize) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, (long)blockSize);
        byte[] buffer = new byte[fileSize];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    private void checkFile(FileSystem fileSys, Path name, int repl) throws IOException {
        DFSTestUtil.waitReplication(fileSys, name, (short)repl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileStatus() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ls.limit", 2);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        FileSystem fs = cluster.getFileSystem();
        HftpFileSystem hftpfs = cluster.getHftpFileSystem();
        DFSClient dfsClient = new DFSClient(NameNode.getAddress((Configuration)conf), conf);
        try {
            Path path = new Path("/");
            System.out.println("Path : \"" + path.toString() + "\"");
            TestFileStatus.assertTrue((String)"/ should be a directory", (fs.getFileStatus(path).isDir() ? 1 : 0) != 0);
            HdfsFileStatus fileInfo = dfsClient.getFileInfo("/noSuchFile");
            TestFileStatus.assertTrue((fileInfo == null ? 1 : 0) != 0);
            Path file1 = new Path("filestatus.dat");
            this.writeFile(fs, file1, 1, 16384, 8192);
            System.out.println("Created file filestatus.dat with one  replicas.");
            this.checkFile(fs, file1, 1);
            System.out.println("Path : \"" + file1 + "\"");
            FileStatus status = fs.getFileStatus(file1);
            TestFileStatus.assertTrue((String)(file1 + " should be a file"), (!status.isDir() ? 1 : 0) != 0);
            TestFileStatus.assertTrue((status.getBlockSize() == 8192L ? 1 : 0) != 0);
            TestFileStatus.assertTrue((status.getReplication() == 1 ? 1 : 0) != 0);
            TestFileStatus.assertTrue((status.getLen() == 16384L ? 1 : 0) != 0);
            TestFileStatus.assertEquals((String)fs.makeQualified(file1).toString(), (String)status.getPath().toString());
            DFSClient.DFSDataInputStream fin = (DFSClient.DFSDataInputStream)fs.open(file1);
            TestFileStatus.assertEquals((long)status.getLen(), (long)fin.getVisibleLength());
            FileStatus[] stats = fs.listStatus(file1);
            TestFileStatus.assertEquals((int)1, (int)stats.length);
            status = stats[0];
            TestFileStatus.assertTrue((String)(file1 + " should be a file"), (!status.isDir() ? 1 : 0) != 0);
            TestFileStatus.assertTrue((status.getBlockSize() == 8192L ? 1 : 0) != 0);
            TestFileStatus.assertTrue((status.getReplication() == 1 ? 1 : 0) != 0);
            TestFileStatus.assertTrue((status.getLen() == 16384L ? 1 : 0) != 0);
            TestFileStatus.assertEquals((String)fs.makeQualified(file1).toString(), (String)status.getPath().toString());
            Path dir = new Path("/test/mkdirs");
            stats = fs.listStatus(dir);
            TestFileStatus.assertEquals(null, (Object)stats);
            try {
                status = fs.getFileStatus(dir);
                TestFileStatus.fail((String)"getFileStatus of non-existent path should fail");
            }
            catch (FileNotFoundException fe) {
                TestFileStatus.assertTrue((boolean)fe.getMessage().startsWith("File does not exist"));
            }
            TestFileStatus.assertTrue((boolean)fs.mkdirs(dir));
            TestFileStatus.assertTrue((boolean)fs.exists(dir));
            System.out.println("Dir : \"" + dir + "\"");
            status = fs.getFileStatus(dir);
            TestFileStatus.assertTrue((String)(dir + " should be a directory"), (boolean)status.isDir());
            TestFileStatus.assertTrue((String)(dir + " should be zero size "), (status.getLen() == 0L ? 1 : 0) != 0);
            TestFileStatus.assertEquals((String)fs.makeQualified(dir).toString(), (String)status.getPath().toString());
            stats = fs.listStatus(dir);
            TestFileStatus.assertEquals((String)(dir + " should be empty"), (int)0, (int)stats.length);
            TestFileStatus.assertEquals((String)(dir + " should be zero size "), (long)0L, (long)fs.getContentSummary(dir).getLength());
            TestFileStatus.assertEquals((String)(dir + " should be zero size using hftp"), (long)0L, (long)hftpfs.getContentSummary(dir).getLength());
            TestFileStatus.assertTrue((String)(dir + " should be zero size "), (fs.getFileStatus(dir).getLen() == 0L ? 1 : 0) != 0);
            System.out.println("Dir : \"" + dir + "\"");
            Path file2 = new Path(dir, "filestatus2.dat");
            this.writeFile(fs, file2, 1, 2048, 8192);
            System.out.println("Created file filestatus2.dat with one  replicas.");
            this.checkFile(fs, file2, 1);
            System.out.println("Path : \"" + file2 + "\"");
            status = fs.getFileStatus(file2);
            TestFileStatus.assertTrue((status.getBlockSize() == 8192L ? 1 : 0) != 0);
            TestFileStatus.assertTrue((status.getReplication() == 1 ? 1 : 0) != 0);
            file2 = fs.makeQualified(file2);
            TestFileStatus.assertEquals((String)file2.toString(), (String)status.getPath().toString());
            Path file3 = new Path(dir, "filestatus3.dat");
            this.writeFile(fs, file3, 1, 2048, 8192);
            System.out.println("Created file filestatus3.dat with one  replicas.");
            this.checkFile(fs, file3, 1);
            file3 = fs.makeQualified(file3);
            int expected = 4096;
            TestFileStatus.assertEquals((String)(dir + " size should be " + 4096), (long)4096L, (long)fs.getContentSummary(dir).getLength());
            TestFileStatus.assertEquals((String)(dir + " size should be " + 4096 + " using hftp"), (long)4096L, (long)hftpfs.getContentSummary(dir).getLength());
            stats = fs.listStatus(dir);
            TestFileStatus.assertEquals((String)(dir + " should have two entries"), (int)2, (int)stats.length);
            TestFileStatus.assertEquals((String)file2.toString(), (String)stats[0].getPath().toString());
            TestFileStatus.assertEquals((String)file3.toString(), (String)stats[1].getPath().toString());
            Path dir3 = fs.makeQualified(new Path(dir, "dir3"));
            fs.mkdirs(dir3);
            dir3 = fs.makeQualified(dir3);
            stats = fs.listStatus(dir);
            TestFileStatus.assertEquals((String)(dir + " should have three entries"), (int)3, (int)stats.length);
            TestFileStatus.assertEquals((String)dir3.toString(), (String)stats[0].getPath().toString());
            TestFileStatus.assertEquals((String)file2.toString(), (String)stats[1].getPath().toString());
            TestFileStatus.assertEquals((String)file3.toString(), (String)stats[2].getPath().toString());
            Path dir4 = fs.makeQualified(new Path(dir, "dir4"));
            fs.mkdirs(dir4);
            dir4 = fs.makeQualified(dir4);
            Path dir5 = fs.makeQualified(new Path(dir, "dir5"));
            fs.mkdirs(dir5);
            dir5 = fs.makeQualified(dir5);
            stats = fs.listStatus(dir);
            TestFileStatus.assertEquals((String)(dir + " should have five entries"), (int)5, (int)stats.length);
            TestFileStatus.assertEquals((String)dir3.toString(), (String)stats[0].getPath().toString());
            TestFileStatus.assertEquals((String)dir4.toString(), (String)stats[1].getPath().toString());
            TestFileStatus.assertEquals((String)dir5.toString(), (String)stats[2].getPath().toString());
            TestFileStatus.assertEquals((String)file2.toString(), (String)stats[3].getPath().toString());
            TestFileStatus.assertEquals((String)file3.toString(), (String)stats[4].getPath().toString());
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }
}

