/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FileDistributionVisitor;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageVisitor;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.LsImageVisitor;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.OfflineImageViewer;

public class TestOfflineImageViewer
extends TestCase {
    private static final int NUM_DIRS = 3;
    private static final int FILES_PER_DIR = 4;
    final HashMap<String, FileStatus> writtenFiles = new HashMap();
    private static String ROOT = System.getProperty("test.build.data", "build/test/data");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOIV() {
        File originalFsimage = null;
        try {
            originalFsimage = this.initFsimage();
            TestOfflineImageViewer.assertNotNull((String)"originalFsImage shouldn't be null", (Object)originalFsimage);
            this.outputOfLSVisitor(originalFsimage);
            this.outputOfFileDistributionVisitor(originalFsimage);
            this.unsupportedFSLayoutVersion(originalFsimage);
            this.truncatedFSImage(originalFsimage);
        }
        finally {
            if (originalFsimage != null && originalFsimage.exists()) {
                originalFsimage.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File initFsimage() {
        MiniDFSCluster cluster = null;
        File orig = null;
        try {
            Configuration conf = new Configuration();
            cluster = new MiniDFSCluster(conf, 4, true, null);
            FileSystem hdfs = cluster.getFileSystem();
            int filesize = 256;
            for (int i = 0; i < 3; ++i) {
                Path dir = new Path("/dir" + i);
                hdfs.mkdirs(dir);
                this.writtenFiles.put(dir.toString(), this.pathToFileEntry(hdfs, dir.toString()));
                for (int j = 0; j < 4; ++j) {
                    Path file = new Path(dir, "file" + j);
                    FSDataOutputStream o = hdfs.create(file);
                    o.write(new byte[filesize++]);
                    o.close();
                    this.writtenFiles.put(file.toString(), this.pathToFileEntry(hdfs, file.toString()));
                }
            }
            cluster.getNameNode().setSafeMode(FSConstants.SafeModeAction.SAFEMODE_ENTER);
            cluster.getNameNode().saveNamespace();
            File[] files = cluster.getNameDirs().toArray(new File[0]);
            orig = new File(files[0], "current/fsimage");
            if (!orig.exists()) {
                TestOfflineImageViewer.fail((String)"Didn't generate or can't find fsimage.");
            }
        }
        catch (IOException e) {
            TestOfflineImageViewer.fail((String)("Failed trying to generate fsimage file: " + e.getMessage()));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        return orig;
    }

    private FileStatus pathToFileEntry(FileSystem hdfs, String file) throws IOException {
        return hdfs.getFileStatus(new Path(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputOfLSVisitor(File originalFsimage) {
        File testFile = new File(ROOT, "/basicCheck");
        File outputFile = new File(ROOT, "/basicCheckOutput");
        try {
            this.copyFile(originalFsimage, testFile);
            LsImageVisitor v = new LsImageVisitor(outputFile.getPath(), true);
            OfflineImageViewer oiv = new OfflineImageViewer(testFile.getPath(), (ImageVisitor)v, false);
            oiv.go();
            HashMap<String, LsElements> fileOutput = this.readLsfile(outputFile);
            this.compareNamespaces(this.writtenFiles, fileOutput);
        }
        catch (IOException e) {
            TestOfflineImageViewer.fail((String)("Failed reading valid file: " + e.getMessage()));
        }
        finally {
            if (testFile.exists()) {
                testFile.delete();
            }
            if (outputFile.exists()) {
                outputFile.delete();
            }
        }
        System.out.println("Correctly generated ls-style output.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsupportedFSLayoutVersion(File originalFsimage) {
        File testFile = new File(ROOT, "/invalidLayoutVersion");
        File outputFile = new File(ROOT, "invalidLayoutVersionOutput");
        try {
            int badVersionNum = -432;
            this.changeLayoutVersion(originalFsimage, testFile, badVersionNum);
            LsImageVisitor v = new LsImageVisitor(outputFile.getPath(), true);
            OfflineImageViewer oiv = new OfflineImageViewer(testFile.getPath(), (ImageVisitor)v, false);
            try {
                oiv.go();
                TestOfflineImageViewer.fail((String)"Shouldn't be able to read invalid laytout version");
            }
            catch (IOException e) {
                if (!e.getMessage().contains(Integer.toString(badVersionNum))) {
                    throw e;
                }
                System.out.println("Correctly failed at reading bad image version.");
            }
        }
        catch (IOException e) {
            TestOfflineImageViewer.fail((String)("Problem testing unsupported layout version: " + e.getMessage()));
        }
        finally {
            if (testFile.exists()) {
                testFile.delete();
            }
            if (outputFile.exists()) {
                outputFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void truncatedFSImage(File originalFsimage) {
        File testFile = new File(ROOT, "/truncatedFSImage");
        File outputFile = new File(ROOT, "/trucnatedFSImageOutput");
        try {
            this.copyPartOfFile(originalFsimage, testFile);
            TestOfflineImageViewer.assertTrue((String)"Created truncated fsimage", (boolean)testFile.exists());
            LsImageVisitor v = new LsImageVisitor(outputFile.getPath(), true);
            OfflineImageViewer oiv = new OfflineImageViewer(testFile.getPath(), (ImageVisitor)v, false);
            try {
                oiv.go();
                TestOfflineImageViewer.fail((String)"Managed to process a truncated fsimage file");
            }
            catch (EOFException e) {
                System.out.println("Correctly handled EOF");
            }
        }
        catch (IOException e) {
            TestOfflineImageViewer.fail((String)("Failed testing truncatedFSImage: " + e.getMessage()));
        }
        finally {
            if (testFile.exists()) {
                testFile.delete();
            }
            if (outputFile.exists()) {
                outputFile.delete();
            }
        }
    }

    private void compareNamespaces(HashMap<String, FileStatus> written, HashMap<String, LsElements> fileOutput) {
        TestOfflineImageViewer.assertEquals((String)"Should be the same number of files in both, plus one for root in fileoutput", (int)fileOutput.keySet().size(), (int)(written.keySet().size() + 1));
        Set<String> inFile = fileOutput.keySet();
        for (String path : inFile) {
            if (path.equals("/")) continue;
            TestOfflineImageViewer.assertTrue((String)("Path in file (" + path + ") was written to fs"), (boolean)written.containsKey(path));
            this.compareFiles(written.get(path), fileOutput.get(path));
            written.remove(path);
        }
        TestOfflineImageViewer.assertEquals((String)"No more files were written to fs", (int)0, (int)written.size());
    }

    private void compareFiles(FileStatus fs, LsElements elements) {
        TestOfflineImageViewer.assertEquals((String)"directory listed as such", (char)(fs.isDir() ? (char)'d' : '-'), (char)elements.dir);
        TestOfflineImageViewer.assertEquals((String)"perms string equal", (String)fs.getPermission().toString(), (String)elements.perms);
        TestOfflineImageViewer.assertEquals((String)"replication equal", (int)fs.getReplication(), (int)elements.replication);
        TestOfflineImageViewer.assertEquals((String)"owner equal", (String)fs.getOwner(), (String)elements.username);
        TestOfflineImageViewer.assertEquals((String)"group equal", (String)fs.getGroup(), (String)elements.groupname);
        TestOfflineImageViewer.assertEquals((String)"lengths equal", (long)fs.getLen(), (long)elements.filesize);
    }

    private HashMap<String, LsElements> readLsfile(File lsFile) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(lsFile));
        String line = null;
        HashMap<String, LsElements> fileContents = new HashMap<String, LsElements>();
        while ((line = br.readLine()) != null) {
            this.readLsLine(line, fileContents);
        }
        return fileContents;
    }

    private void readLsLine(String line, HashMap<String, LsElements> fileContents) {
        String[] elements = line.split("\\s+");
        TestOfflineImageViewer.assertEquals((String)"Not enough elements in ls output", (int)8, (int)elements.length);
        LsElements lsLine = new LsElements();
        lsLine.dir = elements[0].charAt(0);
        lsLine.perms = elements[0].substring(1);
        lsLine.replication = elements[1].equals("-") ? 0 : Integer.valueOf(elements[1]);
        lsLine.username = elements[2];
        lsLine.groupname = elements[3];
        lsLine.filesize = Long.valueOf(elements[4]);
        String path = elements[7];
        TestOfflineImageViewer.assertFalse((String)"LS file had duplicate file entries", (boolean)fileContents.containsKey(path));
        fileContents.put(path, lsLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeLayoutVersion(File src, File dest, int newVersion) throws IOException {
        FilterInputStream in = null;
        FilterOutputStream out = null;
        try {
            in = new DataInputStream(new FileInputStream(src));
            out = new DataOutputStream(new FileOutputStream(dest));
            ((DataInputStream)in).readInt();
            ((DataOutputStream)out).writeInt(newVersion);
            byte[] b = new byte[1024];
            while (((DataInputStream)in).read(b) > 0) {
                out.write(b);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPartOfFile(File src, File dest) throws IOException {
        FileInputStream in = null;
        OutputStream out = null;
        byte[] b = new byte[256];
        int maxBytes = 700;
        try {
            int count;
            in = new FileInputStream(src);
            out = new FileOutputStream(dest);
            for (int bytesWritten = 0; (count = ((InputStream)in).read(b)) > 0 && bytesWritten < maxBytes; bytesWritten += count) {
                out.write(b);
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File src, File dest) throws IOException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(src);
            out = new FileOutputStream(dest);
            byte[] b = new byte[1024];
            while (((InputStream)in).read(b) > 0) {
                out.write(b);
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputOfFileDistributionVisitor(File originalFsimage) {
        File testFile = new File(ROOT, "/basicCheck");
        File outputFile = new File(ROOT, "/fileDistributionCheckOutput");
        int totalFiles = 0;
        try {
            this.copyFile(originalFsimage, testFile);
            FileDistributionVisitor v = new FileDistributionVisitor(outputFile.getPath(), 0L, 0);
            OfflineImageViewer oiv = new OfflineImageViewer(testFile.getPath(), (ImageVisitor)v, false);
            oiv.go();
            BufferedReader reader = new BufferedReader(new FileReader(outputFile));
            String line = reader.readLine();
            TestOfflineImageViewer.assertEquals((String)line, (String)"Size\tNumFiles");
            while ((line = reader.readLine()) != null) {
                String[] row = line.split("\t");
                TestOfflineImageViewer.assertEquals((int)row.length, (int)2);
                totalFiles += Integer.parseInt(row[1]);
            }
        }
        catch (IOException e) {
            TestOfflineImageViewer.fail((String)("Failed reading valid file: " + e.getMessage()));
        }
        finally {
            if (testFile.exists()) {
                testFile.delete();
            }
            if (outputFile.exists()) {
                outputFile.delete();
            }
        }
        TestOfflineImageViewer.assertEquals((int)totalFiles, (int)12);
    }

    private class LsElements {
        public String perms;
        public int replication;
        public String username;
        public String groupname;
        public long filesize;
        public char dir;

        private LsElements() {
        }
    }
}

