/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockAlreadyExistsException;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetInterface;
import org.apache.hadoop.hdfs.server.datanode.metrics.FSDatasetMBean;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryInfo;
import org.apache.hadoop.metrics.util.MBeanUtil;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.DiskChecker;

public class SimulatedFSDataset
implements FSConstants,
FSDatasetInterface,
Configurable {
    public static final String CONFIG_PROPERTY_SIMULATED = "dfs.datanode.simulateddatastorage";
    public static final String CONFIG_PROPERTY_CAPACITY = "dfs.datanode.simulateddatastorage.capacity";
    public static final long DEFAULT_CAPACITY = 0x20000000000L;
    public static final byte DEFAULT_DATABYTE = 9;
    byte simulatedDataByte = (byte)9;
    Configuration conf = null;
    static byte[] nullCrcFileData;
    private HashMap<Block, BInfo> blockMap;
    private SimulatedStorage storage;
    private String storageId;
    private ObjectName mbeanName;

    public SimulatedFSDataset(Configuration conf) throws IOException {
        DataChecksum checksum = DataChecksum.newDataChecksum((int)0, (int)16384);
        byte[] nullCrcHeader = checksum.getHeader();
        nullCrcFileData = new byte[2 + nullCrcHeader.length];
        SimulatedFSDataset.nullCrcFileData[0] = 0;
        SimulatedFSDataset.nullCrcFileData[1] = 1;
        for (int i = 0; i < nullCrcHeader.length; ++i) {
            SimulatedFSDataset.nullCrcFileData[i + 2] = nullCrcHeader[i];
        }
        this.blockMap = null;
        this.storage = null;
        this.setConf(conf);
    }

    private SimulatedFSDataset() {
        DataChecksum checksum = DataChecksum.newDataChecksum((int)0, (int)16384);
        byte[] nullCrcHeader = checksum.getHeader();
        nullCrcFileData = new byte[2 + nullCrcHeader.length];
        SimulatedFSDataset.nullCrcFileData[0] = 0;
        SimulatedFSDataset.nullCrcFileData[1] = 1;
        for (int i = 0; i < nullCrcHeader.length; ++i) {
            SimulatedFSDataset.nullCrcFileData[i + 2] = nullCrcHeader[i];
        }
        this.blockMap = null;
        this.storage = null;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration iconf) {
        this.conf = iconf;
        this.storageId = this.conf.get("StorageId", "unknownStorageId" + new Random().nextInt());
        this.registerMBean(this.storageId);
        this.storage = new SimulatedStorage(this.conf.getLong(CONFIG_PROPERTY_CAPACITY, 0x20000000000L));
        this.blockMap = new HashMap();
    }

    public synchronized void injectBlocks(Block[] injectBlocks) throws IOException {
        if (injectBlocks != null) {
            for (Block b : injectBlocks) {
                if (b == null) {
                    throw new NullPointerException("Null blocks in block list");
                }
                if (!this.isValidBlock(b)) continue;
                throw new IOException("Block already exists in  block list");
            }
            HashMap<Block, BInfo> oldBlockMap = this.blockMap;
            this.blockMap = new HashMap(injectBlocks.length + oldBlockMap.size());
            this.blockMap.putAll(oldBlockMap);
            for (Block b : injectBlocks) {
                BInfo binfo = new BInfo(b, false);
                this.blockMap.put(b, binfo);
            }
        }
    }

    public void finalizeBlock(Block b) throws IOException {
        this.finalizeBlockInternal(b, false);
    }

    public void finalizeBlockIfNeeded(Block b) throws IOException {
        this.finalizeBlockInternal(b, true);
    }

    private synchronized void finalizeBlockInternal(Block b, boolean refinalizeOk) throws IOException {
        BInfo binfo = this.blockMap.get(b);
        if (binfo == null) {
            throw new IOException("Finalizing a non existing block " + b);
        }
        binfo.finalizeBlock(b.getNumBytes());
    }

    public synchronized void unfinalizeBlock(Block b) throws IOException {
        if (this.isBeingWritten(b)) {
            this.blockMap.remove(b);
        }
    }

    public synchronized Block[] getBlockReport() {
        Block[] blockTable = new Block[this.blockMap.size()];
        int count = 0;
        for (BInfo b : this.blockMap.values()) {
            if (!b.isFinalized()) continue;
            blockTable[count++] = b.theBlock;
        }
        if (count != blockTable.length) {
            blockTable = Arrays.copyOf(blockTable, count);
        }
        return blockTable;
    }

    public long getCapacity() throws IOException {
        return this.storage.getCapacity();
    }

    public long getDfsUsed() throws IOException {
        return this.storage.getUsed();
    }

    public long getRemaining() throws IOException {
        return this.storage.getFree();
    }

    public synchronized long getLength(Block b) throws IOException {
        BInfo binfo = this.blockMap.get(b);
        if (binfo == null) {
            throw new IOException("Finalizing a non existing block " + b);
        }
        return binfo.getlength();
    }

    public long getVisibleLength(Block b) throws IOException {
        return this.getLength(b);
    }

    public void setVisibleLength(Block b, long length) throws IOException {
    }

    public Block getStoredBlock(long blkid) throws IOException {
        Block b = new Block(blkid);
        BInfo binfo = this.blockMap.get(b);
        if (binfo == null) {
            return null;
        }
        b.setGenerationStamp(binfo.getGenerationStamp());
        b.setNumBytes(binfo.getlength());
        return b;
    }

    public void updateBlock(Block oldblock, Block newblock) throws IOException {
        BInfo binfo = this.blockMap.get(newblock);
        if (binfo == null) {
            throw new IOException("BInfo not found, b=" + newblock);
        }
        binfo.updateBlock(newblock);
    }

    public synchronized void invalidate(Block[] invalidBlks) throws IOException {
        boolean error = false;
        if (invalidBlks == null) {
            return;
        }
        for (Block b : invalidBlks) {
            if (b == null) continue;
            BInfo binfo = this.blockMap.get(b);
            if (binfo == null) {
                error = true;
                DataNode.LOG.warn((Object)"Invalidate: Missing block");
                continue;
            }
            this.storage.free(binfo.getlength());
            this.blockMap.remove(b);
        }
        if (error) {
            throw new IOException("Invalidate: Missing blocks.");
        }
    }

    public synchronized boolean isValidBlock(Block b) {
        BInfo binfo = this.blockMap.get(b);
        if (binfo == null) {
            return false;
        }
        return binfo.isFinalized();
    }

    private synchronized boolean isBeingWritten(Block b) {
        BInfo binfo = this.blockMap.get(b);
        if (binfo == null) {
            return false;
        }
        return !binfo.isFinalized();
    }

    public String toString() {
        return this.getStorageInfo();
    }

    public synchronized FSDatasetInterface.BlockWriteStreams writeToBlock(Block b, boolean isRecovery, boolean isReplicationRequest) throws IOException {
        if (this.isValidBlock(b)) {
            throw new BlockAlreadyExistsException("Block " + b + " is valid, and cannot be written to.");
        }
        if (this.isBeingWritten(b)) {
            throw new BlockAlreadyExistsException("Block " + b + " is being written, and cannot be written to.");
        }
        BInfo binfo = new BInfo(b, true);
        this.blockMap.put(b, binfo);
        SimulatedOutputStream crcStream = new SimulatedOutputStream();
        return new FSDatasetInterface.BlockWriteStreams((OutputStream)binfo.oStream, (OutputStream)crcStream);
    }

    public synchronized InputStream getBlockInputStream(Block b) throws IOException {
        BInfo binfo = this.blockMap.get(b);
        if (binfo == null) {
            throw new IOException("No such Block " + b);
        }
        return binfo.getIStream();
    }

    public synchronized InputStream getBlockInputStream(Block b, long seekOffset) throws IOException {
        InputStream result = this.getBlockInputStream(b);
        result.skip(seekOffset);
        return result;
    }

    public FSDatasetInterface.BlockInputStreams getTmpInputStreams(Block b, long blkoff, long ckoff) throws IOException {
        throw new IOException("Not supported");
    }

    public void validateBlockMetadata(Block b) {
    }

    private synchronized InputStream getMetaDataInStream(Block b) throws IOException {
        BInfo binfo = this.blockMap.get(b);
        if (binfo == null) {
            throw new IOException("No such Block " + b);
        }
        if (!binfo.finalized) {
            throw new IOException("Block " + b + " is being written, its meta cannot be read");
        }
        return binfo.getMetaIStream();
    }

    public synchronized long getMetaDataLength(Block b) throws IOException {
        BInfo binfo = this.blockMap.get(b);
        if (binfo == null) {
            throw new IOException("No such Block " + b);
        }
        if (!binfo.finalized) {
            throw new IOException("Block " + b + " is being written, its metalength cannot be read");
        }
        return binfo.getMetaIStream().getLength();
    }

    public FSDatasetInterface.MetaDataInputStream getMetaDataInputStream(Block b) throws IOException {
        return new FSDatasetInterface.MetaDataInputStream(this.getMetaDataInStream(b), this.getMetaDataLength(b));
    }

    public synchronized boolean metaFileExists(Block b) throws IOException {
        if (!this.isValidBlock(b)) {
            throw new IOException("Block " + b + " is valid, and cannot be written to.");
        }
        return true;
    }

    public void checkDataDir() throws DiskChecker.DiskErrorException {
    }

    public synchronized long getChannelPosition(Block b, FSDatasetInterface.BlockWriteStreams stream) throws IOException {
        BInfo binfo = this.blockMap.get(b);
        if (binfo == null) {
            throw new IOException("No such Block " + b);
        }
        return binfo.getlength();
    }

    public synchronized void setChannelPosition(Block b, FSDatasetInterface.BlockWriteStreams stream, long dataOffset, long ckOffset) throws IOException {
        BInfo binfo = this.blockMap.get(b);
        if (binfo == null) {
            throw new IOException("No such Block " + b);
        }
        binfo.setlength(dataOffset);
    }

    void registerMBean(String storageId) {
        try {
            StandardMBean bean = new StandardMBean(this, FSDatasetMBean.class);
            this.mbeanName = MBeanUtil.registerMBean((String)"DataNode", (String)("FSDatasetState-" + storageId), (Object)bean);
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
        }
        DataNode.LOG.info((Object)"Registered FSDatasetStatusMBean");
    }

    public void shutdown() {
        if (this.mbeanName != null) {
            MBeanUtil.unregisterMBean((ObjectName)this.mbeanName);
        }
    }

    public String getStorageInfo() {
        return "Simulated FSDataset-" + this.storageId;
    }

    public boolean hasEnoughResources() {
        return true;
    }

    public BlockRecoveryInfo startBlockRecovery(long blockId) throws IOException {
        Block stored = this.getStoredBlock(blockId);
        return new BlockRecoveryInfo(stored, false);
    }

    private static class SimulatedOutputStream
    extends OutputStream {
        long length = 0L;

        SimulatedOutputStream() {
        }

        long getLength() {
            return this.length;
        }

        void setLength(long length) {
            this.length = length;
        }

        @Override
        public void write(int arg0) throws IOException {
            ++this.length;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.length += (long)b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.length += (long)len;
        }
    }

    private static class SimulatedInputStream
    extends InputStream {
        byte theRepeatedData = (byte)7;
        long length;
        int currentPos = 0;
        byte[] data = null;

        SimulatedInputStream(long l, byte iRepeatedData) {
            this.length = l;
            this.theRepeatedData = iRepeatedData;
        }

        SimulatedInputStream(byte[] iData) {
            this.data = iData;
            this.length = this.data.length;
        }

        long getLength() {
            return this.length;
        }

        @Override
        public int read() throws IOException {
            if ((long)this.currentPos >= this.length) {
                return -1;
            }
            if (this.data != null) {
                return this.data[this.currentPos++];
            }
            ++this.currentPos;
            return this.theRepeatedData;
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (b.length == 0) {
                return 0;
            }
            if ((long)this.currentPos >= this.length) {
                return -1;
            }
            int bytesRead = (int)Math.min((long)b.length, this.length - (long)this.currentPos);
            if (this.data != null) {
                System.arraycopy(this.data, this.currentPos, b, 0, bytesRead);
            } else {
                for (byte i : b) {
                    b[i] = this.theRepeatedData;
                }
            }
            this.currentPos += bytesRead;
            return bytesRead;
        }
    }

    private static class SimulatedStorage {
        private long capacity;
        private long used;

        synchronized long getFree() {
            return this.capacity - this.used;
        }

        synchronized long getCapacity() {
            return this.capacity;
        }

        synchronized long getUsed() {
            return this.used;
        }

        synchronized boolean alloc(long amount) {
            if (this.getFree() >= amount) {
                this.used += amount;
                return true;
            }
            return false;
        }

        synchronized void free(long amount) {
            this.used -= amount;
        }

        SimulatedStorage(long cap) {
            this.capacity = cap;
            this.used = 0L;
        }
    }

    private class BInfo {
        Block theBlock;
        private boolean finalized = false;
        SimulatedOutputStream oStream = null;

        BInfo(Block b, boolean forWriting) throws IOException {
            this.theBlock = new Block(b);
            if (this.theBlock.getNumBytes() < 0L) {
                this.theBlock.setNumBytes(0L);
            }
            if (!SimulatedFSDataset.this.storage.alloc(this.theBlock.getNumBytes())) {
                DataNode.LOG.warn((Object)"Lack of free storage on a block alloc");
                throw new IOException("Creating block, no free space available");
            }
            if (forWriting) {
                this.finalized = false;
                this.oStream = new SimulatedOutputStream();
            } else {
                this.finalized = true;
                this.oStream = null;
            }
        }

        synchronized long getGenerationStamp() {
            return this.theBlock.getGenerationStamp();
        }

        synchronized void updateBlock(Block b) {
            this.theBlock.setGenerationStamp(b.getGenerationStamp());
            this.setlength(b.getNumBytes());
        }

        synchronized long getlength() {
            if (!this.finalized) {
                return this.oStream.getLength();
            }
            return this.theBlock.getNumBytes();
        }

        synchronized void setlength(long length) {
            if (!this.finalized) {
                this.oStream.setLength(length);
            } else {
                this.theBlock.setNumBytes(length);
            }
        }

        synchronized SimulatedInputStream getIStream() throws IOException {
            if (!this.finalized) {
                return new SimulatedInputStream(this.oStream.getLength(), 9);
            }
            return new SimulatedInputStream(this.theBlock.getNumBytes(), 9);
        }

        synchronized void finalizeBlock(long finalSize) throws IOException {
            if (this.finalized) {
                throw new IOException("Finalizing a block that has already been finalized" + this.theBlock.getBlockId());
            }
            if (this.oStream == null) {
                DataNode.LOG.error((Object)"Null oStream on unfinalized block - bug");
                throw new IOException("Unexpected error on finalize");
            }
            if (this.oStream.getLength() != finalSize) {
                DataNode.LOG.warn((Object)("Size passed to finalize (" + finalSize + ")does not match what was written:" + this.oStream.getLength()));
                throw new IOException("Size passed to finalize does not match the amount of data written");
            }
            long extraLen = finalSize - this.theBlock.getNumBytes();
            if (extraLen > 0L) {
                if (!SimulatedFSDataset.this.storage.alloc(extraLen)) {
                    DataNode.LOG.warn((Object)"Lack of free storage on a block alloc");
                    throw new IOException("Creating block, no free space available");
                }
            } else {
                SimulatedFSDataset.this.storage.free(-extraLen);
            }
            this.theBlock.setNumBytes(finalSize);
            this.finalized = true;
            this.oStream = null;
        }

        SimulatedInputStream getMetaIStream() {
            return new SimulatedInputStream(nullCrcFileData);
        }

        synchronized boolean isFinalized() {
            return this.finalized;
        }
    }
}

