/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;

public abstract class HadoopTestCase
extends TestCase {
    public static final int LOCAL_MR = 1;
    public static final int CLUSTER_MR = 2;
    public static final int LOCAL_FS = 4;
    public static final int DFS_FS = 8;
    private boolean localMR;
    private boolean localFS;
    private int taskTrackers;
    private int dataNodes;
    private MiniDFSCluster dfsCluster = null;
    private MiniMRCluster mrCluster = null;
    private FileSystem fileSystem = null;

    public HadoopTestCase(int mrMode, int fsMode, int taskTrackers, int dataNodes) throws IOException {
        if (mrMode != 1 && mrMode != 2) {
            throw new IllegalArgumentException("Invalid MapRed mode, must be LOCAL_MR or CLUSTER_MR");
        }
        if (fsMode != 4 && fsMode != 8) {
            throw new IllegalArgumentException("Invalid FileSystem mode, must be LOCAL_FS or DFS_FS");
        }
        if (taskTrackers < 1) {
            throw new IllegalArgumentException("Invalid taskTrackers value, must be greater than 0");
        }
        if (dataNodes < 1) {
            throw new IllegalArgumentException("Invalid dataNodes value, must be greater than 0");
        }
        this.localMR = mrMode == 1;
        this.localFS = fsMode == 4;
        this.taskTrackers = taskTrackers;
        this.dataNodes = dataNodes;
    }

    public boolean isLocalMR() {
        return this.localMR;
    }

    public boolean isLocalFS() {
        return this.localFS;
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.localFS) {
            this.fileSystem = FileSystem.getLocal((Configuration)new JobConf());
        } else {
            this.dfsCluster = new MiniDFSCluster((Configuration)new JobConf(), this.dataNodes, true, null);
            this.fileSystem = this.dfsCluster.getFileSystem();
        }
        if (!this.localMR) {
            this.mrCluster = new MiniMRCluster(this.taskTrackers, this.fileSystem.getName(), 1);
        }
    }

    protected void tearDown() throws Exception {
        try {
            if (this.mrCluster != null) {
                this.mrCluster.shutdown();
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        try {
            if (this.dfsCluster != null) {
                this.dfsCluster.shutdown();
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        super.tearDown();
    }

    protected FileSystem getFileSystem() {
        return this.fileSystem;
    }

    protected JobConf createJobConf() {
        return this.localMR ? new JobConf() : this.mrCluster.createJobConf();
    }
}

