/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;

public class TestClientBlockVerification {
    static MiniDFSCluster cluster = null;
    static Configuration conf = null;
    static FileSystem fs = null;
    static final Path TEST_FILE = new Path("/test.file");
    static final int FILE_SIZE_K = 256;
    static LocatedBlock testBlock = null;

    @BeforeClass
    public static void setupCluster() throws Exception {
        conf = new Configuration();
        int numDataNodes = 1;
        conf.setInt("dfs.replication", numDataNodes);
        cluster = new MiniDFSCluster(conf, numDataNodes, true, null);
        cluster.waitActive();
        fs = cluster.getFileSystem();
        FSDataOutputStream os = fs.create(TEST_FILE);
        byte[] data = new byte[1024];
        new Random().nextBytes(data);
        for (int i = 0; i < 256; ++i) {
            os.write(data);
        }
        os.close();
        DFSClient dfsclient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), conf);
        List locatedBlocks = dfsclient.namenode.getBlockLocations(TEST_FILE.toString(), 0L, 262144L).getLocatedBlocks();
        testBlock = (LocatedBlock)locatedBlocks.get(0);
    }

    private DFSClient.BlockReader getBlockReader(int offset, int lenToRead) throws IOException {
        InetSocketAddress targetAddr = null;
        Socket s = null;
        Object blockReader = null;
        Block block = testBlock.getBlock();
        DatanodeInfo[] nodes = testBlock.getLocations();
        targetAddr = NetUtils.createSocketAddr((String)nodes[0].getName());
        s = new Socket();
        s.connect(targetAddr, 60000);
        s.setSoTimeout(60000);
        return DFSClient.BlockReader.newBlockReader((Socket)s, (String)(targetAddr.toString() + ":" + block.getBlockId()), (long)block.getBlockId(), (Token)testBlock.getBlockToken(), (long)block.getGenerationStamp(), (long)offset, (long)lenToRead, (int)conf.getInt("io.file.buffer.size", 4096));
    }

    @Test
    public void testBlockVerification() throws Exception {
        DFSClient.BlockReader reader = (DFSClient.BlockReader)Mockito.spy((Object)this.getBlockReader(0, 262144));
        this.slurpReader(reader, 262144, true);
        ((DFSClient.BlockReader)Mockito.verify((Object)reader)).checksumOk(reader.dnSock);
        reader.close();
    }

    @Test
    public void testIncompleteRead() throws Exception {
        DFSClient.BlockReader reader = (DFSClient.BlockReader)Mockito.spy((Object)this.getBlockReader(0, 262144));
        this.slurpReader(reader, 131072, false);
        ((DFSClient.BlockReader)Mockito.verify((Object)reader, (VerificationMode)Mockito.never())).checksumOk(reader.dnSock);
        reader.close();
    }

    @Test
    public void testCompletePartialRead() throws Exception {
        DFSClient.BlockReader reader = (DFSClient.BlockReader)Mockito.spy((Object)this.getBlockReader(0, 131072));
        this.slurpReader(reader, 131072, true);
        ((DFSClient.BlockReader)Mockito.verify((Object)reader)).checksumOk(reader.dnSock);
        reader.close();
    }

    @Test
    public void testUnalignedReads() throws Exception {
        int[] startOffsets = new int[]{0, 3, 129};
        int[] lengths = new int[]{30, 300, 512, 513, 1025};
        for (int startOffset : startOffsets) {
            for (int length : lengths) {
                DFSClient.LOG.info((Object)("Testing startOffset = " + startOffset + " and " + " len=" + length));
                DFSClient.BlockReader reader = (DFSClient.BlockReader)Mockito.spy((Object)this.getBlockReader(startOffset, length));
                this.slurpReader(reader, length, true);
                ((DFSClient.BlockReader)Mockito.verify((Object)reader)).checksumOk(reader.dnSock);
                reader.close();
            }
        }
    }

    private void slurpReader(DFSClient.BlockReader reader, int length, boolean expectEof) throws IOException {
        block4: {
            int n;
            byte[] buf = new byte[1024];
            for (int nRead = 0; nRead < length; nRead += n) {
                DFSClient.LOG.info((Object)("So far read " + nRead + " - going to read more."));
                n = reader.read(buf, 0, buf.length);
                Assert.assertTrue((n > 0 ? 1 : 0) != 0);
            }
            DFSClient.LOG.info((Object)"Done reading, expect EOF for next read.");
            if (expectEof) {
                try {
                    Assert.assertEquals((long)-1L, (long)reader.read(buf, 0, buf.length));
                }
                catch (IOException ioe) {
                    if ("BlockRead: already got EOS or an error".equals(ioe.getMessage())) break block4;
                    throw ioe;
                }
            }
        }
    }

    @AfterClass
    public static void teardownCluster() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }
}

