/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.tools.DelegationTokenFetcher;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestDelegationTokenFetcher {
    private DistributedFileSystem dfs;
    private DataOutputStream out;
    private UserGroupInformation ugi;
    private Configuration conf;

    @Before
    public void init() {
        this.dfs = (DistributedFileSystem)Mockito.mock(DistributedFileSystem.class);
        this.out = (DataOutputStream)Mockito.mock(DataOutputStream.class);
        this.ugi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        this.conf = new Configuration();
    }

    @Test
    public void expectedTokenIsRetrievedFromDFS() throws Exception {
        String LONG_NAME = "TheDoctor@TARDIS";
        String SHORT_NAME = "TheDoctor";
        String SERVICE_VALUE = "localhost:2005";
        URI uri = new URI("hdfs://localhost:2005");
        FileSystem.setDefaultUri((Configuration)this.conf, (URI)uri);
        Mockito.when((Object)this.ugi.getUserName()).thenReturn((Object)"TheDoctor@TARDIS");
        Mockito.when((Object)this.ugi.getShortUserName()).thenReturn((Object)"TheDoctor");
        Token t = new Token();
        Mockito.when((Object)this.dfs.getDelegationToken((Text)Matchers.eq((Object)new Text("TheDoctor@TARDIS")))).thenReturn((Object)t);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.out = new DataOutputStream(baos);
        new DelegationTokenFetcher(this.dfs, this.out, this.ugi, this.conf).go();
        Credentials ts = new Credentials();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(baos.toByteArray()));
        ts.readTokenStorageStream(dis);
        Token newToken = ts.getToken(new Text("TheDoctor"));
        Assert.assertEquals((String)"Should only be one token in storage", (long)ts.numberOfTokens(), (long)1L);
        Assert.assertEquals((String)"Service value should have survived", (Object)"127.0.0.1:2005", (Object)newToken.getService().toString());
    }

    private void checkWithNullParam(String s) {
        try {
            new DelegationTokenFetcher(this.dfs, this.out, this.ugi, this.conf);
        }
        catch (IllegalArgumentException iae) {
            Assert.assertEquals((String)"Expected exception message not received", (Object)(s + " cannot be null."), (Object)iae.getMessage());
            return;
        }
        Assert.fail((String)"null parameter should have failed.");
    }

    @Test
    public void dfsCannotBeNull() {
        this.dfs = null;
        String s = "dfs";
        this.checkWithNullParam(s);
    }

    @Test
    public void dosCannotBeNull() {
        this.out = null;
        String s = "out";
        this.checkWithNullParam(s);
    }

    @Test
    public void ugiCannotBeNull() {
        this.ugi = null;
        String s = "ugi";
        this.checkWithNullParam(s);
    }
}

