/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.io.retry.UnreliableImplementation;
import org.apache.hadoop.io.retry.UnreliableInterface;
import org.apache.hadoop.ipc.RemoteException;

public class TestRetryProxy
extends TestCase {
    private UnreliableImplementation unreliableImpl;

    protected void setUp() throws Exception {
        this.unreliableImpl = new UnreliableImplementation();
    }

    public void testTryOnceThenFail() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL);
        unreliable.alwaysSucceeds();
        try {
            unreliable.failsOnceThenSucceeds();
            TestRetryProxy.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    public void testTryOnceDontFail() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.TRY_ONCE_DONT_FAIL);
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.failsOnceThenSucceedsWithReturnValue();
            TestRetryProxy.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    public void testRetryForever() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.RETRY_FOREVER);
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        unreliable.failsTenTimesThenSucceeds();
    }

    public void testRetryUpToMaximumCountWithFixedSleep() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)8, (long)1L, (TimeUnit)TimeUnit.NANOSECONDS));
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.failsTenTimesThenSucceeds();
            TestRetryProxy.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    public void testRetryUpToMaximumTimeWithFixedSleep() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.retryUpToMaximumTimeWithFixedSleep((long)80L, (long)10L, (TimeUnit)TimeUnit.NANOSECONDS));
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.failsTenTimesThenSucceeds();
            TestRetryProxy.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    public void testRetryUpToMaximumCountWithProportionalSleep() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.retryUpToMaximumCountWithProportionalSleep((int)8, (long)1L, (TimeUnit)TimeUnit.NANOSECONDS));
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.failsTenTimesThenSucceeds();
            TestRetryProxy.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    public void testExponentialRetry() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.exponentialBackoffRetry((int)5, (long)1L, (TimeUnit)TimeUnit.NANOSECONDS));
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.failsTenTimesThenSucceeds();
            TestRetryProxy.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    public void testRetryByException() throws UnreliableInterface.UnreliableException {
        Map<Class<UnreliableInterface.FatalException>, RetryPolicy> exceptionToPolicyMap = Collections.singletonMap(UnreliableInterface.FatalException.class, RetryPolicies.TRY_ONCE_THEN_FAIL);
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.retryByException((RetryPolicy)RetryPolicies.RETRY_FOREVER, exceptionToPolicyMap));
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.alwaysFailsWithFatalException();
            TestRetryProxy.fail((String)"Should fail");
        }
        catch (UnreliableInterface.FatalException fatalException) {
            // empty catch block
        }
    }

    public void testRetryByRemoteException() throws UnreliableInterface.UnreliableException {
        Map<Class<UnreliableInterface.FatalException>, RetryPolicy> exceptionToPolicyMap = Collections.singletonMap(UnreliableInterface.FatalException.class, RetryPolicies.TRY_ONCE_THEN_FAIL);
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.retryByRemoteException((RetryPolicy)RetryPolicies.RETRY_FOREVER, exceptionToPolicyMap));
        try {
            unreliable.alwaysFailsWithRemoteFatalException();
            TestRetryProxy.fail((String)"Should fail");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

