/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.FakeCompressor;
import org.apache.hadoop.io.compress.FakeDecompressor;
import org.junit.Assert;
import org.junit.Test;

public class TestBlockDecompressorStream {
    private byte[] buf;
    private ByteArrayInputStream bytesIn;
    private ByteArrayOutputStream bytesOut;

    @Test
    public void testRead() throws IOException {
        this.bytesOut = new ByteArrayOutputStream();
        BlockCompressorStream blockCompressorStream = new BlockCompressorStream((OutputStream)this.bytesOut, (Compressor)new FakeCompressor(), 1024, 0);
        blockCompressorStream.close();
        this.buf = this.bytesOut.toByteArray();
        Assert.assertEquals((String)"empty file compressed output size is not 4", (long)4L, (long)this.buf.length);
        this.bytesIn = new ByteArrayInputStream(this.buf);
        BlockDecompressorStream blockDecompressorStream = new BlockDecompressorStream((InputStream)this.bytesIn, (Decompressor)new FakeDecompressor(), 1024);
        try {
            Assert.assertEquals((String)"return value is not -1", (long)-1L, (long)blockDecompressorStream.read());
        }
        catch (IOException e) {
            Assert.fail((String)("unexpected IOException : " + e));
        }
    }
}

