/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.TableMapping;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTableMapping {
    private File mappingFile;

    @Before
    public void setUp() throws IOException {
        this.mappingFile = File.createTempFile(this.getClass().getSimpleName(), ".txt");
        this.writeFile("a.b.c /rack1\n1.2.3\t/rack2\n", this.mappingFile);
        this.mappingFile.deleteOnExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String content, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            out.write(content.getBytes("UTF-8"));
        }
        finally {
            IOUtils.closeStream((Closeable)out);
        }
    }

    @Test
    public void testResolve() throws IOException {
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        conf.set("net.topology.table.file.name", this.mappingFile.getCanonicalPath());
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("a.b.c");
        names.add("1.2.3");
        List result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals((Object)"/rack1", result.get(0));
        Assert.assertEquals((Object)"/rack2", result.get(1));
    }

    @Test
    public void testTableCaching() throws IOException {
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        conf.set("net.topology.table.file.name", this.mappingFile.getCanonicalPath());
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("a.b.c");
        names.add("1.2.3");
        List result1 = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result1.size());
        Assert.assertEquals((Object)"/rack1", result1.get(0));
        Assert.assertEquals((Object)"/rack2", result1.get(1));
        conf.set("net.topology.table.file.name", "some bad value for a file");
        List result2 = mapping.resolve(names);
        Assert.assertEquals((Object)result1, (Object)result2);
    }

    @Test
    public void testNoFile() {
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("a.b.c");
        names.add("1.2.3");
        List result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals((Object)"/default-rack", result.get(0));
        Assert.assertEquals((Object)"/default-rack", result.get(1));
    }

    @Test
    public void testFileDoesNotExist() {
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        conf.set("net.topology.table.file.name", "/this/file/does/not/exist");
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("a.b.c");
        names.add("1.2.3");
        List result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals(result.get(0), (Object)"/default-rack");
        Assert.assertEquals(result.get(1), (Object)"/default-rack");
    }

    @Test
    public void testBadFile() throws IOException {
        this.writeFile("bad contents", this.mappingFile);
        TableMapping mapping = new TableMapping();
        Configuration conf = new Configuration();
        conf.set("net.topology.table.file.name", this.mappingFile.getCanonicalPath());
        mapping.setConf(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("a.b.c");
        names.add("1.2.3");
        List result = mapping.resolve(names);
        Assert.assertEquals((long)names.size(), (long)result.size());
        Assert.assertEquals(result.get(0), (Object)"/default-rack");
        Assert.assertEquals(result.get(1), (Object)"/default-rack");
    }
}

