/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.cloudwatch;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.hadoop.metrics2.Metric;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.impl.MetricsRecordImpl;
import org.apache.hadoop.metrics2.sink.cloudwatch.CloudWatchSink;
import org.apache.hadoop.metrics2.sink.cloudwatch.ConcreteRpcClient;
import org.apache.hadoop.metrics2.sink.cloudwatch.RpcClient;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCloudWatchSink
extends TestCase {
    private HashMap<String, Number> filteredMetrics;
    private Gson gson;
    private ConcreteRpcClient client;
    private Type mapType;
    private CloudWatchSink cloudWatchSink;

    protected void setUp() throws Exception {
        this.gson = new Gson();
        this.client = new ConcreteRpcClient(RpcClient.newDefaultConfiguration());
        this.filteredMetrics = new HashMap();
        this.mapType = new TypeToken<Map<String, Number>>(){}.getType();
        this.cloudWatchSink = new CloudWatchSink();
        SubsetConfiguration conf = null;
        this.cloudWatchSink.init(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransferMetricsWithExpectedInput() {
        this.filteredMetrics.put("dfs.namenode.numBlocksCorrupted", 0);
        this.filteredMetrics.put("dfs.FSNameSystem.totalLoad", 10);
        this.filteredMetrics.put("dfs.FSNameSystem.underReplicatedBlocks", 0);
        String jsonString = this.gson.toJson(this.filteredMetrics, this.mapType);
        try {
            this.client.transferMetrics(jsonString);
        }
        catch (Exception exception) {
        }
        finally {
            Assert.assertEquals((String)jsonString, (String)this.client.client.stringRequestEntity.getContent());
        }
    }

    @Test
    public void testEmptyDefaultMetricsList() throws Exception {
        Assert.assertEquals((boolean)false, (boolean)this.cloudWatchSink.getDefaultMetricsVector().contains("Test String"));
    }

    @Test
    public void testGson() {
        this.filteredMetrics.put("dfs.namenode.numBlocksCorrupted", 0);
        this.filteredMetrics.put("dfs.FSNameSystem.totalLoad", 10);
        this.filteredMetrics.put("dfs.FSNameSystem.underReplicatedBlocks", 0);
        String jsonString = this.gson.toJson(this.filteredMetrics, this.mapType);
        HashMap retrievedMap = (HashMap)this.gson.fromJson(jsonString, this.mapType);
        Assert.assertEquals((String)this.filteredMetrics.toString(), (String)retrievedMap.toString());
    }

    @Test
    public void testPutMetrics() throws IOException {
        MetricsRecordImpl mockMetricsRecord = (MetricsRecordImpl)Mockito.mock(MetricsRecordImpl.class);
        Metric metric1 = (Metric)Mockito.mock(Metric.class);
        Metric metric2 = (Metric)Mockito.mock(Metric.class);
        Mockito.when((Object)metric1.name()).thenReturn((Object)"TestMetric1");
        Mockito.when((Object)metric1.value()).thenReturn((Object)1);
        Mockito.when((Object)metric2.name()).thenReturn((Object)"TestMetric2");
        Mockito.when((Object)metric2.value()).thenReturn((Object)100);
        ArrayList<Metric> metricList = new ArrayList<Metric>();
        metricList.add(metric1);
        metricList.add(metric2);
        Mockito.when((Object)mockMetricsRecord.metrics()).thenReturn(metricList);
        Mockito.when((Object)mockMetricsRecord.context()).thenReturn((Object)"TestContext");
        Mockito.when((Object)mockMetricsRecord.name()).thenReturn((Object)"TestName");
        Vector<String> metricsVector = new Vector<String>();
        metricsVector.add("TestMetric1");
        metricsVector.add("TestMetric2");
        this.cloudWatchSink.setDefaultMetricsVector(metricsVector);
        this.cloudWatchSink.putMetrics((MetricsRecord)mockMetricsRecord);
        this.filteredMetrics.put("TestContext.TestName.TestMetric1", 1);
        this.filteredMetrics.put("TestContext.TestName.TestMetric2", 100);
        TestCloudWatchSink.assertEquals(this.filteredMetrics, (Object)this.cloudWatchSink.getFilteredMetrics());
    }

    @Test
    public void testPutMetricsWithNullMetricValue() throws IOException {
        MetricsRecordImpl mockMetricsRecord = (MetricsRecordImpl)Mockito.mock(MetricsRecordImpl.class);
        Metric metric1 = (Metric)Mockito.mock(Metric.class);
        Metric metric2 = (Metric)Mockito.mock(Metric.class);
        Mockito.when((Object)metric1.name()).thenReturn((Object)"TestMetric1");
        Mockito.when((Object)metric1.value()).thenReturn((Object)1);
        Mockito.when((Object)metric2.name()).thenReturn((Object)"TestMetric2");
        Mockito.when((Object)metric2.value()).thenReturn(null);
        ArrayList<Metric> metricList = new ArrayList<Metric>();
        metricList.add(metric1);
        metricList.add(metric2);
        Mockito.when((Object)mockMetricsRecord.metrics()).thenReturn(metricList);
        Mockito.when((Object)mockMetricsRecord.context()).thenReturn((Object)"TestContext");
        Mockito.when((Object)mockMetricsRecord.name()).thenReturn((Object)"TestName");
        Vector<String> metricsVector = new Vector<String>();
        metricsVector.add("TestMetric1");
        metricsVector.add("TestMetric2");
        this.cloudWatchSink.setDefaultMetricsVector(metricsVector);
        this.cloudWatchSink.putMetrics((MetricsRecord)mockMetricsRecord);
        this.filteredMetrics.put("TestContext.TestName.TestMetric1", 1);
        TestCloudWatchSink.assertEquals(this.filteredMetrics, (Object)this.cloudWatchSink.getFilteredMetrics());
    }
}

