/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import javax.security.auth.login.LoginException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.IsolationRunner;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.security.UserGroupInformation;

public class TestIsolationRunner
extends TestCase {
    private static final String SIDE_EFFECT_DIR_PROPERTY = "test.isolationrunner.sideeffectdir";
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');

    private static void deleteSideEffectFiles(JobConf conf) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        localFs.delete(new Path(conf.get(SIDE_EFFECT_DIR_PROPERTY)), true);
        TestIsolationRunner.assertEquals((int)0, (int)TestIsolationRunner.countSideEffectFiles(conf, ""));
    }

    private static void writeSideEffectFile(JobConf conf, String prefix) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Path sideEffectFile = new Path(conf.get(SIDE_EFFECT_DIR_PROPERTY), prefix + "-" + UUID.randomUUID().toString());
        localFs.create(sideEffectFile).close();
    }

    private static int countSideEffectFiles(JobConf conf, final String prefix) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        FileStatus[] files = localFs.listStatus(new Path(conf.get(SIDE_EFFECT_DIR_PROPERTY)), new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().startsWith(prefix + "-");
            }
        });
        return files.length;
    }

    private Path getAttemptJobXml(JobConf conf, JobID jobId, boolean isMap) throws IOException, LoginException {
        String taskid = new TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, isMap, 0), 0).toString();
        return new LocalDirAllocator("mapred.local.dir").getLocalPathToRead(TaskTracker.getTaskConfFile((String)UserGroupInformation.getCurrentUser().getUserName(), (String)jobId.toString(), (String)taskid, (boolean)false), (Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsolationRunOfMapTask() throws IOException, InterruptedException, ClassNotFoundException, LoginException {
        MiniMRCluster mr = null;
        try {
            mr = new MiniMRCluster(1, "file:///", 4);
            JobConf conf = mr.createJobConf();
            conf.setKeepTaskFilesPattern(".*");
            conf.set(SIDE_EFFECT_DIR_PROPERTY, TEST_ROOT_DIR + "/isolationrunnerjob/sideeffect");
            TestIsolationRunner.deleteSideEffectFiles(conf);
            JobID jobId = TestIsolationRunner.runJobNormally(conf);
            TestIsolationRunner.assertEquals((int)1, (int)TestIsolationRunner.countSideEffectFiles(conf, "map"));
            TestIsolationRunner.assertEquals((int)1, (int)TestIsolationRunner.countSideEffectFiles(conf, "reduce"));
            TestIsolationRunner.deleteSideEffectFiles(conf);
            LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
            Path mapJobXml = this.getAttemptJobXml(mr.getTaskTrackerRunner(0).getTaskTracker().getJobConf(), jobId, true).makeQualified((FileSystem)localFs);
            TestIsolationRunner.assertTrue((boolean)localFs.exists(mapJobXml));
            new IsolationRunner().run(new String[]{new File(mapJobXml.toUri()).getCanonicalPath()});
            TestIsolationRunner.assertEquals((int)1, (int)TestIsolationRunner.countSideEffectFiles(conf, "map"));
            TestIsolationRunner.assertEquals((int)0, (int)TestIsolationRunner.countSideEffectFiles(conf, "reduce"));
            TestIsolationRunner.deleteSideEffectFiles(conf);
        }
        finally {
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    static JobID runJobNormally(JobConf conf) throws IOException {
        Path inDir = new Path(TEST_ROOT_DIR + "/isolationrunnerjob/input");
        Path outDir = new Path(TEST_ROOT_DIR + "/isolationrunnerjob/output");
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(outDir, true);
        if (!fs.exists(inDir)) {
            fs.mkdirs(inDir);
        }
        String input = "The quick brown fox jumps over lazy dog\n";
        FSDataOutputStream file = fs.create(new Path(inDir, "file"));
        file.writeBytes(input);
        file.close();
        conf.setInputFormat(TextInputFormat.class);
        conf.setMapperClass(SideEffectMapper.class);
        conf.setReducerClass(SideEffectReducer.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setNumMapTasks(1);
        conf.setNumReduceTasks(1);
        JobClient jobClient = new JobClient(conf);
        RunningJob job = jobClient.submitJob(conf);
        job.waitForCompletion();
        return job.getID();
    }

    static class SideEffectReducer<K, V>
    extends IdentityReducer<K, V> {
        private JobConf conf;

        SideEffectReducer() {
        }

        public void configure(JobConf conf) {
            this.conf = conf;
        }

        public void close() throws IOException {
            TestIsolationRunner.writeSideEffectFile(this.conf, "reduce");
        }
    }

    static class SideEffectMapper<K, V>
    extends IdentityMapper<K, V> {
        private JobConf conf;

        SideEffectMapper() {
        }

        public void configure(JobConf conf) {
            this.conf = conf;
        }

        public void close() throws IOException {
            TestIsolationRunner.writeSideEffectFile(this.conf, "map");
        }
    }
}

