/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.TestRPC;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SaslInputStream;
import org.apache.hadoop.security.SaslRpcClient;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.TestUserGroupInformation;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenInfo;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestSaslRPC {
    private static final String ADDRESS = "0.0.0.0";
    public static final Log LOG = LogFactory.getLog(TestSaslRPC.class);
    static final String ERROR_MESSAGE = "Token is invalid";
    static final String SERVER_PRINCIPAL_KEY = "test.ipc.server.principal";
    static final String SERVER_KEYTAB_KEY = "test.ipc.server.keytab";
    static final String SERVER_PRINCIPAL_1 = "p1/foo@BAR";
    static final String SERVER_PRINCIPAL_2 = "p2/foo@BAR";
    private static Configuration conf = new Configuration();

    @Test
    public void testDigestRpc() throws Exception {
        TestTokenSecretManager sm = new TestTokenSecretManager();
        RPC.Server server = RPC.getServer((Object)new TestSaslImpl(), (String)ADDRESS, (int)0, (int)5, (boolean)true, (Configuration)conf, (SecretManager)sm);
        this.doDigestRpc((Server)server, sm);
    }

    @Test
    public void testSecureToInsecureRpc() throws Exception {
        RPC.Server server = RPC.getServer((Object)new TestSaslImpl(), (String)ADDRESS, (int)0, (int)5, (boolean)true, (Configuration)conf, null);
        server.disableSecurity();
        TestTokenSecretManager sm = new TestTokenSecretManager();
        this.doDigestRpc((Server)server, sm);
    }

    @Test
    public void testErrorMessage() throws Exception {
        BadTokenSecretManager sm = new BadTokenSecretManager();
        RPC.Server server = RPC.getServer((Object)new TestSaslImpl(), (String)ADDRESS, (int)0, (int)5, (boolean)true, (Configuration)conf, (SecretManager)sm);
        boolean succeeded = false;
        try {
            this.doDigestRpc((Server)server, sm);
        }
        catch (RemoteException e) {
            LOG.info((Object)("LOGGING MESSAGE: " + e.getLocalizedMessage()));
            Assert.assertTrue((boolean)ERROR_MESSAGE.equals(e.getLocalizedMessage()));
            Assert.assertTrue((boolean)(e.unwrapRemoteException() instanceof SecretManager.InvalidToken));
            succeeded = true;
        }
        Assert.assertTrue((boolean)succeeded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDigestRpc(Server server, TestTokenSecretManager sm) throws Exception {
        server.start();
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        TestTokenIdentifier tokenId = new TestTokenIdentifier(new Text(current.getUserName()));
        Token token = new Token((TokenIdentifier)tokenId, (SecretManager)sm);
        Text host = new Text(addr.getAddress().getHostAddress() + ":" + addr.getPort());
        token.setService(host);
        LOG.info((Object)("Service IP address for token is " + host));
        current.addToken(token);
        TestSaslProtocol proxy = null;
        try {
            proxy = (TestSaslProtocol)RPC.getProxy(TestSaslProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
            proxy.ping();
        }
        finally {
            server.stop();
            if (proxy != null) {
                RPC.stopProxy((VersionedProtocol)proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRemotePrincipal() throws Exception {
        try {
            Configuration newConf = new Configuration(conf);
            newConf.set(SERVER_PRINCIPAL_KEY, SERVER_PRINCIPAL_1);
            Client.ConnectionId remoteId = Client.ConnectionId.getConnectionId((InetSocketAddress)new InetSocketAddress(0), TestSaslProtocol.class, null, (Configuration)newConf);
            Assert.assertEquals((Object)SERVER_PRINCIPAL_1, (Object)remoteId.getServerPrincipal());
            newConf.set("hadoop.security.authentication", "simple");
            UserGroupInformation.setConfiguration((Configuration)newConf);
            remoteId = Client.ConnectionId.getConnectionId((InetSocketAddress)new InetSocketAddress(0), TestSaslProtocol.class, null, (Configuration)newConf);
            Assert.assertEquals((String)"serverPrincipal should be null when security is turned off", null, (Object)remoteId.getServerPrincipal());
        }
        finally {
            UserGroupInformation.setConfiguration((Configuration)conf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPerConnectionConf() throws Exception {
        TestTokenSecretManager sm = new TestTokenSecretManager();
        RPC.Server server = RPC.getServer((Object)new TestSaslImpl(), (String)ADDRESS, (int)0, (int)5, (boolean)true, (Configuration)conf, (SecretManager)sm);
        server.start();
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        TestTokenIdentifier tokenId = new TestTokenIdentifier(new Text(current.getUserName()));
        Token token = new Token((TokenIdentifier)tokenId, (SecretManager)sm);
        Text host = new Text(addr.getAddress().getHostAddress() + ":" + addr.getPort());
        token.setService(host);
        LOG.info((Object)("Service IP address for token is " + host));
        current.addToken(token);
        Configuration newConf = new Configuration(conf);
        newConf.set("hadoop.rpc.socket.factory.class.default", "");
        newConf.set(SERVER_PRINCIPAL_KEY, SERVER_PRINCIPAL_1);
        TestSaslProtocol proxy1 = null;
        TestSaslProtocol proxy2 = null;
        TestSaslProtocol proxy3 = null;
        try {
            proxy1 = (TestSaslProtocol)RPC.getProxy(TestSaslProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)newConf);
            Client client = RPC.getClient((Configuration)conf);
            Set conns = client.getConnectionIds();
            Assert.assertEquals((String)"number of connections in cache is wrong", (long)1L, (long)conns.size());
            proxy2 = (TestSaslProtocol)RPC.getProxy(TestSaslProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)newConf);
            Assert.assertEquals((String)"number of connections in cache is wrong", (long)1L, (long)conns.size());
            newConf.set(SERVER_PRINCIPAL_KEY, SERVER_PRINCIPAL_2);
            proxy3 = (TestSaslProtocol)RPC.getProxy(TestSaslProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)newConf);
            Client.ConnectionId[] connsArray = conns.toArray(new Client.ConnectionId[0]);
            Assert.assertEquals((String)"number of connections in cache is wrong", (long)2L, (long)connsArray.length);
            String p1 = connsArray[0].getServerPrincipal();
            String p2 = connsArray[1].getServerPrincipal();
            Assert.assertFalse((String)"should have different principals", (boolean)p1.equals(p2));
            Assert.assertTrue((String)"principal not as expected", (p1.equals(SERVER_PRINCIPAL_1) || p1.equals(SERVER_PRINCIPAL_2) ? 1 : 0) != 0);
            Assert.assertTrue((String)"principal not as expected", (p2.equals(SERVER_PRINCIPAL_1) || p2.equals(SERVER_PRINCIPAL_2) ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            server.stop();
            RPC.stopProxy(proxy1);
            RPC.stopProxy(proxy2);
            RPC.stopProxy(proxy3);
            throw throwable;
        }
        server.stop();
        RPC.stopProxy((VersionedProtocol)proxy1);
        RPC.stopProxy((VersionedProtocol)proxy2);
        RPC.stopProxy((VersionedProtocol)proxy3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void testKerberosRpc(String principal, String keytab) throws Exception {
        Configuration newConf = new Configuration(conf);
        newConf.set(SERVER_PRINCIPAL_KEY, principal);
        newConf.set(SERVER_KEYTAB_KEY, keytab);
        SecurityUtil.login((Configuration)newConf, (String)SERVER_KEYTAB_KEY, (String)SERVER_PRINCIPAL_KEY);
        TestUserGroupInformation.verifyLoginMetrics(1, 0);
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        System.out.println("UGI: " + current);
        RPC.Server server = RPC.getServer((Object)new TestSaslImpl(), (String)ADDRESS, (int)0, (int)5, (boolean)true, (Configuration)newConf, null);
        TestSaslProtocol proxy = null;
        server.start();
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        try {
            proxy = (TestSaslProtocol)RPC.getProxy(TestSaslProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)newConf);
            proxy.ping();
        }
        finally {
            server.stop();
            if (proxy != null) {
                RPC.stopProxy((VersionedProtocol)proxy);
            }
        }
        System.out.println("Test is successful.");
    }

    @Test
    public void testDigestAuthMethod() throws Exception {
        TestTokenSecretManager sm = new TestTokenSecretManager();
        RPC.Server server = RPC.getServer((Object)new TestSaslImpl(), (String)ADDRESS, (int)0, (int)5, (boolean)true, (Configuration)conf, (SecretManager)sm);
        server.start();
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        final InetSocketAddress addr = NetUtils.createSocketAddr((String)ADDRESS, (int)server.getListenerAddress().getPort());
        TestTokenIdentifier tokenId = new TestTokenIdentifier(new Text(current.getUserName()));
        Token token = new Token((TokenIdentifier)tokenId, (SecretManager)sm);
        Text host = new Text(addr.getAddress().getHostAddress() + ":" + addr.getPort());
        token.setService(host);
        LOG.info((Object)("Service IP address for token is " + host));
        current.addToken(token);
        current.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object run() throws IOException {
                TestSaslProtocol proxy = null;
                try {
                    proxy = (TestSaslProtocol)RPC.getProxy(TestSaslProtocol.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
                    junit.framework.Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.TOKEN, (Object)proxy.getAuthMethod());
                    if (proxy == null) return null;
                }
                catch (Throwable throwable) {
                    if (proxy == null) throw throwable;
                    RPC.stopProxy(proxy);
                    throw throwable;
                }
                RPC.stopProxy((VersionedProtocol)proxy);
                return null;
            }
        });
        server.stop();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Testing Kerberos authentication over RPC");
        if (args.length != 2) {
            System.err.println("Usage: java <options> org.apache.hadoop.ipc.TestSaslRPC  <serverPrincipal> <keytabFile>");
            System.exit(-1);
        }
        String principal = args[0];
        String keytab = args[1];
        TestSaslRPC.testKerberosRpc(principal, keytab);
    }

    static {
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        ((Log4JLogger)Client.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)Server.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslRpcClient.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslRpcServer.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslInputStream.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SecurityUtil.LOG).getLogger().setLevel(Level.ALL);
    }

    public static class TestSaslImpl
    extends TestRPC.TestImpl
    implements TestSaslProtocol {
        @Override
        public UserGroupInformation.AuthenticationMethod getAuthMethod() throws IOException {
            return UserGroupInformation.getCurrentUser().getAuthenticationMethod();
        }
    }

    @KerberosInfo(serverPrincipal="test.ipc.server.principal")
    @TokenInfo(value=TestTokenSelector.class)
    public static interface TestSaslProtocol
    extends TestRPC.TestProtocol {
        public UserGroupInformation.AuthenticationMethod getAuthMethod() throws IOException;
    }

    public static class TestTokenSelector
    implements TokenSelector<TestTokenIdentifier> {
        public Token<TestTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
            if (service == null) {
                return null;
            }
            for (Token<? extends TokenIdentifier> token : tokens) {
                if (!TestTokenIdentifier.KIND_NAME.equals((Object)token.getKind()) || !service.equals((Object)token.getService())) continue;
                return token;
            }
            return null;
        }
    }

    public static class BadTokenSecretManager
    extends TestTokenSecretManager {
        @Override
        public byte[] retrievePassword(TestTokenIdentifier id) throws SecretManager.InvalidToken {
            throw new SecretManager.InvalidToken(TestSaslRPC.ERROR_MESSAGE);
        }
    }

    public static class TestTokenSecretManager
    extends SecretManager<TestTokenIdentifier> {
        public byte[] createPassword(TestTokenIdentifier id) {
            return id.getBytes();
        }

        public byte[] retrievePassword(TestTokenIdentifier id) throws SecretManager.InvalidToken {
            return id.getBytes();
        }

        public TestTokenIdentifier createIdentifier() {
            return new TestTokenIdentifier();
        }
    }

    public static class TestTokenIdentifier
    extends TokenIdentifier {
        private Text tokenid;
        private Text realUser;
        static final Text KIND_NAME = new Text("test.token");

        public TestTokenIdentifier() {
            this(new Text(), new Text());
        }

        public TestTokenIdentifier(Text tokenid) {
            this(tokenid, new Text());
        }

        public TestTokenIdentifier(Text tokenid, Text realUser) {
            this.tokenid = tokenid == null ? new Text() : tokenid;
            this.realUser = realUser == null ? new Text() : realUser;
        }

        public Text getKind() {
            return KIND_NAME;
        }

        public UserGroupInformation getUser() {
            if ("".equals(this.realUser.toString())) {
                return UserGroupInformation.createRemoteUser((String)this.tokenid.toString());
            }
            UserGroupInformation realUgi = UserGroupInformation.createRemoteUser((String)this.realUser.toString());
            return UserGroupInformation.createProxyUser((String)this.tokenid.toString(), (UserGroupInformation)realUgi);
        }

        public void readFields(DataInput in) throws IOException {
            this.tokenid.readFields(in);
            this.realUser.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            this.tokenid.write(out);
            this.realUser.write(out);
        }
    }
}

