/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.net.URL;
import java.net.URLClassLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.streaming.StreamUtil;
import org.apache.hadoop.util.JarFinder;
import org.junit.Assert;
import org.junit.Test;

public class TestClassWithNoPackage {
    @Test
    public void testGoodClassOrNull() throws Exception {
        String NAME = "ClassWithNoPackage";
        ClassLoader cl = TestClassWithNoPackage.class.getClassLoader();
        String JAR = JarFinder.getJar(cl.loadClass(NAME));
        Configuration conf = new Configuration();
        conf.setClassLoader((ClassLoader)new URLClassLoader(new URL[]{new URL("file", null, JAR)}, null));
        String defaultPackage = this.getClass().getPackage().getName();
        Class c = StreamUtil.goodClassOrNull((Configuration)conf, (String)NAME, (String)defaultPackage);
        Assert.assertNotNull((String)("Class " + NAME + " not found!"), (Object)c);
    }

    public static void main(String[] args) throws Exception {
        new TestClassWithNoPackage().testGoodClassOrNull();
    }
}

