/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.streaming.TestStreaming;

public class TestStreamXmlRecordReader
extends TestStreaming {
    public TestStreamXmlRecordReader() throws IOException {
        this.INPUT_FILE = new File("target/input.xml");
        this.input = "<xmltag>\t\nroses.are.red\t\nviolets.are.blue\t\nbunnies.are.pink\t\n</xmltag>\t\n";
        this.map = CAT;
        this.reduce = "NONE";
        this.outputExpect = this.input;
    }

    protected void createInput() throws IOException {
        FileOutputStream out = new FileOutputStream(this.INPUT_FILE.getAbsoluteFile());
        String dummyXmlStartTag = "<PATTERN>\n";
        String dummyXmlEndTag = "</PATTERN>\n";
        out.write(dummyXmlStartTag.getBytes("UTF-8"));
        out.write(this.input.getBytes("UTF-8"));
        out.write(dummyXmlEndTag.getBytes("UTF-8"));
        out.close();
    }

    protected String[] genArgs() {
        this.args.add("-inputreader");
        this.args.add("StreamXmlRecordReader,begin=<xmltag>,end=</xmltag>");
        this.args.add("-jobconf");
        this.args.add("mapreduce.job.maps=1");
        return super.genArgs();
    }
}

