/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.util.Arrays;
import org.apache.hadoop.streaming.DumpTypedBytes;
import org.apache.hadoop.streaming.LoadTypedBytes;
import org.apache.hadoop.streaming.StreamJob;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * Exception performing whole class analysis ignored.
 */
public class HadoopStreaming {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("No Arguments Given!");
            HadoopStreaming.printUsage();
            System.exit(1);
        }
        int returnStatus = 0;
        String cmd = args[0];
        String[] remainingArgs = Arrays.copyOfRange(args, 1, args.length);
        if (cmd.equalsIgnoreCase("dumptb")) {
            DumpTypedBytes dumptb = new DumpTypedBytes();
            returnStatus = ToolRunner.run((Tool)dumptb, (String[])remainingArgs);
        } else if (cmd.equalsIgnoreCase("loadtb")) {
            LoadTypedBytes loadtb = new LoadTypedBytes();
            returnStatus = ToolRunner.run((Tool)loadtb, (String[])remainingArgs);
        } else if (cmd.equalsIgnoreCase("streamjob")) {
            StreamJob job = new StreamJob();
            returnStatus = ToolRunner.run((Tool)job, (String[])remainingArgs);
        } else {
            StreamJob job = new StreamJob();
            returnStatus = ToolRunner.run((Tool)job, (String[])args);
        }
        if (returnStatus != 0) {
            System.err.println("Streaming Command Failed!");
            System.exit(returnStatus);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: $HADOOP_PREFIX/bin/hadoop jar hadoop-streaming.jar [options]");
        System.out.println("Options:");
        System.out.println("  dumptb <glob-pattern> Dumps all files that match the given pattern to ");
        System.out.println("                        standard output as typed bytes.");
        System.out.println("  loadtb <path> Reads typed bytes from standard input and stores them in");
        System.out.println("                a sequence file in the specified path");
        System.out.println("  [streamjob] <args> Runs streaming job with given arguments");
    }
}

