/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.streaming.LoadTypedBytes;
import org.apache.hadoop.typedbytes.TypedBytesOutput;
import org.apache.hadoop.typedbytes.TypedBytesWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestLoadTypedBytes {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoading() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).format(true).build();
        FileSystem fs = cluster.getFileSystem();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TypedBytesOutput tboutput = new TypedBytesOutput((DataOutput)new DataOutputStream(out));
        for (int i = 0; i < 100; ++i) {
            tboutput.write((Object)new Long(i));
            tboutput.write((Object)("" + 10 * i));
        }
        InputStream isBackup = System.in;
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        System.setIn(in);
        LoadTypedBytes loadtb = new LoadTypedBytes(conf);
        try {
            Path root = new Path("/typedbytestest");
            Assert.assertTrue((boolean)fs.mkdirs(root));
            Assert.assertTrue((boolean)fs.exists(root));
            String[] args = new String[]{"/typedbytestest/test.seq"};
            int ret = loadtb.run(args);
            Assert.assertEquals((String)"Return value != 0.", (long)0L, (long)ret);
            Path file = new Path(root, "test.seq");
            Assert.assertTrue((boolean)fs.exists(file));
            SequenceFile.Reader reader = new SequenceFile.Reader(fs, file, conf);
            int counter = 0;
            TypedBytesWritable key = new TypedBytesWritable();
            TypedBytesWritable value = new TypedBytesWritable();
            while (reader.next((Writable)key, (Writable)value)) {
                Assert.assertEquals(Long.class, key.getValue().getClass());
                Assert.assertEquals(String.class, value.getValue().getClass());
                Assert.assertTrue((String)"Invalid record.", (Integer.parseInt(value.toString()) % 10 == 0 ? 1 : 0) != 0);
                ++counter;
            }
            Assert.assertEquals((String)"Wrong number of records.", (long)100L, (long)counter);
        }
        finally {
            try {
                fs.close();
            }
            catch (Exception e) {}
            System.setIn(isBackup);
            cluster.shutdown();
        }
    }
}

