/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.streaming.StreamJob;
import org.apache.hadoop.streaming.StreamUtil;
import org.apache.hadoop.streaming.TestStreaming;

public class TestMultipleArchiveFiles
extends TestStreaming {
    private static final Log LOG = LogFactory.getLog(TestMultipleArchiveFiles.class);
    private StreamJob job;
    private String INPUT_DIR = "multiple-archive-files/";
    private String INPUT_FILE = this.INPUT_DIR + "input.txt";
    private String CACHE_ARCHIVE_1 = this.INPUT_DIR + "cacheArchive1.zip";
    private File CACHE_FILE_1 = null;
    private String CACHE_ARCHIVE_2 = this.INPUT_DIR + "cacheArchive2.zip";
    private File CACHE_FILE_2 = null;
    private String expectedOutput = null;
    private String OUTPUT_DIR = "out";
    private Configuration conf = null;
    private MiniDFSCluster dfs = null;
    private MiniMRCluster mr = null;
    private FileSystem fileSys = null;
    private String namenode = null;

    public TestMultipleArchiveFiles() throws Exception {
        this.CACHE_FILE_1 = new File("cacheArchive1");
        this.CACHE_FILE_2 = new File("cacheArchive2");
        this.input = "HADOOP";
        this.expectedOutput = "HADOOP\t\nHADOOP\t\n";
        this.conf = new Configuration();
        this.dfs = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).format(true).build();
        this.fileSys = this.dfs.getFileSystem();
        this.namenode = this.fileSys.getUri().getAuthority();
        this.mr = new MiniMRCluster(1, this.namenode, 1);
        this.map = XARGS_CAT;
        this.reduce = CAT;
    }

    protected void setInputOutput() {
        this.inputFile = this.INPUT_FILE;
        this.outDir = this.OUTPUT_DIR;
    }

    protected void createInput() throws IOException {
        this.fileSys.delete(new Path(this.INPUT_DIR), true);
        FSDataOutputStream dos = this.fileSys.create(new Path(this.INPUT_FILE));
        String inputFileString = "symlink1" + File.separator + "cacheArchive1\nsymlink2" + File.separator + "cacheArchive2";
        dos.write(inputFileString.getBytes("UTF-8"));
        dos.close();
        FSDataOutputStream out = this.fileSys.create(new Path(this.CACHE_ARCHIVE_1.toString()));
        ZipOutputStream zos = new ZipOutputStream((OutputStream)out);
        ZipEntry ze = new ZipEntry(this.CACHE_FILE_1.toString());
        zos.putNextEntry(ze);
        zos.write(this.input.getBytes("UTF-8"));
        zos.closeEntry();
        zos.close();
        out = this.fileSys.create(new Path(this.CACHE_ARCHIVE_2.toString()));
        zos = new ZipOutputStream((OutputStream)out);
        ze = new ZipEntry(this.CACHE_FILE_2.toString());
        zos.putNextEntry(ze);
        zos.write(this.input.getBytes("UTF-8"));
        zos.closeEntry();
        zos.close();
    }

    protected String[] genArgs() {
        String workDir = this.fileSys.getWorkingDirectory().toString() + "/";
        String cache1 = workDir + this.CACHE_ARCHIVE_1 + "#symlink1";
        String cache2 = workDir + this.CACHE_ARCHIVE_2 + "#symlink2";
        for (Map.Entry entry : this.mr.createJobConf()) {
            this.args.add("-jobconf");
            this.args.add((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        this.args.add("-jobconf");
        this.args.add("mapreduce.job.reduces=1");
        this.args.add("-cacheArchive");
        this.args.add(cache1);
        this.args.add("-cacheArchive");
        this.args.add(cache2);
        this.args.add("-jobconf");
        this.args.add("mapred.jar=" + STREAMING_JAR);
        return super.genArgs();
    }

    protected void checkOutput() throws IOException {
        StringBuffer output = new StringBuffer(256);
        Path[] fileList = FileUtil.stat2Paths((FileStatus[])this.fileSys.listStatus(new Path(this.OUTPUT_DIR)));
        for (int i = 0; i < fileList.length; ++i) {
            LOG.info((Object)("Adding output from file: " + fileList[i]));
            output.append(StreamUtil.slurpHadoop((Path)fileList[i], (FileSystem)this.fileSys));
        }
        this.assertOutput(this.expectedOutput, output.toString());
    }
}

