/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.web;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.junit.Assert;
import org.junit.Test;

public class TestSLSWebApp {
    @Test
    public void testSimulateInfoPageHtmlTemplate() throws Exception {
        String simulateInfoTemplate = FileUtils.readFileToString((File)new File("src/main/html/simulate.info.html.template"));
        SLSRunner.simulateInfoMap.put("Number of racks", 10);
        SLSRunner.simulateInfoMap.put("Number of nodes", 100);
        SLSRunner.simulateInfoMap.put("Node memory (MB)", 1024);
        SLSRunner.simulateInfoMap.put("Node VCores", 1);
        SLSRunner.simulateInfoMap.put("Number of applications", 100);
        SLSRunner.simulateInfoMap.put("Number of tasks", 1000);
        SLSRunner.simulateInfoMap.put("Average tasks per applicaion", 10);
        SLSRunner.simulateInfoMap.put("Number of queues", 4);
        SLSRunner.simulateInfoMap.put("Average applications per queue", 25);
        SLSRunner.simulateInfoMap.put("Estimated simulate time (s)", 10000);
        StringBuilder info = new StringBuilder();
        for (Map.Entry entry : SLSRunner.simulateInfoMap.entrySet()) {
            info.append("<tr>");
            info.append("<td class='td1'>" + (String)entry.getKey() + "</td>");
            info.append("<td class='td2'>" + entry.getValue() + "</td>");
            info.append("</tr>");
        }
        String simulateInfo = MessageFormat.format(simulateInfoTemplate, info.toString());
        Assert.assertTrue((String)"The simulate info html page should not be empty", (simulateInfo.length() > 0 ? 1 : 0) != 0);
        for (Map.Entry entry : SLSRunner.simulateInfoMap.entrySet()) {
            Assert.assertTrue((String)("The simulate info html page should have information of " + (String)entry.getKey()), (boolean)simulateInfo.contains("<td class='td1'>" + (String)entry.getKey() + "</td><td class='td2'>" + entry.getValue() + "</td>"));
        }
    }

    @Test
    public void testSimulatePageHtmlTemplate() throws Exception {
        String simulateTemplate = FileUtils.readFileToString((File)new File("src/main/html/simulate.html.template"));
        HashSet<String> queues = new HashSet<String>();
        queues.add("sls_queue_1");
        queues.add("sls_queue_2");
        queues.add("sls_queue_3");
        String queueInfo = "";
        int i = 0;
        for (String queue : queues) {
            queueInfo = queueInfo + "legends[4][" + i + "] = 'queue" + queue + ".allocated.memory'";
            queueInfo = queueInfo + "legends[5][" + i + "] = 'queue" + queue + ".allocated.vcores'";
            ++i;
        }
        String simulateInfo = MessageFormat.format(simulateTemplate, queueInfo, "s", 1000, 1000);
        Assert.assertTrue((String)"The simulate page html page should not be empty", (simulateInfo.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTrackPageHtmlTemplate() throws Exception {
        String trackTemplate = FileUtils.readFileToString((File)new File("src/main/html/track.html.template"));
        String trackedQueueInfo = "";
        HashSet<String> trackedQueues = new HashSet<String>();
        trackedQueues.add("sls_queue_1");
        trackedQueues.add("sls_queue_2");
        trackedQueues.add("sls_queue_3");
        for (String queue : trackedQueues) {
            trackedQueueInfo = trackedQueueInfo + "<option value='Queue " + queue + "'>" + queue + "</option>";
        }
        String trackedAppInfo = "";
        HashSet<String> trackedApps = new HashSet<String>();
        trackedApps.add("app_1");
        trackedApps.add("app_2");
        for (String job : trackedApps) {
            trackedAppInfo = trackedAppInfo + "<option value='Job " + job + "'>" + job + "</option>";
        }
        String trackInfo = MessageFormat.format(trackTemplate, trackedQueueInfo, trackedAppInfo, "s", 1000, 1000);
        Assert.assertTrue((String)"The queue/app tracking html page should not be empty", (trackInfo.length() > 0 ? 1 : 0) != 0);
    }
}

