/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.nodemanager;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.sls.nodemanager.NMSimulator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNMSimulator {
    private final int GB = 1024;
    private ResourceManager rm;
    private YarnConfiguration conf;

    @Before
    public void setup() {
        this.conf = new YarnConfiguration();
        this.conf.set("yarn.resourcemanager.scheduler.class", "org.apache.hadoop.yarn.sls.scheduler.ResourceSchedulerWrapper");
        this.conf.set("yarn.sls.scheduler.class", "org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler");
        this.conf.setBoolean("yarn.sls.metrics.switch", false);
        this.rm = new ResourceManager();
        this.rm.init((Configuration)this.conf);
        this.rm.start();
    }

    @Test
    public void testNMSimulator() throws Exception {
        NMSimulator node1 = new NMSimulator();
        node1.init("rack1/node1", 10240, 10, 0, 1000, this.rm);
        node1.middleStep();
        Assert.assertEquals((long)1L, (long)this.rm.getResourceScheduler().getNumClusterNodes());
        Assert.assertEquals((long)10240L, (long)this.rm.getResourceScheduler().getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)10L, (long)this.rm.getResourceScheduler().getRootQueueMetrics().getAvailableVirtualCores());
        ContainerId cId1 = this.newContainerId(1, 1, 1);
        Container container1 = Container.newInstance((ContainerId)cId1, null, null, (Resource)Resources.createResource((int)1024, (int)1), null, null);
        node1.addNewContainer(container1, 100000L);
        Assert.assertTrue((String)"Node1 should have one running container.", (boolean)node1.getRunningContainers().containsKey(cId1));
        ContainerId cId2 = this.newContainerId(2, 1, 1);
        Container container2 = Container.newInstance((ContainerId)cId2, null, null, (Resource)Resources.createResource((int)1024, (int)1), null, null);
        node1.addNewContainer(container2, -1L);
        Assert.assertTrue((String)"Node1 should have one running AM container", (boolean)node1.getAMContainers().contains(cId2));
        node1.cleanupContainer(cId1);
        Assert.assertTrue((String)"Container1 should be removed from Node1.", (boolean)node1.getCompletedContainers().contains(cId1));
        node1.cleanupContainer(cId2);
        Assert.assertFalse((String)"Container2 should be removed from Node1.", (boolean)node1.getAMContainers().contains(cId2));
    }

    private ContainerId newContainerId(int appId, int appAttemptId, int cId) {
        return BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)System.currentTimeMillis(), (int)appId), (int)appAttemptId), (int)cId);
    }

    @After
    public void tearDown() throws Exception {
        this.rm.stop();
    }
}

