/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.scheduler;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;

public class RMNodeWrapper
implements RMNode {
    private RMNode node;
    private List<UpdatedContainerInfo> updates;
    private boolean pulled = false;

    public RMNodeWrapper(RMNode node) {
        this.node = node;
        this.updates = node.pullContainerUpdates();
    }

    public NodeId getNodeID() {
        return this.node.getNodeID();
    }

    public String getHostName() {
        return this.node.getHostName();
    }

    public int getCommandPort() {
        return this.node.getCommandPort();
    }

    public int getHttpPort() {
        return this.node.getHttpPort();
    }

    public String getNodeAddress() {
        return this.node.getNodeAddress();
    }

    public String getHttpAddress() {
        return this.node.getHttpAddress();
    }

    public String getHealthReport() {
        return this.node.getHealthReport();
    }

    public long getLastHealthReportTime() {
        return this.node.getLastHealthReportTime();
    }

    public Resource getTotalCapability() {
        return this.node.getTotalCapability();
    }

    public String getRackName() {
        return this.node.getRackName();
    }

    public Node getNode() {
        return this.node.getNode();
    }

    public NodeState getState() {
        return this.node.getState();
    }

    public List<ContainerId> getContainersToCleanUp() {
        return this.node.getContainersToCleanUp();
    }

    public List<ApplicationId> getAppsToCleanup() {
        return this.node.getAppsToCleanup();
    }

    public void updateNodeHeartbeatResponseForCleanup(NodeHeartbeatResponse nodeHeartbeatResponse) {
        this.node.updateNodeHeartbeatResponseForCleanup(nodeHeartbeatResponse);
    }

    public NodeHeartbeatResponse getLastNodeHeartBeatResponse() {
        return this.node.getLastNodeHeartBeatResponse();
    }

    public List<UpdatedContainerInfo> pullContainerUpdates() {
        List<UpdatedContainerInfo> list = Collections.EMPTY_LIST;
        if (!this.pulled) {
            list = this.updates;
            this.pulled = true;
        }
        return list;
    }

    List<UpdatedContainerInfo> getContainerUpdates() {
        return this.updates;
    }

    public String getNodeManagerVersion() {
        return this.node.getNodeManagerVersion();
    }

    public void setResourceOption(ResourceOption resourceOption) {
        this.node.setResourceOption(resourceOption);
    }

    public ResourceOption getResourceOption() {
        return this.node.getResourceOption();
    }
}

