/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.web;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.scheduler.FairSchedulerMetrics;
import org.apache.hadoop.yarn.sls.scheduler.ResourceSchedulerWrapper;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerMetrics;
import org.apache.hadoop.yarn.sls.web.SLSWebApp;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ResourceHandler;

public class SLSWebApp
extends HttpServlet {
    private static final long serialVersionUID = 1905162041950251407L;
    private transient Server server;
    private transient ResourceSchedulerWrapper wrapper;
    private transient MetricRegistry metrics;
    private transient SchedulerMetrics schedulerMetrics;
    private transient Gauge jvmFreeMemoryGauge;
    private transient Gauge jvmMaxMemoryGauge;
    private transient Gauge jvmTotalMemoryGauge;
    private transient Gauge numRunningAppsGauge;
    private transient Gauge numRunningContainersGauge;
    private transient Gauge allocatedMemoryGauge;
    private transient Gauge allocatedVCoresGauge;
    private transient Gauge availableMemoryGauge;
    private transient Gauge availableVCoresGauge;
    private transient Histogram allocateTimecostHistogram;
    private transient Histogram handleTimecostHistogram;
    private Map<SchedulerEventType, Histogram> handleOperTimecostHistogramMap;
    private Map<String, Counter> queueAllocatedMemoryCounterMap;
    private Map<String, Counter> queueAllocatedVCoresCounterMap;
    private int port;
    private int ajaxUpdateTimeMS = 1000;
    private String simulateInfoTemplate;
    private String simulateTemplate;
    private String trackTemplate;

    public SLSWebApp(ResourceSchedulerWrapper wrapper, int metricsAddressPort) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            this.simulateInfoTemplate = FileUtils.readFileToString((File)new File(cl.getResource("simulate.info.html.template").getFile()));
            this.simulateTemplate = FileUtils.readFileToString((File)new File(cl.getResource("simulate.html.template").getFile()));
            this.trackTemplate = FileUtils.readFileToString((File)new File(cl.getResource("track.html.template").getFile()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.wrapper = wrapper;
        this.metrics = wrapper.getMetrics();
        this.handleOperTimecostHistogramMap = new HashMap();
        this.queueAllocatedMemoryCounterMap = new HashMap();
        this.queueAllocatedVCoresCounterMap = new HashMap();
        this.schedulerMetrics = wrapper.getSchedulerMetrics();
        this.port = metricsAddressPort;
    }

    public void start() throws Exception {
        ResourceHandler staticHandler = new ResourceHandler();
        staticHandler.setResourceBase("html");
        1 handler = new /* Unavailable Anonymous Inner Class!! */;
        this.server = new Server(this.port);
        this.server.setHandler((Handler)handler);
        this.server.start();
    }

    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private void printPageIndex(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String simulateInfo;
        response.setContentType("text/html");
        response.setStatus(200);
        if (SLSRunner.simulateInfoMap.isEmpty()) {
            String empty = "<tr><td colspan='2' align='center'>No information available</td></tr>";
            simulateInfo = MessageFormat.format(this.simulateInfoTemplate, empty);
        } else {
            StringBuilder info = new StringBuilder();
            for (Map.Entry entry : SLSRunner.simulateInfoMap.entrySet()) {
                info.append("<tr>");
                info.append("<td class='td1'>").append((String)entry.getKey()).append("</td>");
                info.append("<td class='td2'>").append(entry.getValue()).append("</td>");
                info.append("</tr>");
            }
            simulateInfo = MessageFormat.format(this.simulateInfoTemplate, info.toString());
        }
        response.getWriter().println(simulateInfo);
        ((Request)request).setHandled(true);
    }

    private void printPageSimulate(HttpServletRequest request, HttpServletResponse response, int timeunit, String timeunitLabel) throws IOException {
        response.setContentType("text/html");
        response.setStatus(200);
        Set queues = this.wrapper.getQueueSet();
        StringBuilder queueInfo = new StringBuilder();
        int i = 0;
        for (String queue : queues) {
            queueInfo.append("legends[4][").append(i).append("] = 'queue.").append(queue).append(".allocated.memory';");
            queueInfo.append("legends[5][").append(i).append("] = 'queue.").append(queue).append(".allocated.vcores';");
            ++i;
        }
        String simulateInfo = MessageFormat.format(this.simulateTemplate, queueInfo.toString(), timeunitLabel, "" + timeunit, "" + this.ajaxUpdateTimeMS);
        response.getWriter().println(simulateInfo);
        ((Request)request).setHandled(true);
    }

    private void printPageTrack(HttpServletRequest request, HttpServletResponse response, int timeunit, String timeunitLabel) throws IOException {
        response.setContentType("text/html");
        response.setStatus(200);
        StringBuilder trackedQueueInfo = new StringBuilder();
        Set trackedQueues = this.wrapper.getQueueSet();
        for (String queue : trackedQueues) {
            trackedQueueInfo.append("<option value='Queue ").append(queue).append("'>").append(queue).append("</option>");
        }
        StringBuilder trackedAppInfo = new StringBuilder();
        Set trackedApps = this.wrapper.getTrackedAppSet();
        for (String job : trackedApps) {
            trackedAppInfo.append("<option value='Job ").append(job).append("'>").append(job).append("</option>");
        }
        String trackInfo = MessageFormat.format(this.trackTemplate, trackedQueueInfo.toString(), trackedAppInfo.toString(), timeunitLabel, "" + timeunit, "" + this.ajaxUpdateTimeMS);
        response.getWriter().println(trackInfo);
        ((Request)request).setHandled(true);
    }

    private void printJsonMetrics(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/json");
        response.setStatus(200);
        response.getWriter().println(this.generateRealTimeTrackingMetrics());
        ((Request)request).setHandled(true);
    }

    public String generateRealTimeTrackingMetrics() {
        String key;
        double availableVCoresGB;
        String numRunningContainers;
        double jvmTotalMemoryGB;
        if (this.jvmFreeMemoryGauge == null && this.metrics.getGauges().containsKey("variable.jvm.free.memory")) {
            this.jvmFreeMemoryGauge = (Gauge)this.metrics.getGauges().get("variable.jvm.free.memory");
        }
        if (this.jvmMaxMemoryGauge == null && this.metrics.getGauges().containsKey("variable.jvm.max.memory")) {
            this.jvmMaxMemoryGauge = (Gauge)this.metrics.getGauges().get("variable.jvm.max.memory");
        }
        if (this.jvmTotalMemoryGauge == null && this.metrics.getGauges().containsKey("variable.jvm.total.memory")) {
            this.jvmTotalMemoryGauge = (Gauge)this.metrics.getGauges().get("variable.jvm.total.memory");
        }
        double jvmFreeMemoryGB = this.jvmFreeMemoryGauge == null ? 0.0 : Double.parseDouble(this.jvmFreeMemoryGauge.getValue().toString()) / 1024.0 / 1024.0 / 1024.0;
        double jvmMaxMemoryGB = this.jvmMaxMemoryGauge == null ? 0.0 : Double.parseDouble(this.jvmMaxMemoryGauge.getValue().toString()) / 1024.0 / 1024.0 / 1024.0;
        double d = jvmTotalMemoryGB = this.jvmTotalMemoryGauge == null ? 0.0 : Double.parseDouble(this.jvmTotalMemoryGauge.getValue().toString()) / 1024.0 / 1024.0 / 1024.0;
        if (this.numRunningAppsGauge == null && this.metrics.getGauges().containsKey("variable.running.application")) {
            this.numRunningAppsGauge = (Gauge)this.metrics.getGauges().get("variable.running.application");
        }
        if (this.numRunningContainersGauge == null && this.metrics.getGauges().containsKey("variable.running.container")) {
            this.numRunningContainersGauge = (Gauge)this.metrics.getGauges().get("variable.running.container");
        }
        String numRunningApps = this.numRunningAppsGauge == null ? "0" : this.numRunningAppsGauge.getValue().toString();
        String string = numRunningContainers = this.numRunningContainersGauge == null ? "0" : this.numRunningContainersGauge.getValue().toString();
        if (this.allocatedMemoryGauge == null && this.metrics.getGauges().containsKey("variable.cluster.allocated.memory")) {
            this.allocatedMemoryGauge = (Gauge)this.metrics.getGauges().get("variable.cluster.allocated.memory");
        }
        if (this.allocatedVCoresGauge == null && this.metrics.getGauges().containsKey("variable.cluster.allocated.vcores")) {
            this.allocatedVCoresGauge = (Gauge)this.metrics.getGauges().get("variable.cluster.allocated.vcores");
        }
        if (this.availableMemoryGauge == null && this.metrics.getGauges().containsKey("variable.cluster.available.memory")) {
            this.availableMemoryGauge = (Gauge)this.metrics.getGauges().get("variable.cluster.available.memory");
        }
        if (this.availableVCoresGauge == null && this.metrics.getGauges().containsKey("variable.cluster.available.vcores")) {
            this.availableVCoresGauge = (Gauge)this.metrics.getGauges().get("variable.cluster.available.vcores");
        }
        double allocatedMemoryGB = this.allocatedMemoryGauge == null ? 0.0 : Double.parseDouble(this.allocatedMemoryGauge.getValue().toString()) / 1024.0;
        double allocatedVCoresGB = this.allocatedVCoresGauge == null ? 0.0 : Double.parseDouble(this.allocatedVCoresGauge.getValue().toString());
        double availableMemoryGB = this.availableMemoryGauge == null ? 0.0 : Double.parseDouble(this.availableMemoryGauge.getValue().toString()) / 1024.0;
        double d2 = availableVCoresGB = this.availableVCoresGauge == null ? 0.0 : Double.parseDouble(this.availableVCoresGauge.getValue().toString());
        if (this.allocateTimecostHistogram == null && this.metrics.getHistograms().containsKey("sampler.scheduler.operation.allocate.timecost")) {
            this.allocateTimecostHistogram = (Histogram)this.metrics.getHistograms().get("sampler.scheduler.operation.allocate.timecost");
        }
        if (this.handleTimecostHistogram == null && this.metrics.getHistograms().containsKey("sampler.scheduler.operation.handle.timecost")) {
            this.handleTimecostHistogram = (Histogram)this.metrics.getHistograms().get("sampler.scheduler.operation.handle.timecost");
        }
        double allocateTimecost = this.allocateTimecostHistogram == null ? 0.0 : this.allocateTimecostHistogram.getSnapshot().getMean() / 1000000.0;
        double handleTimecost = this.handleTimecostHistogram == null ? 0.0 : this.handleTimecostHistogram.getSnapshot().getMean() / 1000000.0;
        HashMap<SchedulerEventType, Double> handleOperTimecostMap = new HashMap<SchedulerEventType, Double>();
        for (SchedulerEventType e : SchedulerEventType.values()) {
            key = "sampler.scheduler.operation.handle." + e + ".timecost";
            if (!this.handleOperTimecostHistogramMap.containsKey(e) && this.metrics.getHistograms().containsKey(key)) {
                this.handleOperTimecostHistogramMap.put(e, this.metrics.getHistograms().get(key));
            }
            double timecost = this.handleOperTimecostHistogramMap.containsKey(e) ? ((Histogram)this.handleOperTimecostHistogramMap.get(e)).getSnapshot().getMean() / 1000000.0 : 0.0;
            handleOperTimecostMap.put(e, timecost);
        }
        HashMap<String, Double> queueAllocatedMemoryMap = new HashMap<String, Double>();
        HashMap<String, Long> queueAllocatedVCoresMap = new HashMap<String, Long>();
        for (String queue : this.wrapper.getQueueSet()) {
            key = "counter.queue." + queue + ".allocated.memory";
            if (!this.queueAllocatedMemoryCounterMap.containsKey(queue) && this.metrics.getCounters().containsKey(key)) {
                this.queueAllocatedMemoryCounterMap.put(queue, this.metrics.getCounters().get(key));
            }
            double queueAllocatedMemoryGB = this.queueAllocatedMemoryCounterMap.containsKey(queue) ? (double)((Counter)this.queueAllocatedMemoryCounterMap.get(queue)).getCount() / 1024.0 : 0.0;
            queueAllocatedMemoryMap.put(queue, queueAllocatedMemoryGB);
            key = "counter.queue." + queue + ".allocated.cores";
            if (!this.queueAllocatedVCoresCounterMap.containsKey(queue) && this.metrics.getCounters().containsKey(key)) {
                this.queueAllocatedVCoresCounterMap.put(queue, this.metrics.getCounters().get(key));
            }
            long queueAllocatedVCores = this.queueAllocatedVCoresCounterMap.containsKey(queue) ? ((Counter)this.queueAllocatedVCoresCounterMap.get(queue)).getCount() : 0L;
            queueAllocatedVCoresMap.put(queue, queueAllocatedVCores);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("\"time\":").append(System.currentTimeMillis()).append(",\"jvm.free.memory\":").append(jvmFreeMemoryGB).append(",\"jvm.max.memory\":").append(jvmMaxMemoryGB).append(",\"jvm.total.memory\":").append(jvmTotalMemoryGB).append(",\"running.applications\":").append(numRunningApps).append(",\"running.containers\":").append(numRunningContainers).append(",\"cluster.allocated.memory\":").append(allocatedMemoryGB).append(",\"cluster.allocated.vcores\":").append(allocatedVCoresGB).append(",\"cluster.available.memory\":").append(availableMemoryGB).append(",\"cluster.available.vcores\":").append(availableVCoresGB);
        for (String queue : this.wrapper.getQueueSet()) {
            sb.append(",\"queue.").append(queue).append(".allocated.memory\":").append(queueAllocatedMemoryMap.get(queue));
            sb.append(",\"queue.").append(queue).append(".allocated.vcores\":").append(queueAllocatedVCoresMap.get(queue));
        }
        sb.append(",\"scheduler.allocate.timecost\":").append(allocateTimecost);
        sb.append(",\"scheduler.handle.timecost\":").append(handleTimecost);
        for (SchedulerEventType e : SchedulerEventType.values()) {
            sb.append(",\"scheduler.handle-").append(e).append(".timecost\":").append(handleOperTimecostMap.get(e));
        }
        sb.append("}");
        return sb.toString();
    }

    private void printJsonTrack(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String output;
        response.setContentType("text/json");
        response.setStatus(200);
        StringBuilder sb = new StringBuilder();
        if (this.schedulerMetrics instanceof FairSchedulerMetrics) {
            String para = request.getParameter("t");
            if (para.startsWith("Job ")) {
                String appId = para.substring("Job ".length());
                sb.append("{");
                sb.append("\"time\": ").append(System.currentTimeMillis()).append(",");
                sb.append("\"appId\": \"").append(appId).append("\"");
                for (String metric : this.schedulerMetrics.getAppTrackedMetrics()) {
                    String key = "variable.app." + appId + "." + metric;
                    sb.append(",\"").append(metric).append("\": ");
                    if (this.metrics.getGauges().containsKey(key)) {
                        double memoryGB = Double.parseDouble(((Gauge)this.metrics.getGauges().get(key)).getValue().toString()) / 1024.0;
                        sb.append(memoryGB);
                        continue;
                    }
                    sb.append(-1);
                }
                sb.append("}");
            } else if (para.startsWith("Queue ")) {
                String queueName = para.substring("Queue ".length());
                sb.append("{");
                sb.append("\"time\": ").append(System.currentTimeMillis()).append(",");
                sb.append("\"queueName\": \"").append(queueName).append("\"");
                for (String metric : this.schedulerMetrics.getQueueTrackedMetrics()) {
                    String key = "variable.queue." + queueName + "." + metric;
                    sb.append(",\"").append(metric).append("\": ");
                    if (this.metrics.getGauges().containsKey(key)) {
                        double memoryGB = Double.parseDouble(((Gauge)this.metrics.getGauges().get(key)).getValue().toString()) / 1024.0;
                        sb.append(memoryGB);
                        continue;
                    }
                    sb.append(-1);
                }
                sb.append("}");
            }
        }
        if ((output = sb.toString()).isEmpty()) {
            output = "[]";
        }
        response.getWriter().println(output);
        ((Request)request).setHandled(true);
    }

    static /* synthetic */ void access$000(SLSWebApp x0, HttpServletRequest x1, HttpServletResponse x2) throws IOException {
        x0.printPageIndex(x1, x2);
    }

    static /* synthetic */ void access$100(SLSWebApp x0, HttpServletRequest x1, HttpServletResponse x2, int x3, String x4) throws IOException {
        x0.printPageSimulate(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$200(SLSWebApp x0, HttpServletRequest x1, HttpServletResponse x2, int x3, String x4) throws IOException {
        x0.printPageTrack(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$300(SLSWebApp x0, HttpServletRequest x1, HttpServletResponse x2) throws IOException {
        x0.printJsonMetrics(x1, x2);
    }

    static /* synthetic */ void access$400(SLSWebApp x0, HttpServletRequest x1, HttpServletResponse x2) throws IOException {
        x0.printJsonTrack(x1, x2);
    }
}

