/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.scheduler;

import com.codahale.metrics.Metric;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AppSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerMetrics;

public class FairSchedulerMetrics
extends SchedulerMetrics {
    private int totalMemoryMB = Integer.MAX_VALUE;
    private int totalVCores = Integer.MAX_VALUE;
    private boolean maxReset = false;

    public FairSchedulerMetrics() {
        this.appTrackedMetrics.add("demand.memory");
        this.appTrackedMetrics.add("demand.vcores");
        this.appTrackedMetrics.add("usage.memory");
        this.appTrackedMetrics.add("usage.vcores");
        this.appTrackedMetrics.add("minshare.memory");
        this.appTrackedMetrics.add("minshare.vcores");
        this.appTrackedMetrics.add("maxshare.memory");
        this.appTrackedMetrics.add("maxshare.vcores");
        this.appTrackedMetrics.add("fairshare.memory");
        this.appTrackedMetrics.add("fairshare.vcores");
        this.queueTrackedMetrics.add("demand.memory");
        this.queueTrackedMetrics.add("demand.vcores");
        this.queueTrackedMetrics.add("usage.memory");
        this.queueTrackedMetrics.add("usage.vcores");
        this.queueTrackedMetrics.add("minshare.memory");
        this.queueTrackedMetrics.add("minshare.vcores");
        this.queueTrackedMetrics.add("maxshare.memory");
        this.queueTrackedMetrics.add("maxshare.vcores");
        this.queueTrackedMetrics.add("fairshare.memory");
        this.queueTrackedMetrics.add("fairshare.vcores");
    }

    public void trackApp(ApplicationAttemptId appAttemptId, String oldAppId) {
        super.trackApp(appAttemptId, oldAppId);
        FairScheduler fair = (FairScheduler)this.scheduler;
        AppSchedulable app = fair.getSchedulerApp(appAttemptId).getAppSchedulable();
        this.metrics.register("variable.app." + oldAppId + ".demand.memory", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.app." + oldAppId + ".demand.vcores", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.app." + oldAppId + ".usage.memory", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.app." + oldAppId + ".usage.vcores", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.app." + oldAppId + ".minshare.memory", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.app." + oldAppId + ".minshare.vcores", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.app." + oldAppId + ".maxshare.memory", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.app." + oldAppId + ".maxshare.vcores", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.app." + oldAppId + ".fairshare.memory", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.app." + oldAppId + ".fairshare.vcores", (Metric)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void trackQueue(String queueName) {
        this.trackedQueues.add(queueName);
        FairScheduler fair = (FairScheduler)this.scheduler;
        FSQueue queue = fair.getQueueManager().getQueue(queueName);
        this.metrics.register("variable.queue." + queueName + ".demand.memory", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.queue." + queueName + ".demand.vcores", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.queue." + queueName + ".usage.memory", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.queue." + queueName + ".usage.vcores", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.queue." + queueName + ".minshare.memory", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.queue." + queueName + ".minshare.vcores", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.queue." + queueName + ".maxshare.memory", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.queue." + queueName + ".maxshare.vcores", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.queue." + queueName + ".fairshare.memory", (Metric)new /* Unavailable Anonymous Inner Class!! */);
        this.metrics.register("variable.queue." + queueName + ".fairshare.vcores", (Metric)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void untrackQueue(String queueName) {
        this.trackedQueues.remove(queueName);
        this.metrics.remove("variable.queue." + queueName + ".demand.memory");
        this.metrics.remove("variable.queue." + queueName + ".demand.vcores");
        this.metrics.remove("variable.queue." + queueName + ".usage.memory");
        this.metrics.remove("variable.queue." + queueName + ".usage.vcores");
        this.metrics.remove("variable.queue." + queueName + ".minshare.memory");
        this.metrics.remove("variable.queue." + queueName + ".minshare.vcores");
        this.metrics.remove("variable.queue." + queueName + ".maxshare.memory");
        this.metrics.remove("variable.queue." + queueName + ".maxshare.vcores");
        this.metrics.remove("variable.queue." + queueName + ".fairshare.memory");
        this.metrics.remove("variable.queue." + queueName + ".fairshare.vcores");
    }

    static /* synthetic */ int access$000(FairSchedulerMetrics x0) {
        return x0.totalMemoryMB;
    }

    static /* synthetic */ int access$100(FairSchedulerMetrics x0) {
        return x0.totalVCores;
    }

    static /* synthetic */ boolean access$200(FairSchedulerMetrics x0) {
        return x0.maxReset;
    }

    static /* synthetic */ int access$002(FairSchedulerMetrics x0, int x1) {
        x0.totalMemoryMB = x1;
        return x0.totalMemoryMB;
    }

    static /* synthetic */ int access$102(FairSchedulerMetrics x0, int x1) {
        x0.totalVCores = x1;
        return x0.totalVCores;
    }

    static /* synthetic */ boolean access$202(FairSchedulerMetrics x0, boolean x1) {
        x0.maxReset = x1;
        return x0.maxReset;
    }
}

