/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.tools.rumen.DeepCompare;
import org.apache.hadoop.tools.rumen.DeepInequalityException;
import org.apache.hadoop.tools.rumen.LoggedDiscreteCDF;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.LoggedTask;
import org.apache.hadoop.tools.rumen.Pre21JobHistoryConstants;
import org.apache.hadoop.tools.rumen.TreePath;
import org.apache.hadoop.tools.rumen.datatypes.DataType;
import org.apache.hadoop.tools.rumen.datatypes.JobName;
import org.apache.hadoop.tools.rumen.datatypes.JobProperties;
import org.apache.hadoop.tools.rumen.datatypes.QueueName;
import org.apache.hadoop.tools.rumen.datatypes.UserName;
import org.codehaus.jackson.annotate.JsonAnySetter;

public class LoggedJob
implements DeepCompare {
    private static Set<String> alreadySeenAnySetterAttributes = new TreeSet();
    JobID jobID;
    UserName user;
    long computonsPerMapInputByte = -1L;
    long computonsPerMapOutputByte = -1L;
    long computonsPerReduceInputByte = -1L;
    long computonsPerReduceOutputByte = -1L;
    long submitTime = -1L;
    long launchTime = -1L;
    long finishTime = -1L;
    int heapMegabytes = -1;
    int totalMaps = -1;
    int totalReduces = -1;
    Pre21JobHistoryConstants.Values outcome = null;
    JobType jobtype = JobType.JAVA;
    JobPriority priority = JobPriority.NORMAL;
    List<String> directDependantJobs = new ArrayList();
    List<LoggedTask> mapTasks = new ArrayList();
    List<LoggedTask> reduceTasks = new ArrayList();
    List<LoggedTask> otherTasks = new ArrayList();
    ArrayList<LoggedDiscreteCDF> successfulMapAttemptCDFs;
    ArrayList<LoggedDiscreteCDF> failedMapAttemptCDFs;
    LoggedDiscreteCDF successfulReduceAttemptCDF;
    LoggedDiscreteCDF failedReduceAttemptCDF;
    QueueName queue = null;
    JobName jobName = null;
    int clusterMapMB = -1;
    int clusterReduceMB = -1;
    int jobMapMB = -1;
    int jobReduceMB = -1;
    long relativeTime = 0L;
    double[] mapperTriesToSucceed;
    double failedMapperFraction;
    private JobProperties jobProperties = new JobProperties();

    LoggedJob() {
    }

    LoggedJob(String jobID) {
        this.setJobID(jobID);
    }

    void setJobProperties(Properties conf) {
        this.jobProperties = new JobProperties(conf);
    }

    public JobProperties getJobProperties() {
        return this.jobProperties;
    }

    void adjustTimes(long adjustment) {
        this.submitTime += adjustment;
        this.launchTime += adjustment;
        this.finishTime += adjustment;
        for (LoggedTask task : this.mapTasks) {
            task.adjustTimes(adjustment);
        }
        for (LoggedTask task : this.reduceTasks) {
            task.adjustTimes(adjustment);
        }
        for (LoggedTask task : this.otherTasks) {
            task.adjustTimes(adjustment);
        }
    }

    @JsonAnySetter
    public void setUnknownAttribute(String attributeName, Object ignored) {
        if (!alreadySeenAnySetterAttributes.contains(attributeName)) {
            alreadySeenAnySetterAttributes.add(attributeName);
            System.err.println("In LoggedJob, we saw the unknown attribute " + attributeName + ".");
        }
    }

    public UserName getUser() {
        return this.user;
    }

    void setUser(String user) {
        this.user = new UserName(user);
    }

    public JobID getJobID() {
        return this.jobID;
    }

    void setJobID(String jobID) {
        this.jobID = JobID.forName((String)jobID);
    }

    public JobPriority getPriority() {
        return this.priority;
    }

    void setPriority(JobPriority priority) {
        this.priority = priority;
    }

    public long getComputonsPerMapInputByte() {
        return this.computonsPerMapInputByte;
    }

    void setComputonsPerMapInputByte(long computonsPerMapInputByte) {
        this.computonsPerMapInputByte = computonsPerMapInputByte;
    }

    public long getComputonsPerMapOutputByte() {
        return this.computonsPerMapOutputByte;
    }

    void setComputonsPerMapOutputByte(long computonsPerMapOutputByte) {
        this.computonsPerMapOutputByte = computonsPerMapOutputByte;
    }

    public long getComputonsPerReduceInputByte() {
        return this.computonsPerReduceInputByte;
    }

    void setComputonsPerReduceInputByte(long computonsPerReduceInputByte) {
        this.computonsPerReduceInputByte = computonsPerReduceInputByte;
    }

    public long getComputonsPerReduceOutputByte() {
        return this.computonsPerReduceOutputByte;
    }

    void setComputonsPerReduceOutputByte(long computonsPerReduceOutputByte) {
        this.computonsPerReduceOutputByte = computonsPerReduceOutputByte;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    void setSubmitTime(long submitTime) {
        this.submitTime = submitTime;
    }

    public long getLaunchTime() {
        return this.launchTime;
    }

    void setLaunchTime(long startTime) {
        this.launchTime = startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    void setFinishTime(long finishTime) {
        this.finishTime = finishTime;
    }

    public int getHeapMegabytes() {
        return this.heapMegabytes;
    }

    void setHeapMegabytes(int heapMegabytes) {
        this.heapMegabytes = heapMegabytes;
    }

    public int getTotalMaps() {
        return this.totalMaps;
    }

    void setTotalMaps(int totalMaps) {
        this.totalMaps = totalMaps;
    }

    public int getTotalReduces() {
        return this.totalReduces;
    }

    void setTotalReduces(int totalReduces) {
        this.totalReduces = totalReduces;
    }

    public Pre21JobHistoryConstants.Values getOutcome() {
        return this.outcome;
    }

    void setOutcome(Pre21JobHistoryConstants.Values outcome) {
        this.outcome = outcome;
    }

    public JobType getJobtype() {
        return this.jobtype;
    }

    void setJobtype(JobType jobtype) {
        this.jobtype = jobtype;
    }

    public List<String> getDirectDependantJobs() {
        return this.directDependantJobs;
    }

    void setDirectDependantJobs(List<String> directDependantJobs) {
        this.directDependantJobs = directDependantJobs;
    }

    public List<LoggedTask> getMapTasks() {
        return this.mapTasks;
    }

    void setMapTasks(List<LoggedTask> mapTasks) {
        this.mapTasks = mapTasks;
    }

    public List<LoggedTask> getReduceTasks() {
        return this.reduceTasks;
    }

    void setReduceTasks(List<LoggedTask> reduceTasks) {
        this.reduceTasks = reduceTasks;
    }

    public List<LoggedTask> getOtherTasks() {
        return this.otherTasks;
    }

    void setOtherTasks(List<LoggedTask> otherTasks) {
        this.otherTasks = otherTasks;
    }

    public ArrayList<LoggedDiscreteCDF> getSuccessfulMapAttemptCDFs() {
        return this.successfulMapAttemptCDFs;
    }

    void setSuccessfulMapAttemptCDFs(ArrayList<LoggedDiscreteCDF> successfulMapAttemptCDFs) {
        this.successfulMapAttemptCDFs = successfulMapAttemptCDFs;
    }

    public ArrayList<LoggedDiscreteCDF> getFailedMapAttemptCDFs() {
        return this.failedMapAttemptCDFs;
    }

    void setFailedMapAttemptCDFs(ArrayList<LoggedDiscreteCDF> failedMapAttemptCDFs) {
        this.failedMapAttemptCDFs = failedMapAttemptCDFs;
    }

    public LoggedDiscreteCDF getSuccessfulReduceAttemptCDF() {
        return this.successfulReduceAttemptCDF;
    }

    void setSuccessfulReduceAttemptCDF(LoggedDiscreteCDF successfulReduceAttemptCDF) {
        this.successfulReduceAttemptCDF = successfulReduceAttemptCDF;
    }

    public LoggedDiscreteCDF getFailedReduceAttemptCDF() {
        return this.failedReduceAttemptCDF;
    }

    void setFailedReduceAttemptCDF(LoggedDiscreteCDF failedReduceAttemptCDF) {
        this.failedReduceAttemptCDF = failedReduceAttemptCDF;
    }

    public double[] getMapperTriesToSucceed() {
        return this.mapperTriesToSucceed;
    }

    void setMapperTriesToSucceed(double[] mapperTriesToSucceed) {
        this.mapperTriesToSucceed = mapperTriesToSucceed;
    }

    public double getFailedMapperFraction() {
        return this.failedMapperFraction;
    }

    void setFailedMapperFraction(double failedMapperFraction) {
        this.failedMapperFraction = failedMapperFraction;
    }

    public long getRelativeTime() {
        return this.relativeTime;
    }

    void setRelativeTime(long relativeTime) {
        this.relativeTime = relativeTime;
    }

    public QueueName getQueue() {
        return this.queue;
    }

    void setQueue(String queue) {
        this.queue = new QueueName(queue);
    }

    public JobName getJobName() {
        return this.jobName;
    }

    void setJobName(String jobName) {
        this.jobName = new JobName(jobName);
    }

    public int getClusterMapMB() {
        return this.clusterMapMB;
    }

    void setClusterMapMB(int clusterMapMB) {
        this.clusterMapMB = clusterMapMB;
    }

    public int getClusterReduceMB() {
        return this.clusterReduceMB;
    }

    void setClusterReduceMB(int clusterReduceMB) {
        this.clusterReduceMB = clusterReduceMB;
    }

    public int getJobMapMB() {
        return this.jobMapMB;
    }

    void setJobMapMB(int jobMapMB) {
        this.jobMapMB = jobMapMB;
    }

    public int getJobReduceMB() {
        return this.jobReduceMB;
    }

    void setJobReduceMB(int jobReduceMB) {
        this.jobReduceMB = jobReduceMB;
    }

    private void compare1(String c1, String c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 == null && c2 == null) {
            return;
        }
        if (c1 == null || c2 == null || !c1.equals(c2)) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
    }

    private void compare1(long c1, long c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 != c2) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
    }

    private void compare1(Pre21JobHistoryConstants.Values c1, Pre21JobHistoryConstants.Values c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 != c2) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
    }

    private void compare1(JobType c1, JobType c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 != c2) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
    }

    private void compare1(JobPriority c1, JobPriority c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 != c2) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
    }

    private void compare1(int c1, int c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 != c2) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
    }

    private void compare1(double c1, double c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 != c2) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
    }

    private void compare1(double[] c1, double[] c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 == null && c2 == null) {
            return;
        }
        TreePath recursePath = new TreePath(loc, eltname);
        if (c1 == null || c2 == null || c1.length != c2.length) {
            throw new DeepInequalityException(eltname + " miscompared", recursePath);
        }
        for (int i = 0; i < c1.length; ++i) {
            if (c1[i] == c2[i]) continue;
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname, i));
        }
    }

    private void compare1(DeepCompare c1, DeepCompare c2, TreePath loc, String eltname, int index) throws DeepInequalityException {
        if (c1 == null && c2 == null) {
            return;
        }
        TreePath recursePath = new TreePath(loc, eltname, index);
        if (c1 == null || c2 == null) {
            if (index == -1) {
                throw new DeepInequalityException(eltname + " miscompared", recursePath);
            }
            throw new DeepInequalityException(eltname + "[" + index + "] miscompared", recursePath);
        }
        c1.deepCompare(c2, recursePath);
    }

    private void compareStrings(List<String> c1, List<String> c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 == null && c2 == null) {
            return;
        }
        TreePath recursePath = new TreePath(loc, eltname);
        if (c1 == null || c2 == null || !c1.equals(c2)) {
            throw new DeepInequalityException(eltname + " miscompared", recursePath);
        }
    }

    private void compareLoggedTasks(List<LoggedTask> c1, List<LoggedTask> c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 == null && c2 == null) {
            return;
        }
        if (c1 == null || c2 == null || c1.size() != c2.size()) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
        for (int i = 0; i < c1.size(); ++i) {
            c1.get(i).deepCompare((DeepCompare)c2.get(i), new TreePath(loc, eltname, i));
        }
    }

    private void compareCDFs(List<LoggedDiscreteCDF> c1, List<LoggedDiscreteCDF> c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 == null && c2 == null) {
            return;
        }
        if (c1 == null || c2 == null || c1.size() != c2.size()) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
        for (int i = 0; i < c1.size(); ++i) {
            c1.get(i).deepCompare((DeepCompare)c2.get(i), new TreePath(loc, eltname, i));
        }
    }

    private void compareJobProperties(JobProperties jprop1, JobProperties jprop2, TreePath loc, String eltname) throws DeepInequalityException {
        if (jprop1 == null && jprop2 == null) {
            return;
        }
        if (jprop1 == null || jprop2 == null) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
        Properties prop1 = jprop1.getValue();
        Properties prop2 = jprop2.getValue();
        if (prop1.size() != prop2.size()) {
            throw new DeepInequalityException(eltname + " miscompared [size]", new TreePath(loc, eltname));
        }
        for (Map.Entry<Object, Object> entry : prop1.entrySet()) {
            String v1 = entry.getValue().toString();
            String v2 = prop2.get(entry.getKey()).toString();
            this.compare1(v1, v2, new TreePath(loc, eltname), "key:" + entry.getKey());
        }
    }

    private void compare1(DataType<String> c1, DataType<String> c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 == null && c2 == null) {
            return;
        }
        if (c1 == null || c2 == null) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
        TreePath dtPath = new TreePath(loc, eltname);
        if (!c1.getClass().getName().equals(c2.getClass().getName())) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(dtPath, "class"));
        }
        this.compare1((String)c1.getValue(), (String)c2.getValue(), dtPath, "value");
    }

    public void deepCompare(DeepCompare comparand, TreePath loc) throws DeepInequalityException {
        if (!(comparand instanceof LoggedJob)) {
            throw new DeepInequalityException("comparand has wrong type", loc);
        }
        LoggedJob other = (LoggedJob)comparand;
        this.compare1(this.jobID.toString(), other.jobID.toString(), loc, "jobID");
        this.compare1((DataType)this.user, (DataType)other.user, loc, "user");
        this.compare1(this.computonsPerMapInputByte, other.computonsPerMapInputByte, loc, "computonsPerMapInputByte");
        this.compare1(this.computonsPerMapOutputByte, other.computonsPerMapOutputByte, loc, "computonsPerMapOutputByte");
        this.compare1(this.computonsPerReduceInputByte, other.computonsPerReduceInputByte, loc, "computonsPerReduceInputByte");
        this.compare1(this.computonsPerReduceOutputByte, other.computonsPerReduceOutputByte, loc, "computonsPerReduceOutputByte");
        this.compare1(this.submitTime, other.submitTime, loc, "submitTime");
        this.compare1(this.launchTime, other.launchTime, loc, "launchTime");
        this.compare1(this.finishTime, other.finishTime, loc, "finishTime");
        this.compare1(this.heapMegabytes, other.heapMegabytes, loc, "heapMegabytes");
        this.compare1(this.totalMaps, other.totalMaps, loc, "totalMaps");
        this.compare1(this.totalReduces, other.totalReduces, loc, "totalReduces");
        this.compare1(this.outcome, other.outcome, loc, "outcome");
        this.compare1(this.jobtype, other.jobtype, loc, "jobtype");
        this.compare1(this.priority, other.priority, loc, "priority");
        this.compareStrings(this.directDependantJobs, other.directDependantJobs, loc, "directDependantJobs");
        this.compareLoggedTasks(this.mapTasks, other.mapTasks, loc, "mapTasks");
        this.compareLoggedTasks(this.reduceTasks, other.reduceTasks, loc, "reduceTasks");
        this.compareLoggedTasks(this.otherTasks, other.otherTasks, loc, "otherTasks");
        this.compare1(this.relativeTime, other.relativeTime, loc, "relativeTime");
        this.compareCDFs((List)this.successfulMapAttemptCDFs, (List)other.successfulMapAttemptCDFs, loc, "successfulMapAttemptCDFs");
        this.compareCDFs((List)this.failedMapAttemptCDFs, (List)other.failedMapAttemptCDFs, loc, "failedMapAttemptCDFs");
        this.compare1((DeepCompare)this.successfulReduceAttemptCDF, (DeepCompare)other.successfulReduceAttemptCDF, loc, "successfulReduceAttemptCDF", -1);
        this.compare1((DeepCompare)this.failedReduceAttemptCDF, (DeepCompare)other.failedReduceAttemptCDF, loc, "failedReduceAttemptCDF", -1);
        this.compare1(this.mapperTriesToSucceed, other.mapperTriesToSucceed, loc, "mapperTriesToSucceed");
        this.compare1(this.failedMapperFraction, other.failedMapperFraction, loc, "failedMapperFraction");
        this.compare1((DataType)this.queue, (DataType)other.queue, loc, "queue");
        this.compare1((DataType)this.jobName, (DataType)other.jobName, loc, "jobName");
        this.compare1(this.clusterMapMB, other.clusterMapMB, loc, "clusterMapMB");
        this.compare1(this.clusterReduceMB, other.clusterReduceMB, loc, "clusterReduceMB");
        this.compare1(this.jobMapMB, other.jobMapMB, loc, "jobMapMB");
        this.compare1(this.jobReduceMB, other.jobReduceMB, loc, "jobReduceMB");
        this.compareJobProperties(this.jobProperties, other.getJobProperties(), loc, "JobProperties");
    }
}

