/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.swift.util;

import org.apache.hadoop.fs.swift.util.Duration;

public class DurationStats {
    final String operation;
    int n;
    long sum;
    long min;
    long max;
    double mean;
    double m2;

    public DurationStats(String operation) {
        this.operation = operation;
        this.reset();
    }

    public DurationStats(DurationStats that) {
        this.operation = that.operation;
        this.n = that.n;
        this.sum = that.sum;
        this.min = that.min;
        this.max = that.max;
        this.mean = that.mean;
        this.m2 = that.m2;
    }

    public void add(Duration duration) {
        this.add(duration.value());
    }

    public void add(long x) {
        ++this.n;
        this.sum += x;
        double delta = (double)x - this.mean;
        this.mean += delta / (double)this.n;
        this.m2 += delta * ((double)x - this.mean);
        if (x < this.min) {
            this.min = x;
        }
        if (x > this.max) {
            this.max = x;
        }
    }

    public void reset() {
        this.n = 0;
        this.sum = 0L;
        this.sum = 0L;
        this.min = 10000000L;
        this.max = 0L;
        this.mean = 0.0;
        this.m2 = 0.0;
    }

    public int getCount() {
        return this.n;
    }

    public long getSum() {
        return this.sum;
    }

    public double getArithmeticMean() {
        return this.mean;
    }

    public double getVariance() {
        return this.n > 0 ? this.m2 / (double)(this.n - 1) : 0.0;
    }

    public double getDeviation() {
        double variance = this.getVariance();
        return variance > 0.0 ? Math.sqrt(variance) : 0.0;
    }

    public String toString() {
        return String.format("%s count=%d total=%.3fs mean=%.3fs stddev=%.3fs min=%.3fs max=%.3fs", this.operation, this.n, (double)this.sum / 1000.0, this.mean / 1000.0, this.getDeviation() / 1000000.0, (double)this.min / 1000.0, (double)this.max / 1000.0);
    }
}

