/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.apache.commons.io.Charsets;
import org.apache.hadoop.oncrpc.XDR;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

/*
 * Exception performing whole class analysis ignored.
 */
public final class XDR {
    private static final int DEFAULT_INITIAL_CAPACITY = 256;
    private static final int SIZEOF_INT = 4;
    private static final int SIZEOF_LONG = 8;
    private static final byte[] PADDING_BYTES = new byte[]{0, 0, 0, 0};
    private ByteBuffer buf;
    private final State state;

    public XDR(int initialCapacity) {
        this(ByteBuffer.allocate(initialCapacity), State.WRITING);
    }

    public XDR() {
        this(256);
    }

    public XDR(ByteBuffer buf, State state) {
        this.buf = buf;
        this.state = state;
    }

    public XDR(byte[] src) {
        this(ByteBuffer.wrap(src).asReadOnlyBuffer(), State.READING);
    }

    public XDR asReadOnlyWrap() {
        ByteBuffer b = this.buf.asReadOnlyBuffer();
        if (this.state == State.WRITING) {
            b.flip();
        }
        XDR n = new XDR(b, State.READING);
        return n;
    }

    public ByteBuffer buffer() {
        return this.buf.duplicate();
    }

    public int size() {
        return this.state == State.READING ? this.buf.limit() : this.buf.position();
    }

    public int readInt() {
        Preconditions.checkState((this.state == State.READING ? 1 : 0) != 0);
        return this.buf.getInt();
    }

    public void writeInt(int v) {
        this.ensureFreeSpace(4);
        this.buf.putInt(v);
    }

    public boolean readBoolean() {
        Preconditions.checkState((this.state == State.READING ? 1 : 0) != 0);
        return this.buf.getInt() != 0;
    }

    public void writeBoolean(boolean v) {
        this.ensureFreeSpace(4);
        this.buf.putInt(v ? 1 : 0);
    }

    public long readHyper() {
        Preconditions.checkState((this.state == State.READING ? 1 : 0) != 0);
        return this.buf.getLong();
    }

    public void writeLongAsHyper(long v) {
        this.ensureFreeSpace(8);
        this.buf.putLong(v);
    }

    public byte[] readFixedOpaque(int size) {
        Preconditions.checkState((this.state == State.READING ? 1 : 0) != 0);
        byte[] r = new byte[size];
        this.buf.get(r);
        this.alignPosition();
        return r;
    }

    public void writeFixedOpaque(byte[] src, int length) {
        this.ensureFreeSpace(this.alignUp(length));
        this.buf.put(src, 0, length);
        this.writePadding();
    }

    public void writeFixedOpaque(byte[] src) {
        this.writeFixedOpaque(src, src.length);
    }

    public byte[] readVariableOpaque() {
        Preconditions.checkState((this.state == State.READING ? 1 : 0) != 0);
        int size = this.readInt();
        return this.readFixedOpaque(size);
    }

    public void writeVariableOpaque(byte[] src) {
        this.ensureFreeSpace(4 + this.alignUp(src.length));
        this.buf.putInt(src.length);
        this.writeFixedOpaque(src);
    }

    public String readString() {
        return new String(this.readVariableOpaque(), Charsets.UTF_8);
    }

    public void writeString(String s) {
        this.writeVariableOpaque(s.getBytes(Charsets.UTF_8));
    }

    private void writePadding() {
        Preconditions.checkState((this.state == State.WRITING ? 1 : 0) != 0);
        int p = this.pad(this.buf.position());
        this.ensureFreeSpace(p);
        this.buf.put(PADDING_BYTES, 0, p);
    }

    private int alignUp(int length) {
        return length + this.pad(length);
    }

    private int pad(int length) {
        switch (length % 4) {
            case 1: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    private void alignPosition() {
        this.buf.position(this.alignUp(this.buf.position()));
    }

    private void ensureFreeSpace(int size) {
        Preconditions.checkState((this.state == State.WRITING ? 1 : 0) != 0);
        if (this.buf.remaining() < size) {
            int newCapacity = this.buf.capacity() * 2;
            int newRemaining = this.buf.capacity() + this.buf.remaining();
            while (newRemaining < size) {
                newRemaining += newCapacity;
                newCapacity *= 2;
            }
            ByteBuffer newbuf = ByteBuffer.allocate(newCapacity);
            this.buf.flip();
            newbuf.put(this.buf);
            this.buf = newbuf;
        }
    }

    public static boolean verifyLength(XDR xdr, int len) {
        return xdr.buf.remaining() >= len;
    }

    static byte[] recordMark(int size, boolean last) {
        byte[] b = new byte[4];
        ByteBuffer buf = ByteBuffer.wrap(b);
        buf.putInt(!last ? size : size | Integer.MIN_VALUE);
        return b;
    }

    public static ChannelBuffer writeMessageTcp(XDR request, boolean last) {
        Preconditions.checkState((request.state == State.WRITING ? 1 : 0) != 0);
        ByteBuffer b = request.buf.duplicate();
        b.flip();
        byte[] fragmentHeader = XDR.recordMark((int)b.limit(), (boolean)last);
        ByteBuffer headerBuf = ByteBuffer.wrap(fragmentHeader);
        return ChannelBuffers.copiedBuffer((ByteBuffer[])new ByteBuffer[]{headerBuf, b});
    }

    public static ChannelBuffer writeMessageUdp(XDR response) {
        Preconditions.checkState((response.state == State.READING ? 1 : 0) != 0);
        return ChannelBuffers.copiedBuffer((ByteBuffer)response.buf);
    }

    public static int fragmentSize(byte[] mark) {
        ByteBuffer b = ByteBuffer.wrap(mark);
        int n = b.getInt();
        return n & Integer.MAX_VALUE;
    }

    public static boolean isLastFragment(byte[] mark) {
        ByteBuffer b = ByteBuffer.wrap(mark);
        int n = b.getInt();
        return (n & Integer.MIN_VALUE) != 0;
    }

    @VisibleForTesting
    public byte[] getBytes() {
        ByteBuffer d = this.asReadOnlyWrap().buffer();
        byte[] b = new byte[d.remaining()];
        d.get(b);
        return b;
    }
}

