/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.response;

import org.apache.hadoop.nfs.nfs3.Nfs3Constant;
import org.apache.hadoop.nfs.nfs3.response.NFS3Response;
import org.apache.hadoop.nfs.nfs3.response.WccData;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Verifier;

public class WRITE3Response
extends NFS3Response {
    private final WccData fileWcc;
    private final int count;
    private final Nfs3Constant.WriteStableHow stableHow;
    private final long verifer;

    public WRITE3Response(int status) {
        this(status, new WccData(null, null), 0, Nfs3Constant.WriteStableHow.UNSTABLE, Nfs3Constant.WRITE_COMMIT_VERF);
    }

    public WRITE3Response(int status, WccData fileWcc, int count, Nfs3Constant.WriteStableHow stableHow, long verifier) {
        super(status);
        this.fileWcc = fileWcc;
        this.count = count;
        this.stableHow = stableHow;
        this.verifer = verifier;
    }

    public int getCount() {
        return this.count;
    }

    public Nfs3Constant.WriteStableHow getStableHow() {
        return this.stableHow;
    }

    public long getVerifer() {
        return this.verifer;
    }

    public static WRITE3Response deserialize(XDR xdr) {
        int status = xdr.readInt();
        WccData fileWcc = WccData.deserialize((XDR)xdr);
        int count = 0;
        Nfs3Constant.WriteStableHow stableHow = null;
        long verifier = 0L;
        if (status == 0) {
            count = xdr.readInt();
            int how = xdr.readInt();
            stableHow = Nfs3Constant.WriteStableHow.values()[how];
            verifier = xdr.readHyper();
        }
        return new WRITE3Response(status, fileWcc, count, stableHow, verifier);
    }

    public XDR serialize(XDR out, int xid, Verifier verifier) {
        super.serialize(out, xid, verifier);
        this.fileWcc.serialize(out);
        if (this.getStatus() == 0) {
            out.writeInt(this.count);
            out.writeInt(this.stableHow.getValue());
            out.writeLongAsHyper(this.verifer);
        }
        return out;
    }
}

