/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcMessage;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Credentials;
import org.apache.hadoop.oncrpc.security.Verifier;

public class RpcCall
extends RpcMessage {
    public static final int RPC_VERSION = 2;
    private static final Log LOG = LogFactory.getLog(RpcCall.class);
    private final int rpcVersion;
    private final int program;
    private final int version;
    private final int procedure;
    private final Credentials credentials;
    private final Verifier verifier;

    public static RpcCall read(XDR xdr) {
        return new RpcCall(xdr.readInt(), RpcMessage.Type.fromValue((int)xdr.readInt()), xdr.readInt(), xdr.readInt(), xdr.readInt(), xdr.readInt(), Credentials.readFlavorAndCredentials((XDR)xdr), Verifier.readFlavorAndVerifier((XDR)xdr));
    }

    public static RpcCall getInstance(int xid, int program, int version, int procedure, Credentials cred, Verifier verifier) {
        return new RpcCall(xid, RpcMessage.Type.RPC_CALL, 2, program, version, procedure, cred, verifier);
    }

    protected RpcCall(int xid, RpcMessage.Type messageType, int rpcVersion, int program, int version, int procedure, Credentials credential, Verifier verifier) {
        super(xid, messageType);
        this.rpcVersion = rpcVersion;
        this.program = program;
        this.version = version;
        this.procedure = procedure;
        this.credentials = credential;
        this.verifier = verifier;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)this);
        }
        this.validate();
    }

    private void validateRpcVersion() {
        if (this.rpcVersion != 2) {
            throw new IllegalArgumentException("RPC version is expected to be 2 but got " + this.rpcVersion);
        }
    }

    public void validate() {
        this.validateMessageType(RpcMessage.Type.RPC_CALL);
        this.validateRpcVersion();
    }

    public int getRpcVersion() {
        return this.rpcVersion;
    }

    public int getProgram() {
        return this.program;
    }

    public int getVersion() {
        return this.version;
    }

    public int getProcedure() {
        return this.procedure;
    }

    public Credentials getCredential() {
        return this.credentials;
    }

    public Verifier getVerifier() {
        return this.verifier;
    }

    public XDR write(XDR xdr) {
        xdr.writeInt(this.xid);
        xdr.writeInt(RpcMessage.Type.RPC_CALL.getValue());
        xdr.writeInt(2);
        xdr.writeInt(this.program);
        xdr.writeInt(this.version);
        xdr.writeInt(this.procedure);
        Credentials.writeFlavorAndCredentials((Credentials)this.credentials, (XDR)xdr);
        Verifier.writeFlavorAndVerifier((Verifier)this.verifier, (XDR)xdr);
        return xdr;
    }

    public String toString() {
        return String.format("Xid:%d, messageType:%s, rpcVersion:%d, program:%d, version:%d, procedure:%d, credential:%s, verifier:%s", this.xid, this.messageType, this.rpcVersion, this.program, this.version, this.procedure, this.credentials.toString(), this.verifier.toString());
    }
}

